/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件为 webUI 控件
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_ui_lab */
/* exported mc_ui_edit */
/* exported mc_ui_step */
/* exported mc_ui_checkbox */
/* exported mc_ui_slider */
/* exported mc_ui_select */
/* exported mc_item_js_fun */
/* exported mc_ui_radio*/
/* exported mc_ui_lan*/
/* exported mc_updata_scroll_bar_after_trans*/
/* exported mc_loading_wait*/
/* exported mc_loading_wait_remove*/
/* exported mc_ui_table*/
/* exported mc_ui_select_file*/
/* exported mc_ui_tabs*/
/* exported mc_step_add_click*/
/* exported mc_step_sub_click*/
/* exported mc_checkbox_click*/
/* exported mc_slider_mousedown*/
/* exported mc_slider_touchstart*/
/* exported mc_slider_keydown*/
/* exported mc_select_text_click*/
/* exported mc_select_txt_keyup*/
/* exported mc_select_listli_click*/
/* exported mc_select_listli_mousemove*/
/* exported mc_search_titleli_click*/
/* exported mc_heard_click*/
/* exported mc_contli_click*/
/* exported mc_fprev_click*/
/* exported mc_fnext_click*/
/* exported mc_radio_down*/
/* exported mc_radioi_mouseover*/
/* exported mc_table_click*/
/* exported mc_table_keyup*/
/* exported mc_tab_click*/
/* exported select_lan_click*/
/* exported select_lan_blur*/
/* exported select_contentli_click*/
/* exported mc_packup_side*/
/* exported set_page_title*/
/* exported get_new_lan_type*/
/* exported mc_main_alert_popout*/
/* exported mc_get_top_data */
/* exported mc_clk_select_file*/
/* exported mc_set_top_data */
/* exported mc_get_top_fun*/
/* exported radio_left_clk */
/* exported radio_right_clk*/
/* exported clearBubble*/
/* exported mc_compute_div*/
/* exported mc_iframe_autoheight */
/* exported mc_get_module_msg */
/* exported mc_editeven */
/* exported mc_ui_zoom_slider */
/* exported get_cur_pos */
/* exported mc_istouch */
/* exported mc_filter_tool */
/* exported mc_option_mouse_wheel */

/* global $ */
/* global mc_get_lang */


// 定义传递函数
var g_str_attr_lab_val_chg = "on_val_chg";
var g_obj_func_name_map = {};
// 步进编辑框或下拉菜单是否在编辑状态 避免与mc_box键盘事件冲突
var b_edit_step_select = false;
// 记录箱体连接页面滚动条是否被禁止滚动 true被禁止滚动
var b_remove_unscroll = false;

// 控件创建数量 避免创建id相同控件
var ui_lab_idx = 0;
var ui_edit_idx = 0;
var ui_step_idx = 0;
var ui_checkbox_idx = 0;
var ui_slider_idx = 0;
var ui_select_idx = 0;
var ui_radio_idx = 0;
var ui_select_file_idx = 0;
var ui_tabs_idx = 0;

// 缩放滑动条对象 {slider_id: obj}
var obj_zoom_slider = {};
// 缩放滑动条页面缩放触发函数 {slider_id: function}
var obj_zoom_slider_fn = {};

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取动态ID
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> } 动态ID
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_id() {
    return new Date().getTime() + (Math.random() * 1000).toFixed(0);
}

// 标签栏/静态文本框
function mc_ui_lab() {
    var str_lab_id = "";
    var str_lab_val = "";
    var str_lab_title = "";
    var ary_class = ["mc_lab"];
    //样式 [[width,20px],[height,20px]...]
    var ary_style = [];
    // 设置land_id开关 默认设置
    var b_set_lang_switch = true;

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的样式 宽
 * 参数:
 *     @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        ary_style.push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的样式 宽 操作dom
 * 参数:
 *     @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        document.getElementById(str_lab_id).style.width = str_width;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的样式 高
 * 参数:
 *     @param { Promise<String> } str_height 高度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        ary_style.push(["height", str_height], ["line-height", str_height]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的样式 高 操作dom
 * 参数:
 *     @param { Promise<String> } str_height 高度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        document.getElementById(str_lab_id).style.height = str_height;
        document.getElementById(str_lab_id).style.lineHeight = str_height;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的样式 字体颜色
 * 参数:
 *     @param { Promise<String> } str_color 颜色
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_color = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color) || 0 === str_color.length) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        ary_style.push(["color", str_color]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的样式 字体颜色 操作dom
 * 参数:
 *     @param { Promise<String> } str_color 颜色
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_color = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color) || 0 === str_color.length) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        document.getElementById(str_lab_id).style.color = str_color;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的样式 水平方向对其方式
 * 参数:
 *     @param { Promise<String> } str_direction 方向
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_direction = function (str_direction) {
        if ("[object String]" !== Object.prototype.toString.call(str_direction) || 0 === str_direction.length) {
            return false;
        }
        if ("left" !== str_direction && "right" !== str_direction && "center" !== str_direction) {
            return false;
        }
        ary_style.push(["text-align", str_direction]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的样式 水平方向对其方式 操作dom
 * 参数:
 *     @param { Promise<String> } str_direction 方向
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_direction = function (str_direction) {
        if ("[object String]" !== Object.prototype.toString.call(str_direction) || 0 === str_direction.length) {
            return false;
        }
        if ("left" !== str_direction && "right" !== str_direction && "center" !== str_direction) {
            return false;
        }
        document.getElementById(str_lab_id).style.textAlign = str_direction;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    静态文本框添加class类
 * 参数:
 *     @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        ary_class.push(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    静态文本框添加class类 操作dom
 * 参数:
 *     @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_lab_id).classList.add(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    移除静态文本框的class类
 * 参数:
 *     @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_del_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length || 0 === ary_class.length) {
            return false;
        }
        for (var idx_css = 1; idx_css < ary_class.length; idx_css++) {
            if (ary_class[idx_css] === str_css) {
                ary_class.splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    移除静态文本框的class类 操作dom
 * 参数:
 *     @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_del_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_lab_id).classList.remove(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    是否设置lang_id属性
 * 参数:
 *    @param { Promise<Boolean> } b_set false不设置
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.5
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_lang = function (b_set) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_set)) {
            return false;
        }
        b_set_lang_switch = b_set;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的内容
 * 参数:
 *    @param { Promise<String> } str_val 内容
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }
        str_lab_val = str_val;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的内容 操作dom
 * 参数:
 *    @param { Promise<String> } str_val 内容
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }
        var obj_lab = document.getElementById(str_lab_id);

        if (b_set_lang_switch) {
            var o_lang = mc_get_lang_obj();

            obj_lab.innerText = mc_transform_lang(o_lang, str_val);
            obj_lab.setAttribute("lang_id", str_val);
        } else {
            obj_lab.innerText = str_val;
        }
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取得静态文本框的内容
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     静态文本框的内容
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_val = function () {
        if (0 === str_lab_val.length) {
            return null;
        }
        return str_lab_val;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取得静态文本框的内容 操作dom
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     静态文本框的内容
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_dom_val = function () {
        if (b_set_lang_switch) {
            return document.getElementById(str_lab_id).getAttribute("lang_id");
        }
        return document.getElementById(str_lab_id).innerText;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取得静态文本框的ID
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     静态文本框的ID
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_lab_id.length) {
            return null;
        }
        return str_lab_id;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取得静态文本框的ID 操作dom
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     静态文本框的ID
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_dom_id = function () {
        return document.getElementById(str_lab_id).id;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的title
 * 参数:
 *    @param { Promise<String> } str_title title值
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        str_lab_title = str_title;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置静态文本框的title 操作dom
 * 参数:
 *    @param { Promise<String> } str_title title值
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        document.getElementById(str_lab_id).setAttribute("title", str_title);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    创建静态文本框标签
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     静态文本框标签
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_html_txt = function () {
        str_lab_id = "mc_lab" + ui_lab_idx + mc_get_id();
        var str_class_list = "";
        var str_style_list = "";
        var str_html = "";
        var str_lang = "";
        var obj_lang = mc_get_lang_obj();

        // 类数组转化为字符串
        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            str_class_list += ary_class[idx_class] + " ";
        }
        str_class_list = str_class_list.trim();
        // 样式数组转化为字符串 background: red;color: aqua;
        if (0 !== ary_style.length) {
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ":" + ary_style[idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }
        str_lang = judge_add_lang(str_lab_val, b_set_lang_switch, "lab");
        str_lab_val = mc_transform_lang(obj_lang, str_lab_val);
        str_html = "<div class='" + str_class_list + "' id='" + str_lab_id + "' " + str_lang + " title = '" + str_lab_title + "' style='" + str_style_list + "'>" + str_lab_val + "</div>";
        ui_lab_idx += 1;
        return str_html;
    };
}

// 编辑框
function mc_ui_edit() {
    var str_edit_id = "";
    var str_edit_val = "";
    var str_edit_title = "";
    //数据类型
    var str_edit_type = "";
    //默认最大值
    var str_edit_max = (Math.pow(2, 32) - 1).toString();
    var str_edit_min = (-Math.pow(2, 32) - 1).toString();
    // input class
    var ary_class = ["mc_edit_input"];
    // 控制外层宽高
    var ary_style = [];
    // 内层input
    var ary_input_style = [];
    // 是否禁用 默认不禁用
    var str_disabled = "";
    // 属性数组
    var ary_attr = [];
    // 默认显示位数 不设置时将为首次输入值位数 :16进制时支持补位
    var ui_default_digit = 0;

    // 数值改变触发 返回当前id与当前值 接收传递函数
    this.on_val_chg = function () { };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 宽
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        ary_style.push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 宽 操作dom
   * 参数:
   *    @param { Promise<String> } str_width 宽度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        document.getElementById(str_edit_id).parentNode.style.width = str_width;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 高
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        ary_style.push(["height", str_height]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 高 操作dom
   * 参数:
   *    @param { Promise<String> } str_height 高度
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        document.getElementById(str_edit_id).parentNode.style.height = str_height;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 边框颜色
   * 参数:
   *    @param { Promise<String> } str_color
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.11.3
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_bordercolor = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color)) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        ary_style.push(["border-color", str_color]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 字体颜色
   * 参数:
   *    @param { Promise<String> } str_color 颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_color = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color) || 0 === str_color.length) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        ary_input_style.push(["color", str_color]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的样式 字体颜色 操作dom
   * 参数:
   *    @param { Promise<String> } str_color 颜色
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_color = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color) || 0 === str_color.length) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        document.getElementById(str_edit_id).style.color = str_color;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框文字的水平对齐方式 left right center
   * 参数:
   *    @param { Promise<String> } str_direction 方向
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_style_direction = function (str_direction) {
        if ("[object String]" !== Object.prototype.toString.call(str_direction) || 0 === str_direction.length) {
            return false;
        }
        if ("left" !== str_direction && "right" !== str_direction && "center" !== str_direction) {
            return false;
        }
        ary_input_style.push(["text-align", str_direction]);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框文字的水平对齐方式 left right center 操作dom
   * 参数:
   *    @param { Promise<String> } str_direction 方向
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_direction = function (str_direction) {
        if ("[object String]" !== Object.prototype.toString.call(str_direction) || 0 === str_direction.length) {
            return false;
        }
        if ("left" !== str_direction && "right" !== str_direction && "center" !== str_direction) {
            return false;
        }
        document.getElementById(str_edit_id).style.textAlign = str_direction;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    添加编辑框的class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        ary_class.push(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    添加编辑框的class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 添加成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_edit_id).classList.add(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除编辑框的class类
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_del_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length || 0 === ary_class.length) {
            return false;
        }
        for (var idx_css = 1; idx_css < ary_class.length; idx_css++) {
            if (ary_class[idx_css] === str_css) {
                ary_class.splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    移除编辑框的class类 操作dom
   * 参数:
   *    @param { Promise<String> } str_css class类名
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 移除成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_del_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_edit_id).classList.remove(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的内容
   * 参数:
   *    @param { Promise<String> } str_val 内容字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }
        str_edit_val = str_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的内容 操作dom
   * 参数:
   *    @param {Promise<String>} str_val 内容字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }
        var mc_edit = document.getElementById(str_edit_id);

        if (mc_edit) {
            str_val = mc_edit_valcheck(mc_edit, str_val);
            mc_edit.value = str_val;
            mc_edit.setAttribute("default_val", str_val);
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取编辑框的内容
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     编辑框的内容
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_val = function () {
        if (0 === str_edit_val.length) {
            return null;
        }
        return str_edit_val;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取编辑框的内容 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     编辑框的内容
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_val = function () {
        return document.getElementById(str_edit_id).value;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取编辑框的ID
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<Strign> }
   *     编辑框的ID
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_edit_id.length) {
            return null;
        }
        return str_edit_id;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取编辑框的ID 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<Strign> }
   *     编辑框的ID
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_id = function () {
        return document.getElementById(str_edit_id).id;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的title
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        str_edit_title = str_title;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的title 操作dom
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        document.getElementById(str_edit_id).parentNode.setAttribute("title", str_title);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的数据类型 int整数 uint正整数 hex十六进制数 float浮点数
   * 参数:
   *    @param { Promise<String> } str_type 数据类型
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_type = function (str_type) {
        if ("[object String]" !== Object.prototype.toString.call(str_type) || 0 === str_type.length) {
            return false;
        }
        str_type = str_type.toUpperCase();
        str_edit_type = str_type;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框的数据类型 int整数 uint正整数 hex十六进制数 float浮点数和整数 操作dom
   * 参数:
   *    @param { Promise<String> } str_type 数据类型
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_type = function (str_type) {
        if ("[object String]" !== Object.prototype.toString.call(str_type) || 0 === str_type.length) {
            return false;
        }
        var mc_edit = document.getElementById(str_edit_id);
        // 值效验
        var str_min_val = mc_edit.getAttribute("cui_min_val");
        var str_max_val = mc_edit.getAttribute("cui_max_val");
        var str_default = mc_edit.getAttribute("default_val");

        mc_edit.setAttribute("mc_edit_type", str_type);
        str_min_val = mc_edit_valcheck(mc_edit, str_min_val);
        str_max_val = mc_edit_valcheck(mc_edit, str_max_val);
        str_default = mc_edit_valcheck(mc_edit, str_default);
        mc_edit.setAttribute("cui_min_val", str_min_val);
        mc_edit.setAttribute("cui_max_val", str_max_val);
        mc_edit.setAttribute("default_val", str_default);
        mc_edit.value = str_default;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框输入的最大值
   * 参数:
   *    @param { Promise<String> } str_max_val 最大值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_max_val = function (str_max_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_max_val) || 0 === str_max_val.length) {
            return false;
        }
        str_edit_max = str_max_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框输入的最大值 操作dom
   * 参数:
   *    @param { Promise<String> } str_max_val 最大值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_max_val = function (str_max_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_max_val) || 0 === str_max_val.length) {
            return false;
        }
        var mc_edit = document.getElementById(str_edit_id);
        var str_val = mc_edit.value;

        str_max_val = mc_edit_checkval(str_max_val, mc_edit.getAttribute("mc_edit_type"));
        mc_edit.setAttribute("cui_max_val", str_max_val);
        mc_edit.value = mc_edit_valcheck(mc_edit, str_val);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框输入的最小值
   * 参数:
   *    @param { Promise<String> } str_min_val 最小值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_min_val = function (str_min_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_min_val) || 0 === str_min_val.length) {
            return false;
        }
        str_edit_min = str_min_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置编辑框输入的最小值 操作dom
   * 参数:
   *    @param { Promise<String> } str_min_val 最小值字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.02
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_min_val = function (str_min_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_min_val) || 0 === str_min_val.length) {
            return false;
        }
        var mc_edit = document.getElementById(str_edit_id);
        var str_val = mc_edit.value;

        str_min_val = mc_edit_checkval(str_min_val, mc_edit.getAttribute("mc_edit_type"));
        mc_edit.setAttribute("cui_min_val", str_min_val);
        mc_edit.value = mc_edit_valcheck(mc_edit, str_val);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    禁用编辑框
   * 参数:
   *    @param { Promise<Boolean> } b_disable true禁用
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_disabled = function (b_disable) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_disable)) {
            return false;
        }
        if (b_disable) {
            str_disabled = "disabled";
            ary_style.push(["border-color", "#ddd"]);
            ary_input_style.push(["color", "gray"]);
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    禁用编辑框 操作dom
   * 参数:
   *    @param { Promise<String> } b_disable true禁用
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.12.20
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_disabled = function (b_disable) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_disable)) {
            return false;
        }
        var mc_edit = document.getElementById(str_edit_id);

        if (b_disable) {
            mc_edit.setAttribute("disabled", "disabled");
            mc_edit.style.color = "gray";
            mc_edit.parentNode.style.borderColor = "#ddd";
        } else {
            mc_edit.removeAttribute("disabled");
            mc_edit.style.color = "black";
            mc_edit.parentNode.style.borderColor = "gray";
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    编辑框添加属性
   * 参数:
   *    @param { Promise<Array> } arr_attr [["属性名","属性值"],...]
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.8.11
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_add_attr = function (arr_attr) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_attr) || 0 === arr_attr.length) {
            return false;
        }
        ary_attr = arr_attr;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    编辑框设置值默认位数
   * 参数:
   *    @param { Promise<Number> } ui_digit 默认位数
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.11.30
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_default_digit = function (ui_digit) {
        if ("[object Number]" !== Object.prototype.toString.call(ui_digit) || isNaN(ui_digit)) {
            return false;
        }
        ui_default_digit = ui_digit;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    创建编辑框标签
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     编辑框标签
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2019.11.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_html_txt = function () {
        str_edit_id = "mc_edit" + ui_edit_idx + mc_get_id();
        var str_class_list = "";
        var str_style_list = "";
        var str_input_style_list = "";
        var str_attr_list = "";
        var str_html = "";
        // var str_default_digit = "";

        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            str_class_list += ary_class[idx_class] + " ";
        }
        str_class_list = str_class_list.trim();

        if (0 !== ary_style.length) {
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ":" + ary_style[idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }
        if (0 !== ary_input_style.length) {
            for (var i_style = 0; i_style < ary_input_style.length; i_style++) {
                str_input_style_list += ary_input_style[i_style][0] + ":" + ary_input_style[i_style][1] + ";";
            }
            str_input_style_list = str_input_style_list.trim();
        }
        if (0 !== ary_attr.length) {
            for (var idx_attr = 0; idx_attr < ary_attr.length; idx_attr++) {
                var arr_item = ary_attr[idx_attr];

                str_attr_list += arr_item[0] + "=" + arr_item[1] + " ";
            }
        }
        str_attr_list += str_disabled;
        str_attr_list = str_attr_list.trim();
        // 触发回调函数
        var str_val_chg_callback_attr = "";
        var b_check = true;

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }

        str_edit_type = str_edit_type.toLocaleLowerCase();
        if ("int" !== str_edit_type && "uint" !== str_edit_type && "hex" !== str_edit_type && "float" !== str_edit_type) {
            b_check = false;
        }
        // 值效验
        if (b_check) {
            init_check_val();
        }
        str_edit_val = mc_escapeHtml(str_edit_val);
        str_html = "<div class='mc_edit' title ='" + str_edit_title + "' style ='" + str_style_list + "'><input id ='" + str_edit_id + "' class='" + str_class_list + "' style ='" + str_input_style_list + "' type='text' value='" + str_edit_val + "' " + str_attr_list + " " + str_val_chg_callback_attr + "   mc_edit_type = '" + str_edit_type + "' cui_max_val = '" + str_edit_max + "' cui_min_val = '" + str_edit_min + "'  default_digit = '" + ui_default_digit + "' default_val = '" + str_edit_val + "' oninput='mc_editeven(event)' onkeydown='mc_editeven(event)' onblur='mc_editeven(event)'/></div >";
        ui_edit_idx += 1;
        return str_html;
    };

    // HTML拼接字串特殊字符处理
    function mc_escapeHtml(string) {
        var entityMap = {
            "&": "&amp;",
            "<": "&lt;",
            ">": "&gt;",
            '"': "&quot;",
            "'": "&#39;",
            "/": "&#x2F;"
        };

        return String(string).replace(/[&<>"'\/]/g, function (s) {
            return entityMap[s];
        });
    }
    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *     数值效验
   * 参数:
   *    无
   * 返回：
   *    NA
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2021.01.12
   *      内容 : 所有代码
  ************************************************************************************************/
    function init_check_val() {
    // 类型效验
        str_edit_min = mc_edit_checkval(str_edit_min, str_edit_type);
        str_edit_max = mc_edit_checkval(str_edit_max, str_edit_type);
        str_edit_val = mc_edit_checkval(str_edit_val, str_edit_type);

        // 数值范围效验
        var transform_type = "parseInt";
        var transform_idx = 10;
        // 十六进制判断补零
        var b_zero_fill = false;
        // 浮点型数值小数位数
        var ui_float_dec_digit = 0;

        if ("hex" === str_edit_type) {
            transform_idx = 16;
            b_zero_fill = true;
        } else if ("float" === str_edit_type) {
            transform_type = "parseFloat";
            ui_float_dec_digit = str_edit_val.split(".")[1];
        }

        var ui_val = mc_control_transform_val(transform_type, transform_idx, str_edit_val);
        var ui_min_val = mc_control_transform_val(transform_type, transform_idx, str_edit_min);
        var ui_max_val = mc_control_transform_val(transform_type, transform_idx, str_edit_max);

        // if ("float" !== str_edit_type) {
        // str_edit_val = mc_inpval_limit(Number(str_edit_val), Number(str_edit_min), Number(str_edit_max));
        // }
        str_edit_val = mc_inpval_limit(ui_val, ui_min_val, ui_max_val);
        if ("float" === str_edit_type && ui_float_dec_digit) {
            // 保留原始小数位数
            str_edit_val = parseFloat(str_edit_val).toFixed(ui_float_dec_digit.length);
        }
        if ("hex" === str_edit_type) {
            str_edit_val = Number(str_edit_val).toString(16).toUpperCase();
        }
        var s_default_digit = str_edit_val.length;

        if ("-" === str_edit_val[0]) {
            s_default_digit--;
        }
        if (0 === ui_default_digit) {
            ui_default_digit = s_default_digit;

            // 十六进制默认4位 不足位数补零
            if (b_zero_fill && 4 > ui_default_digit) {
                ui_default_digit = 4;
                str_edit_val = (Array(4).join(0) + str_edit_val).slice(-4);
            }
        } else {
            if (s_default_digit < ui_default_digit) {
                str_edit_val = (Array(ui_default_digit).join(0) + str_edit_val).slice(-ui_default_digit);
            }
        }
    }
}

// 步进编辑框
function mc_ui_step() {
    var str_step_id = "";
    var str_step_val = "0";
    var str_step_title = "";
    var str_step_type = "";
    //默认最大值
    var str_step_max = (Math.pow(2, 32) - 1).toString();
    //默认最小值
    var str_step_min = (-Math.pow(2, 32) - 1).toString();
    //默认步进值
    var str_step = "1";
    // 默认值位数
    var str_default_digit = "";
    //[[btnClass],[inpClass]]
    var ary_class = [[], ["mc_step_inp", "mc_edit_input"]];
    //样式[[mc_step_edit_wrap],[inp]]
    var ary_style = [[], []];
    var str_show_val = null;

    // 数值改变触发 返回当前id与当前值 接受传递函数
    this.on_val_chg = function () { };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置强制显示值
     * 参数:
     *     @param { Promise<String> } str_val 宽度
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.12.11
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_show_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }
        str_show_val = str_val;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的样式 宽
 * 参数:
 *    @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        ary_style[0].push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的样式 宽 操作dom
 * 参数:
 *    @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        document.getElementById(str_step_id).parentNode.parentNode.style.width = str_width;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的样式 高
 * 参数:
 *    @param { Promise<String> } str_height 高度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        ary_style[0].push(["height", str_height]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的样式 高 操作dom
 * 参数:
 *    @param { Promise<String> } str_height 高度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        document.getElementById(str_step_id).parentNode.parentNode.style.height = str_height;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的样式 字体颜色
 * 参数:
 *    @param { Promise<String> } str_color 颜色
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_color = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color) || 0 === str_color.length) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        ary_style[1].push(["color", str_color]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的样式 字体颜色 操作dom
 * 参数:
 *    @param { Promise<String> } str_color 颜色
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_color = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color) || 0 === str_color.length) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        document.getElementById(str_step_id).style.color = str_color;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    步进编辑框inp添加class类
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_addinp_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        ary_class[1].push(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    步进编辑框inp添加class类 操作dom
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_addinp_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_step_id).classList.add(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    步进编辑框btn添加class类
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_addbtn_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        ary_class[0].push(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    步进编辑框btn添加class类 操作dom
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_addbtn_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        var o_step_inp_box = document.getElementById(str_step_id).parentNode;

        o_step_inp_box.previousSibling.classList.add(str_css);
        o_step_inp_box.nextSibling.classList.add(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    移除步进编辑框inp的class类
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 移除成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_delinp_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class[1].length; idx_css++) {
            if (ary_class[1][idx_css] === str_css) {
                ary_class[1].splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    移除步进编辑框inp的class类 操作dom
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 移除成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_delinp_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_step_id).classList.remove(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    移除步进编辑框btn的class类
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 移除成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_delbtn_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        for (var idx_css = 0; idx_css < ary_class[0].length; idx_css++) {
            if (ary_class[0][idx_css] === str_css) {
                ary_class[0].splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    移除步进编辑框btn的class类 操作dom
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 移除成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_delbtn_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        var o_step_inp_box = document.getElementById(str_step_id).parentNode;

        o_step_inp_box.previousSibling.classList.remove(str_css);
        o_step_inp_box.nextSibling.classList.remove(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的内容
 * 参数:
 *    @param { Promise<String> } str_val 内容字串
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }
        str_step_val = str_val;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的内容 操作dom
 * 参数:
 *    @param { Promise<String> } str_val 内容字串
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }
        var o_step_inp = document.getElementById(str_step_id);

        str_val = mc_edit_valcheck(o_step_inp, str_val);
        o_step_inp.setAttribute("default_val", str_val);
        o_step_inp.value = str_show_val || str_val;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取步进编辑框的内容
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     步进编辑框内容
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_val = function () {
        if (0 === str_step_val.length) {
            return null;
        }
        return str_step_val;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取步进编辑框的内容 操作dom
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     步进编辑框的内容
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_dom_val = function () {
        return document.getElementById(str_step_id).getAttribute("default_val");
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取步进编辑框的ID
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     步进编辑框的ID
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_step_id.length) {
            return null;
        }
        return str_step_id;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取步进编辑框的ID 操作dom
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     步进编辑框的ID
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_dom_id = function () {
        return document.getElementById(str_step_id).id;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的title
 * 参数:
 *    @param { Promise<String> } str_title title字串
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        str_step_title = str_title;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的title 操作dom
 * 参数:
 *    @param { Promise<String> } str_title title字串
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        document.getElementById(str_step_id).parentNode.parentNode.setAttribute("title", str_title);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的数据类型 int整数 uint正整数 hex十六进制数 float浮点数和整数
 * 参数:
 *    @param { Promise<String> } str_type 数据类型
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_type = function (str_type) {
        if ("[object String]" !== Object.prototype.toString.call(str_type) || 0 === str_type.length) {
            return false;
        }
        str_step_type = str_type;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的数据类型 int整数 uint正整数 hex十六进制数 float浮点数和整数 操作dom
 * 参数:
 *    @param { Promise<String> } str_type 数据类型
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_type = function (str_type) {
        if ("[object String]" !== Object.prototype.toString.call(str_type) || 0 === str_type.length) {
            return false;
        }
        var mc_step = document.getElementById(str_step_id);
        var str_min_val = mc_step.getAttribute("cui_min_val");
        var str_max_val = mc_step.getAttribute("cui_max_val");
        var str_default = mc_step.getAttribute("default_val");

        mc_step.setAttribute("mc_edit_type", str_type);
        str_min_val = mc_edit_valcheck(mc_step, str_min_val);
        str_max_val = mc_edit_valcheck(mc_step, str_max_val);
        str_default = mc_edit_valcheck(mc_step, str_default);
        mc_step.setAttribute("cui_min_val", str_min_val);
        mc_step.setAttribute("cui_max_val", str_max_val);
        mc_step.setAttribute("default_val", str_default);
        mc_step.value = str_show_val || str_default;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框输入的最大值
 * 参数:
 *    @param { Promise<String> } str_max_val 最大值字串
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_max_val = function (str_max_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_max_val) || 0 === str_max_val.length) {
            return false;
        }
        str_step_max = str_max_val;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框输入的最大值 操作dom
 * 参数:
 *    @param { Promise<String> } str_max_val 最大值字串
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_max_val = function (str_max_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_max_val) || 0 === str_max_val.length) {
            return false;
        }
        var mc_step = document.getElementById(str_step_id);
        var str_val = mc_step.value;

        str_max_val = mc_edit_checkval(str_max_val, mc_step.getAttribute("mc_edit_type"));
        mc_step.setAttribute("cui_max_val", str_max_val);
        mc_step.value = str_show_val || mc_edit_valcheck(mc_step, str_val);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框输入的最小值
 * 参数:
 *    @param { Promise<String> } str_min_val 最小值
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_min_val = function (str_min_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_min_val) || 0 === str_min_val.length) {
            return false;
        }
        str_step_min = str_min_val;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框输入的最小值 操作dom
 * 参数:
 *    @param { Promise<String> } str_min_val 最小值
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_min_val = function (str_min_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_min_val) || 0 === str_min_val.length) {
            return false;
        }
        var mc_step = document.getElementById(str_step_id);
        var str_val = mc_step.value;

        str_min_val = mc_edit_checkval(str_min_val, mc_step.getAttribute("mc_edit_type"));
        mc_step.setAttribute("cui_min_val", str_min_val);
        mc_step.value = str_show_val || mc_edit_valcheck(mc_step, str_val);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的步进值
 * 参数:
 *    @param { Promise<String> } s_step 步进值字串
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_step_val = function (s_step) {
        if ("[object String]" !== Object.prototype.toString.call(s_step) || 0 === s_step.length) {
            return false;
        }
        str_step = s_step;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框的步进值 操作dom
 * 参数:
 *    @param { Promise<String> } s_step 步进值字串
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_step_val = function (s_step) {
        if ("[object String]" !== Object.prototype.toString.call(s_step) || 0 === s_step.length) {
            return false;
        }
        document.getElementById(str_step_id).setAttribute("cui_step", s_step);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    创建步进编辑框标签
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     步进编辑框标签
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_html_txt = function () {
        str_step_id = "mc_step" + ui_step_idx + mc_get_id();
        var str_class_list_inp = "";
        var str_class_list_btn = "";
        var str_style_list = "";
        var str_style_inp = "";
        var str_edit_html = "";
        var str_html = "";
        // 接收函数处理
        var str_val_chg_callback_attr = "";
        var str_show_attr = "";

        if (str_show_val) {
            str_show_attr = "show_val=" + str_show_val;
        }

        // class类
        for (var idx_class = 0; idx_class < ary_class[1].length; idx_class++) {
            str_class_list_inp += ary_class[1][idx_class] + " ";
        }
        str_class_list_inp = str_class_list_inp.trim();

        if (0 !== ary_class[0].length) {
            for (var idx_class_btn = 0; idx_class_btn < ary_class[0].length; idx_class_btn++) {
                str_class_list_btn += ary_class[0][idx_class_btn] + " ";
            }
            str_class_list_btn = str_class_list_btn.trim();
        }

        // 样式
        if (0 !== ary_style[0].length) {
            for (var idx_style = 0; idx_style < ary_style[0].length; idx_style++) {
                str_style_list += ary_style[0][idx_style][0] + ":" + ary_style[0][idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }
        if (0 !== ary_style[1].length) {
            for (var idx_style_inp = 0; idx_style_inp < ary_style[1].length; idx_style_inp++) {
                str_style_inp += ary_style[1][idx_style_inp][0] + ":" + ary_style[1][idx_style_inp][1] + ";";
            }
            str_style_inp = str_style_inp.trim();
        }

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }

        // 值效验
        if (0 !== str_step_type.length) {
            str_step_min = mc_edit_checkval(str_step_min, str_step_type);

            str_step_max = mc_edit_checkval(str_step_max, str_step_type);
            str_step_val = mc_edit_checkval(str_step_val, str_step_type);
            str_default_digit = str_step_val.length;
            if ("-" === str_step_val[0]) {
                str_default_digit--;
            }
        }
        str_edit_html = "<div class='mc_edit'><input id ='" + str_step_id + "' class='" + str_class_list_inp + "' style ='" + str_style_inp + "' type='text' value='" + (str_show_val || str_step_val) + "' default_val='" + str_step_val + "' " + str_val_chg_callback_attr + " " + str_show_attr + " mc_edit_type='" + str_step_type + "' cui_step=" + str_step + " default_digit='" + str_default_digit + "' cui_min_val=" + str_step_min + " cui_max_val=" + str_step_max + " oninput='mc_editeven(event)' onkeydown='mc_editeven(event)' onblur='mc_editeven(event)'/></div >";
        str_html = "<div class='mc_step_edit_wrap mc_test_class mc_test_step_edit' title='" + str_step_title + "' style='" + str_style_list + "'><div class='mc_step_sub icon-arrow-single-left" + " " + str_class_list_btn + "' onclick='mc_step_sub_click(this)'></div>" + str_edit_html + "<div class='mc_step_add icon-arrow-single-right" + " " + str_class_list_btn + "' onclick='mc_step_add_click(this)'></div></div>";
        ui_step_idx += 1;
        return str_html;
    };
}

// 复选框
function mc_ui_checkbox() {
    var str_checkbox_id = "";
    var str_checkbox_title = "";
    var ary_class = [
        ["mc_checkbox_box", "mc_test_class", "mc_test_checkbox"],
        ["mc_checkbox_on", "checkbox_flex_box_auto_size"],
        ["mc_checkbox_off", "mc_checkbox_select_btn"]
    ];
    // 复选框 宽高[[mc_checkbox_box],[mc_checkbox_*]]
    var ary_style = [[], []];
    // 复选框选中状态
    var b_default_select = false;
    var str_text_true = "ON";
    var str_text_false = "OFF";
    // 设置land_id开关 默认不设置
    var b_set_lang_switch = true;
    // 属性数组
    var ary_attr = [];

    this.on_val_chg = function () { };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置复选框样式 宽
 * 参数:
 *    @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        ary_style[0].push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置复选框样式 宽 操作dom
 * 参数:
 *    @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        document.getElementById(str_checkbox_id).style.width = str_width;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置复选框样式 高
 * 参数:
 *    @param { Promise<String> } str_height 高度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        ary_style[0].push(["height", str_height]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置复选框样式 高 操作dom
 * 参数:
 *    @param { Promise<String> } str_height 高度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        var mc_checkbox = document.getElementById(str_checkbox_id);

        mc_checkbox.style.height = str_height;
        mc_checkbox.children[0].style.lineHeight = str_height;
        mc_checkbox.children[1].style.lineHeight = str_height;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    添加复选框的class类
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        ary_class[0].push(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    添加复选框的class类 操作dom
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_checkbox_id).classList.add(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    移除复选框class类
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 移除成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_del_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length || 0 === ary_class[0].length) {
            return false;
        }
        var arr_class = ary_class[0];

        for (var idx_css = 3; idx_css < arr_class.length; idx_css++) {
            if (arr_class[idx_css] === str_css) {
                arr_class.splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    移除复选框class类 操作dom
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 移除成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_del_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_checkbox_id).classList.remove(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置复选框的默认值 是否选中 通过控制相关类
 * 参数:
 *    @param { Promise<Boolean> } b_val true/false是否选中
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_val = function (b_val) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_val)) {
            return false;
        }
        b_default_select = b_val;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置复选框的默认值 是否选中 通过控制相关类 操作dom
 * 参数:
 *    @param { Promise<Boolean> } b_val 是否选中
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_val = function (b_val) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_val)) {
            return false;
        }
        var mc_checkbox = document.getElementById(str_checkbox_id);

        if (!mc_checkbox) {
            return false;
        }
        if (b_val) {
            mc_checkbox.setAttribute("checkbox_select", "true");
        } else {
            mc_checkbox.setAttribute("checkbox_select", "false");
        }
        checkbox_init();
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取得复选框的内容
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<Boolean> }
 *     复选框的内容
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.17
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_val = function () {
        return b_default_select;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取得复选框的内容 操作dom
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<Boolean> }
 *     复选框的内容
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.17
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_dom_val = function () {
        var str_checkbox_val = document.getElementById(str_checkbox_id).getAttribute("checkbox_select");

        if ("true" === str_checkbox_val) {
            return true;
        }
        return false;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取复选框ID
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     复选框ID
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_checkbox_id.length) {
            return null;
        }
        return str_checkbox_id;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取复选框ID 操作dom
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     复选框ID
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_dom_id = function () {
        return document.getElementById(str_checkbox_id).getAttribute("id");
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置复选框title
 * 参数:
 *    @param { Promise<String> } str_title title字串
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        str_checkbox_title = str_title;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置复选框title 操作dom
 * 参数:
 *    @param { Promise<String> } str_title title字串
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        document.getElementById(str_checkbox_id).setAttribute("title", str_title);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置提示文字
 * 参数:
 *    @param { Promise<Array> } arr_text 提示文字数组
 * 举例：
 *    ["ON","OFF"]
 * 返回：
 *    @return { Promise<Boolean> }
 *     true  设置成功
 *     false 参数错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_text = function (arr_text) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_text) || 2 !== arr_text.length) {
            return false;
        }
        str_text_true = arr_text[0];
        str_text_false = arr_text[1];
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置提示文字 操作dom
 * 参数:
 *    @param { Promise<Array> } arr_text 提示文字数组
 * 举例：
 *    ["ON","OFF"]
 * 返回：
 *    @return { Promise<Boolean> }
 *     true  设置成功
 *     false 参数错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_text = function (arr_text) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_text) || 2 === arr_text.length) {
            return false;
        }
        var mc_checkbox = document.getElementById(str_checkbox_id);
        var btn_on = mc_checkbox.children[0];
        var btn_off = mc_checkbox.children[1];

        if (b_set_lang_switch) {
            var o_lang = mc_get_lang_obj();

            btn_on.innerText = mc_transform_lang(o_lang, arr_text[0]);
            btn_off.innerText = mc_transform_lang(o_lang, arr_text[1]);
            btn_on.setAttribute("lang_id", arr_text[0]);
            btn_off.setAttribute("lang_id", arr_text[1]);
        } else {
            btn_on.innerText = arr_text[0];
            btn_off.innerText = arr_text[1];
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    复选框添加属性
   * 参数:
   *    @param { Promise<Array> } arr_attr [["属性名","属性值"],...]
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2021.03.01
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_add_attr = function (arr_attr) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_attr) || 0 === arr_attr.length) {
            return false;
        }
        ary_attr = arr_attr;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    创建复选框标签
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     复选框标签
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_html_txt = function () {
        str_checkbox_id = "mc_checkbox" + ui_checkbox_idx + mc_get_id();
        //复选框class类字串
        var str_class_box_list = "";
        var str_class_on_list = "";
        var str_class_off_list = "";
        var str_style_list = "";
        var str_text_style_list = "";
        // 触发回调函数
        var str_val_chg_callback_attr = "";
        var str_lang_true = judge_add_lang(str_text_true, b_set_lang_switch, "checkbox");
        var str_lang_false = judge_add_lang(str_text_false, b_set_lang_switch, "checkbox");
        var obj_lang = mc_get_lang_obj();
        var str_attr_list = "";

        for (var idx_box_class = 0; idx_box_class < ary_class[0].length; idx_box_class++) {
            str_class_box_list += ary_class[0][idx_box_class] + " ";
        }
        str_class_box_list = str_class_box_list.trim();

        for (var idx_on_class = 0; idx_on_class < ary_class[1].length; idx_on_class++) {
            str_class_on_list += ary_class[1][idx_on_class] + " ";
        }
        str_class_on_list = str_class_on_list.trim();

        for (var idx_off_class = 0; idx_off_class < ary_class[2].length; idx_off_class++) {
            str_class_off_list += ary_class[2][idx_off_class] + " ";
        }
        str_class_off_list = str_class_off_list.trim();

        if (0 !== ary_style[0].length) {
            for (var idx_style = 0; idx_style < ary_style[0].length; idx_style++) {
                str_style_list += ary_style[0][idx_style][0] + ":" + ary_style[0][idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }

        if (0 !== ary_style[1].length) {
            for (var idx_text_style = 0; idx_text_style < ary_style[1].length; idx_text_style++) {
                str_text_style_list += ary_style[1][idx_text_style][0] + ":" + ary_style[1][idx_text_style][1] + ";";
            }
            str_text_style_list = str_text_style_list.trim();
        }

        if (0 !== ary_attr.length) {
            for (var idx_attr = 0; idx_attr < ary_attr.length; idx_attr++) {
                var arr_item = ary_attr[idx_attr];

                str_attr_list += arr_item[0] + "=" + arr_item[1] + " ";
            }
        }
        str_attr_list = str_attr_list.trim();

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }

        str_text_true = mc_transform_lang(obj_lang, str_text_true);
        str_text_false = mc_transform_lang(obj_lang, str_text_false);
        ui_checkbox_idx += 1;
        return "<div class='" + str_class_box_list + "' id='" + str_checkbox_id + "' " + str_val_chg_callback_attr + "  style='" + str_style_list + "' title='" + str_checkbox_title + "' checkbox_select=" + b_default_select + " " + str_attr_list + " onclick='mc_checkbox_click(this)'><div class='" + str_class_on_list + "' style='" + str_text_style_list + "' " + str_lang_true + ">" + str_text_true + "</div><div class='" + str_class_off_list + "' style='" + str_text_style_list + "' " + str_lang_false + ">" + str_text_false + "</div></div>";
    };
}

// 滑动条
function mc_ui_slider() {
    var str_slider_id = "";
    var str_slider_title = "";
    var str_slider_max = "100";
    var str_slider_min = "0";
    var str_slider_step = "1";
    // 滑块默认值
    var str_slider_val = "50";
    //[[轨道],[div滑块]]
    var ary_class = [["mc_slider"], ["mc_slider_thumb"]];
    //[[轨道样式],[div滑块样式]]
    var ary_style = [[], []];
    var arr_slider_key = [];
    // 若数据字串的key按顺序排列 则为true
    var arr_slider_val = [];
    // 省略小数位数
    var ui_decimal_digit = -1;

    // 数值改变触发 返回当前id与当前值 接受传递函数
    this.on_val_chg = function () { };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置滑动条样式 宽
 * 参数:
 *    @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        ary_style[0].push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置滑动条样式 宽 操作dom
 * 参数:
 *    @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        document.getElementById(str_slider_id).style.width = str_width;
        slider_thumb_init();
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置滑动条样式 背景颜色
 * 参数:
 *    @param { Promise<String> } str_color 背景颜色
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_color = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color) || 0 === str_color.length) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        ary_style[0].push(["background-color", str_color]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置滑动条样式 背景颜色 操作dom
 * 参数:
 *    @param { Promise<String> } str_color 背景颜色
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_color = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color) || 0 === str_color.length) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        document.getElementById(str_slider_id).style.backgroundColor = str_color;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置滑动条滑块样式 显示值颜色
 * 参数:
 *    @param { Promise<String> } str_color 显示值颜色
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_thumb_color = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color) || 0 === str_color.length) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        ary_style[1].push(["color", str_color]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置滑动条滑块样式 显示值颜色 操作dom
 * 参数:
 *    @param { Promise<String> } str_color 显示值颜色
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_thumb_color = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color) || 0 === str_color.length) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        document.getElementById(str_slider_id).children[2].style.color = str_color;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    滑动条轨道添加class类
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        ary_class[0].push(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    滑动条轨道添加class类 操作dom
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_slider_id).classList.add(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    滑动条轨道移除class类
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 移除成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_del_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length || 0 === ary_class[0].length) {
            return false;
        }
        var arr_class = ary_class[0];

        for (var idx_css = 1; idx_css < arr_class.length; idx_css++) {
            if (arr_class[idx_css] === str_css) {
                arr_class.splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    滑动条轨道移除class类 操作dom
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 移除成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_del_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_slider_id).classList.remove(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    滑动条滑块添加class类
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_add_dcss = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        ary_class[1].push(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    滑动条滑块添加class类 操作dom
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_add_dcss = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_slider_id).children[2].classList.add(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    滑动条滑块移除class类
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 移除成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_del_dcss = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length || 0 === ary_class[1].length) {
            return false;
        }
        for (var idx_css = 1; idx_css < ary_class[1].length; idx_css++) {
            if (ary_class[1][idx_css] === str_css) {
                ary_class[1].splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    滑动条滑块移除class类 操作dom
     * 参数:
     *    @param { Promise<String> } str_css class类名
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 移除成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.02
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_del_dcss = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        document.getElementById(str_slider_id).children[2].classList.remove(str_css);
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条滑块默认位置 设置其left样式
     * 参数:
     *    @param { Promise<String> } str_val 位置字串 key
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.11.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }

        var i_max = parseFloat(str_slider_max);
        var i_min = parseFloat(str_slider_min);
        var i_val = parseFloat(str_val);
        var i_step = parseFloat(str_slider_step);

        // 获取对应的value
        if (0 !== arr_slider_key.length) {
            i_val = mc_slider_get_correspond_val(arr_slider_key, arr_slider_val, i_val, i_min, i_max, i_step);
        }

        var i_thumb_val = i_val * (100 / (i_max - i_min)) - i_min + 1;

        if (0 > i_thumb_val) {
            i_thumb_val = 0;
        }
        ary_style[1].push(["left", i_thumb_val + "%"]);
        str_slider_val = i_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条滑块默认位置 设置其left样式 操作dom
     * 参数:
     *    @param { Promise<String> } str_val 位置字串 key
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.02
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }
        var o_slider = document.getElementById(str_slider_id);
        var o_slider_list = o_slider.children;
        var o_thumb = o_slider_list[2];
        var i_max = parseFloat(o_slider_list[1].innerText);
        var i_min = parseFloat(o_slider_list[0].innerText);
        var i_step = parseFloat(o_thumb.getAttribute("cui_step"));
        // var i_max_left = o_slider.offsetWidth - 2 - o_thumb.offsetWidth;
        var i_max_left = o_slider.offsetWidth - o_thumb.offsetWidth + 2;
        // 总格数
        var i_grid_cnt = Math.round((i_max - i_min) / i_step);
        // 每格像素
        var i_grid_pix = i_max_left / i_grid_cnt;
        var i_val = parseFloat(str_val);
        var arr_slider_keys = o_slider.getAttribute("slider_key").split(",");
        var arr_slider_vals = o_slider.getAttribute("slider_val");

        if ("" !== arr_slider_vals) {
            arr_slider_vals = mc_slider_transform_arr_val(arr_slider_vals);
            // 获取对应val
            i_val = mc_slider_get_correspond_val(arr_slider_keys, arr_slider_vals, i_val, i_min, i_max, i_step);
        } else {
            i_val = Math.round(i_val / i_step) * i_step;
            if (i_max < i_val) {
                i_val = i_max;
            }
            if (i_min > i_val) {
                i_val = i_min;
            }
        }

        // 移动格数
        var i_grid_idx = Math.round((i_val - i_min) / i_step);
        // 移动像素
        var ui_curr_left = i_grid_idx * i_grid_pix;

        o_thumb.style.left = ui_curr_left + o_thumb.offsetWidth / 2 - 2 + "px";
        if (-1 !== ui_decimal_digit) {
            i_val = i_val.toFixed(ui_decimal_digit);
        }
        o_thumb.setAttribute("default_val", i_val);
        slider_thumb_init();
        return i_val;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条滑块滑动区间 一旦设置则开启对应值卡点
     * 参数:
     *    @param { Promise<Array> } arr_val 内容数组
     * 备注：参数格式支持两种
     *      1. [key1=val1,key2=val2]  为此格式时，改变滑动条数值触发on_val_chg 返回key；另外set_val/set_dom_val传递的参数需为key值，页面显示为val值
     *      2. [val1,val2] 为此格式时，触发on_val_chg传递的值及页面滑动条滑动显示值均为val
     *      * 滑动区间最小区间需与设置最小值一致，最大区间需与最大值一致
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.04.15
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_arr = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        var arr_dot = mc_slider_set_arr(arr_val);

        arr_slider_key = arr_dot[0];
        arr_slider_val = arr_dot[1];
        return true;
    };


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条滑块滑动区间 一旦设置则开启对应值卡点 操作dom
     * 参数:
     *    @param { Promise<Array> } arr_val 内容数组
     * 备注：参数格式支持两种
     *      1. [key1=val1,key2=val2] 为此格式时，改变滑动条数值触发on_val_chg 返回key；另外set_val/set_dom_val传递的参数需为key值，页面显示为val值
     *      2. [val1,val2] 为此格式时，触发on_val_chg传递的值及页面滑动条滑动显示值均为val
     *      * 滑动区间最小区间需与设置最小值一致，最大区间需与最大值一致
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.04.15
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_arr = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        var arr_dot = mc_slider_set_arr(arr_val);
        var o_slider = document.getElementById(str_slider_id);

        o_slider.setAttribute("slider_key", arr_dot[0]);
        o_slider.setAttribute("slider_val", arr_dot[1]);
        return true;
    };


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取滑动条ID
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<String> }
     *     滑动条ID
     *     null 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.11.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_slider_id.length) {
            return null;
        }
        return str_slider_id;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取滑动条ID 操作dom
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<String> }
     *     滑动条ID
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.02
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_dom_id = function () {
        return document.getElementById(str_slider_id).id;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条title
     * 参数:
     *    @param { Promise<String> } str_title title字串
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.11.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        str_slider_title = str_title;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条title 操作dom
     * 参数:
     *    @param { Promise<String> } str_title title字串
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.02
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        document.getElementById(str_slider_id).setAttribute("title", str_title);
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条数据的最大值
     * 参数:
     *    @param { Promise<String> } str_max_val 最大值字串
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.11.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_max_val = function (str_max_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_max_val) || 0 === str_max_val.length) {
            return false;
        }
        str_slider_max = str_max_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条数据的最大值 操作dom
     * 参数:
     *    @param { Promise<String> } str_max_val 最大值字串
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.02
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_max_val = function (str_max_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_max_val) || 0 === str_max_val.length) {
            return false;
        }
        var o_slider_list = document.getElementById(str_slider_id).children;

        o_slider_list[1].innerText = str_max_val;
        slider_thumb_init();
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条数据的最小值
     * 参数:
     *    @param { Promise<String> } str_min_val 最小值字串
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.11.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_min_val = function (str_min_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_min_val) || 0 === str_min_val.length) {
            return false;
        }
        str_slider_min = str_min_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条数据的最小值 操作dom
     * 参数:
     *    @param { Promise<String> } str_min_val 最小值字串
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.02
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_min_val = function (str_min_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_min_val) || 0 === str_min_val.length) {
            return false;
        }
        var o_slider_list = document.getElementById(str_slider_id).children;

        o_slider_list[0].innerText = str_min_val;
        slider_thumb_init();
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条的步进值
     * 参数:
     *    @param { Promise<String> } str_step_val 步进值
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.11
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_step_val = function (str_step_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_step_val) || 0 === str_step_val.length) {
            return false;
        }
        str_slider_step = str_step_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条的步进值 操作dom
     * 参数:
     *    @param { Promise<String> } str_step_val 步进值
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.11
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_step_val = function (str_step_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_step_val) || 0 === str_step_val.length) {
            return false;
        }
        document.getElementById(str_slider_id).children[2].setAttribute("cui_step", str_step_val);
        slider_thumb_init();
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置滑动条显示小数位数
     * 参数:
     *    @param { Promise<String> } ui_digit 步进值
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.06.29
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_decimal_digit = function (ui_digit) {
        if ("[OBJECT NUMBER]" !== Object.prototype.toString.call(ui_digit).toUpperCase()) {
            return false;
        }
        ui_decimal_digit = ui_digit;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    创建滑动条标签
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<String> }
     *     滑动条标签
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.11.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_html_txt = function () {
        str_slider_id = "mc_slider" + ui_slider_idx + mc_get_id();
        // 轨道 div滑块 class类
        var str_class_list_slider = "";
        var str_class_list_dthumb = "";
        var str_style_list_thumb = "";
        var str_style_list = "";
        var str_decimal_digit = "";

        for (var idx_class_slider = 0; idx_class_slider < ary_class[0].length; idx_class_slider++) {
            str_class_list_slider += ary_class[0][idx_class_slider] + " ";
        }

        for (var idx_class_dthumb = 0; idx_class_dthumb < ary_class[1].length; idx_class_dthumb++) {
            str_class_list_dthumb += ary_class[1][idx_class_dthumb] + " ";
        }
        str_class_list_slider = str_class_list_slider.trim();
        str_class_list_dthumb = str_class_list_dthumb.trim();

        // 样式
        if (0 !== ary_style[0].length) {
            for (var idx_style = 0; idx_style < ary_style[0].length; idx_style++) {
                str_style_list += ary_style[0][idx_style][0] + ":" + ary_style[0][idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }

        if (0 !== ary_style[1].length) {
            for (var idx_style_thumb = 0; idx_style_thumb < ary_style[1].length; idx_style_thumb++) {
                str_style_list_thumb += ary_style[1][idx_style_thumb][0] + ":" + ary_style[1][idx_style_thumb][1] + ";";
            }
            str_style_list_thumb = str_style_list_thumb.trim();
        }

        // 触发回调函数
        var str_val_chg_callback_attr = "";

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        if (-1 !== ui_decimal_digit) {
            str_decimal_digit = "decimal_digit=" + ui_decimal_digit;
            str_slider_val = str_slider_val.toFixed(ui_decimal_digit);
        }
        ui_slider_idx += 1;
        return (
            "<div id='" + str_slider_id + "' class='" + str_class_list_slider + "' slider_key='" + arr_slider_key + "' slider_val='" + arr_slider_val + "' title='" + str_slider_title + "' style='" + str_style_list +
      "'><div class='mc_slider_min'>" + str_slider_min +
      "</div><div class='mc_slider_max'>" + str_slider_max +
      "</div><div " + str_val_chg_callback_attr + " class='" + str_class_list_dthumb + "' style='" + str_style_list_thumb + "' cui_step='" + str_slider_step + "' " + str_decimal_digit + " default_val='" + str_slider_val + "' onmousedown='mc_slider_mousedown(this)' ontouchstart='mc_slider_touchstart(this)' onblur='mc_slider_blur(this)' onkeydown='mc_slider_keydown(this)'></div></div>"
        );
    };
}

// 下拉列表框
function mc_ui_select() {
    var str_select_id = "";
    //下拉列表值
    var arr_select_val = [];
    var str_select_title = "";
    var ary_style = [];
    // 默认值 未设置默认第一个 key返回值 val显示lang_id
    var str_default_val = "";
    var str_default_key = "";
    var ary_class = ["mc_opt_select", "mc_test_class", "mc_test_option"];
    //下拉菜单的class类
    var ary_optlist_class = [];
    // 分类列表分类头
    var arr_select_classify_title = ["ABCDE", "FGHIJ", "KLMNO", "PQRST", "UVWXYZ", "其他"];
    // 是否添加分类下拉列表 默认不添加
    var b_is_classify = false;
    // 是否开启分类下拉列表切换页码功能
    var b_is_switch_page = false;
    // 输入框是否可编辑
    var b_is_edit = true;
    // 显示元素id 下拉菜单高度自适应
    var str_show_id = null;
    var b_set_lang_switch = true;
    var str_show_val = null;

    this.on_val_chg = function () { };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置强制显示值
     * 参数:
     *     @param { Promise<String> } str_val 宽度
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.12.11
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_show_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }
        str_show_val = str_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置下拉列表的样式 宽
     * 参数:
     *     @param { Promise<String> } str_width 宽度
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.03.10
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        // 判断是替换还是增加
        var b_add = true;

        for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
            var arr_item_style = ary_style[idx_style];

            if ("width" === arr_item_style[0]) {
                arr_item_style[1] = str_width;
                b_add = false;
            }
        }
        if (b_add) {
            ary_style.push(["width", str_width]);
        }
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置下拉列表的样式 高
 * 参数:
 *     @param { Promise<String> } str_height 高度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.03.10
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        // 判断是替换还是增加
        var b_add = true;
        // var b_add_lineh = true;

        for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
            var arr_item_style = ary_style[idx_style];

            if ("height" === arr_item_style[0]) {
                arr_item_style[1] = str_height;
                b_add = false;
            }
        }
        if (b_add) {
            ary_style.push(["height", str_height]);
        }
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下拉菜单添加class类(最外层元素)
 * 参数:
 *    @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.05.06
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        ary_class.push(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下拉列表添加class类
 * 参数:
 *     @param { Promise<String> } str_css class类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.05.06
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_optlist_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        ary_optlist_class.push(str_css);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功���:
   *    处理下拉列表值为指定格式分类列表数据
   * 参数:
   *    @param { Promise<Array> } arr_val 下拉列表值
   *    @param { Promise<Array> } arr_title  分类列表分类头值
   * 返回：
   *    @return { Promise<Object> }
   *     {} 参数错误
   *     obj_cont 分类列表数据
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    function set_select_classify_data(arr_val, arr_title) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return {};
        }
        if ("[object Array]" !== Object.prototype.toString.call(arr_title) || 0 === arr_title.length) {
            return {};
        }
        var arr_val_copy = [];
        var arr_title_copy = [];

        arr_val_copy = $.extend(true, [], arr_val);
        arr_title_copy = $.extend(true, [], arr_title);

        var obj_cont_item = {};
        var arr_cont_item = [];

        for (var idx_char = 0; 26 >= idx_char; idx_char++) {
            var str_upper = String.fromCharCode(65 + idx_char);
            var str_lower = str_upper.toLowerCase();

            arr_cont_item = [];

            // 匹配开头字母分类
            for (var idx_val = 0; idx_val < arr_val_copy.length; idx_val++) {
                var str_item = arr_val_copy[idx_val];
                var str_item_val = arr_val_copy[idx_val];

                // 数据格式为 val=txt 判断
                if ("string" === typeof str_item) {
                    var i_gap_pos = str_item.indexOf("=");

                    if (1 <= i_gap_pos) {
                        str_item = str_item.substr(i_gap_pos + 1);
                    }
                    str_item = str_item.trim();
                }
                if (str_upper === str_item.charAt(0) || str_lower === str_item.charAt(0)) {
                    arr_cont_item.push(str_item_val);
                    obj_cont_item[str_upper] = arr_cont_item;
                    // 将匹配项从拷贝数组中删除
                    arr_val_copy.splice(idx_val, 1);
                    idx_val--;
                }
            }
        }

        if (0 !== arr_val_copy.length) {
            var str_other_title = arr_title_copy[arr_title_copy.length - 1];

            obj_cont_item[str_other_title] = arr_val_copy;
        }
        return obj_cont_item;
    }

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    整理分类表头数据
   * 参数:
   *    @param { Promise<Array> } arr_title 分类表头数据
   * 返回：
   *    @return { Promise<Array> }
   *     "" 参数错误
   *     整理后的分类表头数据
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.03.24
   *      内容 : 所有代码
   ************************************************************************************************/
    function get_arr_classify_head(arr_title) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_title) || 0 === arr_title.length) {
            return "";
        }
        var arr_search_title = [];
        var str_title = "";
        var str_other_t = "";

        for (var idx_title_concat = 0; idx_title_concat < arr_title.length; idx_title_concat++) {
            var str_title_item = arr_title[idx_title_concat];
            var str_last = arr_title[arr_title.length - 1];

            if ("其他" === str_last) {
                str_other_t = str_last;
                arr_title.splice(arr_title.length - 1, 1);
            }
            str_title += str_title_item;
            if (0 === (idx_title_concat + 1) % 5) {
                arr_search_title.push(str_title);
                str_title = "";
            }
        }
        if ("" !== str_title ) {
            if ("其他" !== str_title) {
                if (1 === str_title.length && 0 !== arr_search_title.length) {
                    arr_search_title[arr_search_title.length - 1] = arr_search_title[arr_search_title.length - 1] + str_title;
                } else {
                    arr_search_title.push(str_title);
                }
                if ("" !== str_other_t) {
                    arr_search_title.push(str_other_t);
                }
            } else {
                arr_search_title.push(str_title);
            }
        } else if ("其他" === str_other_t) {
            arr_search_title.push(str_other_t);
        }
        return arr_search_title;
    }

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    创建分类列表标签字串
   * 参数:
   *    @param { Promise<Object> } obj_classify_data 分类列表数据
   * 返回：
   *    @return { Promise<String> }
   *     "" 参数错误
   *     分类列表标签字串
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    function get_str_select_classify(obj_classify_data) {
        if ("[object Object]" !== Object.prototype.toString.call(obj_classify_data)) {
            return "";
        }
        // 分类下拉列表头部数据
        var arr_search_tit = [];
        var arr_search_title = [];

        if (!Object.keys) {
            // eslint-disable-next-line no-shadow
            Object.keys = function (obj_classify_data) {
                if (obj_classify_data !== Object(obj_classify_data)) {
                    throw new TypeError("Object.keys called on a non-object");
                }
                for (var p in obj_classify_data) {
                    if (Object.prototype.hasOwnProperty.call(obj_classify_data, p)) {
                        arr_search_tit.push(p);
                    }
                }
            };
        } else {
            arr_search_tit = Object.keys(obj_classify_data);
        }

        var arr_search_tit_copy = [];

        arr_search_tit_copy = $.extend(true, [], arr_search_tit);
        // 整理表头数据每5个为一项
        arr_search_title = get_arr_classify_head(arr_search_tit_copy);

        // 分类列表表头
        var str_search_title_chi = "";
        var str_sc_cont_right = "";
        // 分类下拉列表内容标签
        var str_search_cont = "";
        // 分类列表头部宽度
        var str_sc_search_title_chi_w = (100 / arr_search_title.length) + "%";
        var str_sc_cont_right_chi = "";
        var str_cont_right_chi = "";
        var ui_title_item = 0;
        var ui_ul_item = 0;
        var str_lang_id = "";
        var obj_lang = mc_get_lang_obj();

        for (var idx_title = 0; idx_title < arr_search_title.length; idx_title++) {
            // "ABCDE"
            var str_search_title_item = arr_search_title[idx_title];

            if (1 === arr_search_title.length && "其他" === str_search_title_item) {
                str_search_title_chi += "<span sc_index='" + idx_title + "' lang_id='MC_LANG_OTHER' class='sc_title_active' style='width:" + str_sc_search_title_chi_w + ";' onclick='mc_search_titleli_click(this)'>" + str_search_title_item + "</span>";
            } else {
                if (0 === idx_title) {
                    // 第一项高亮
                    str_search_title_chi = "<li sc_index='" + idx_title + "' class='sc_title_active' style='width:" + str_sc_search_title_chi_w + ";' onclick='mc_search_titleli_click(this)'>" + str_search_title_item + " </li>";
                } else {
                    if ("其他" === str_search_title_item) {
                        str_search_title_chi += "<span sc_index='" + idx_title + "' lang_id='MC_LANG_OTHER' style='width:" + str_sc_search_title_chi_w + ";' onclick='mc_search_titleli_click(this)'>" + str_search_title_item + "</span>";
                    } else {
                        str_search_title_chi += "<li sc_index='" + idx_title + "' style='width:" + str_sc_search_title_chi_w + ";' onclick='mc_search_titleli_click(this)'>" + str_search_title_item + " </li>";
                    }
                }
            }
        }

        for (var idx_p_item = 0; idx_p_item < arr_search_tit.length; idx_p_item++) {
            var str_cont_title = arr_search_tit[idx_p_item];
            // 分类列表内容右侧数据
            var arr_cont_right = obj_classify_data[str_cont_title];
            var arr_val_copy = [];

            // if ("undefined" === typeof arr_search_title[ui_title_item] ) {
            //     continue;
            // }

            // 计算次数
            var ui_title_len = arr_search_title[ui_title_item].length;

            arr_val_copy = $.extend(true, [], arr_cont_right);

            if ("其他" === str_cont_title) {
                ui_title_len = 1;
                str_cont_right_chi = "";
                for (var idx_other = 0; idx_other < arr_val_copy.length; idx_other++) {
                    var str_val_other = arr_val_copy[idx_other];
                    var str_txt_other = str_val_other;

                    if ("string" === typeof str_val_other) {
                        var i_gap_pos_other = str_val_other.indexOf("=");

                        if (1 <= i_gap_pos_other) {
                            str_val_other = str_val_other.substr(0, i_gap_pos_other);
                            str_txt_other = str_txt_other.substr(i_gap_pos_other + 1);
                        }
                        str_val_other = str_val_other.trim();
                        str_txt_other = str_txt_other.trim();
                        if (0 === str_txt_other.length) {
                            str_txt_other = str_val_other;
                        }
                    }
                    str_lang_id = judge_add_lang(str_txt_other, b_set_lang_switch, "select");
                    str_txt_other = mc_transform_lang(obj_lang, str_txt_other);
                    str_cont_right_chi += "<li value='" + str_val_other + "' " + str_lang_id + " onclick='mc_contli_click(this)'>" + str_txt_other + "</li>";
                }
                str_sc_cont_right_chi = "<ul class='sc_cont_list'> " + str_cont_right_chi + " </ul>";
            } else {
                str_cont_right_chi = "<p style=''>" + str_cont_title + "</p>";
                for (var idx_cont_rigth = 0; idx_cont_rigth < arr_val_copy.length; idx_cont_rigth++) {
                    var str_val = arr_val_copy[idx_cont_rigth];
                    var str_txt = str_val;

                    if ("string" === typeof str_val) {
                        var i_gap_pos = str_val.indexOf("=");

                        if (1 <= i_gap_pos) {
                            str_val = str_val.substr(0, i_gap_pos);
                            str_txt = str_txt.substr(i_gap_pos + 1);
                        }
                        str_val = str_val.trim();
                        str_txt = str_txt.trim();
                        if (0 === str_txt.length) {
                            str_txt = str_val;
                        }
                    }
                    str_lang_id = judge_add_lang(str_txt, b_set_lang_switch, "select");
                    str_txt = mc_transform_lang(obj_lang, str_txt);
                    str_cont_right_chi += "<li value='" + str_val + "' " + str_lang_id + " onclick='mc_contli_click(this)'>" + str_txt + "</li>";
                    arr_val_copy.splice(idx_cont_rigth, 1);
                    idx_cont_rigth--;
                }
                str_sc_cont_right_chi += "<ul class='sc_cont_list'> " + str_cont_right_chi + " </ul>";
            }

            ui_ul_item += 1;
            if (ui_title_len === ui_ul_item) {
                str_sc_cont_right = "<div class='sc_cont_right'> " + str_sc_cont_right_chi + " </div>";
                str_search_cont += "<div class='sc_search_cont" + ui_title_item + "'> " + str_sc_cont_right + " </div>";
                ui_title_item += 1;
                ui_ul_item = 0;
                str_sc_cont_right = "";
                str_sc_cont_right_chi = "";
            }
        }

        // 关闭标签
        var str_sc_heard = "<div class='sc_heard'><span></span><span style='padding-right: 6px;' onclick='mc_heard_click(this)'>&times;</span></div>";
        // 分类下拉列表头部标签
        var str_search_title = "<ul class='sc_search_title'> " + str_search_title_chi + " </ul>";
        // 尾部换页标签
        var str_sc_flip = "";

        if (b_is_switch_page) {
            str_sc_flip = "<div class='sc_flip'><span class='sc_flip_prev' onclick='mc_fprev_click(this)' lang_id='MC_LANG_PRE_PAGE'>上一页</span><i>|</i><span class='sc_flip_next' onclick='mc_fnext_click(this)' lang_id='MC_LANG_NEXT_PAGE'>下一页</span></div>";
        }
        // 分类下拉列表
        var str_select_classify = str_sc_heard + " " + str_search_title + " " + str_search_cont + " " + str_sc_flip;

        return str_select_classify;
    }

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    循环下拉列表值创建列表字串
   * 参数:
   *    @param { Promise<Array> } ary_pairs 下拉列表值
   * 返回：
   *    @return { Promise<String> }
   *     "" 参数错误
   *     str_val_list 下拉列表字串
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    function format_option_html_by_ary(ary_pairs) {
        if ("[object Array]" !== Object.prototype.toString.call(ary_pairs) || 0 === ary_pairs.length) {
            return "";
        }

        var str_val_list = "";
        var str_lang_id = "";
        var obj_lang = mc_get_lang_obj();

        for (var idx_val = 0; idx_val < ary_pairs.length; idx_val++) {
            var str_val = ary_pairs[idx_val];
            var str_txt = str_val;

            if ("string" === typeof str_val) {
                var i_gap_pos = str_val.indexOf("=");

                if (1 <= i_gap_pos) {
                    str_val = str_val.substr(0, i_gap_pos);
                    str_txt = str_txt.substr(i_gap_pos + 1);
                }
                str_val = str_val.trim();
                str_txt = str_txt.trim();
                if (0 === str_txt.length) {
                    str_txt = str_val;
                }
            }
            str_lang_id = judge_add_lang(str_txt, b_set_lang_switch, "select");
            str_txt = mc_transform_lang(obj_lang, str_txt);
            str_val_list += "<li index='" + idx_val + "' " + str_lang_id + " value='" + str_val + "' onclick='mc_select_listli_click(this)' onmousemove='mc_select_listli_mousemove(this)'>" + str_txt + "</li>";
        }

        return str_val_list;
    }

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    是否设置lang_id属性
 * 参数:
 *    @param { Promise<Boolean> } b_set false不设置
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.5
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_lang = function (b_set) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_set)) {
            return false;
        }
        b_set_lang_switch = b_set;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置下拉列表框的内容
   * 参数:
   *    @param { Promise<Array> } arr_val 内容数组
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_arr = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        // 未设置默认值则为第一个
        if (0 === str_default_val.length) {
            var str_text = arr_val[0];
            var str_val = str_text;

            if ("string" === typeof str_text) {
                var i_gap_pos = str_text.indexOf("=");

                if (1 <= i_gap_pos) {
                    str_val = str_val.substr(0, i_gap_pos);
                    str_text = str_text.substr(i_gap_pos + 1);
                }
                str_val = str_val.trim();
                str_text = str_text.trim();
            }
            str_default_key = str_val;
            str_default_val = str_text;
        }
        arr_select_val = arr_val;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置下拉列表框的内容 操作dom
   * 参数:
   *    @param { Promise<Array> } arr_val 内容数组
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_arr = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        var str_val_list = format_option_html_by_ary(arr_val);
        var o_select = document.getElementById(str_select_id);
        var o_txt = o_select.children[0].children[0];

        // 下拉列表
        o_select.children[1].innerHTML = str_val_list;
        // 分类列表
        if (o_select.children[2]) {
            var obj_select_classify_data = set_select_classify_data(arr_val, arr_select_classify_title);
            var str_select_classify = get_str_select_classify(obj_select_classify_data);

            o_select.children[2].innerHTML = str_select_classify;
        }

        arr_select_val = arr_val;
        // 设置默认值为第一项
        str_default_val = arr_val[0];
        str_default_key = str_default_val;
        if ("string" === typeof str_default_val) {
            var i_gap_pos = str_default_val.indexOf("=");

            if (1 <= i_gap_pos) {
                str_default_key = str_default_key.substr(0, i_gap_pos);
                str_default_val = str_default_val.substr(i_gap_pos + 1);
            }
            str_default_key = str_default_key.trim();
            str_default_val = str_default_val.trim();
        }
        if (b_set_lang_switch) {
            var o_lang = mc_get_lang_obj();

            o_txt.innerText = mc_transform_lang(o_lang, str_default_val);
            o_txt.setAttribute("lang_id", str_default_val);
        } else {
            o_txt.innerText = str_default_val;
        }
        o_select.setAttribute("mc_select_default", str_default_val);
        o_select.setAttribute("mc_select_val", str_default_key);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置分类列表表头
   * 参数:
   *    @param { Promise<Array> } arr_title 分类列表表头数据数组
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_classify_title = function (arr_title) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_title) || 0 === arr_title.length) {
            return false;
        }
        arr_select_classify_title = arr_title;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    取得下拉框内容 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     下拉框内容 若数据为key=value
   *     返回key
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.12.10
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_val = function () {
        return document.getElementById(str_select_id).getAttribute("mc_select_val");
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取下拉列表框ID
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     下拉列表框ID
   *     null 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_select_id.length) {
            return null;
        }
        return str_select_id;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    获取下拉列表框ID 操作dom
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     下拉列表框ID
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_dom_id = function () {
        return document.getElementById(str_select_id).id;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置下拉列表框的title
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        str_select_title = str_title;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置下拉列表框的title 操作dom
   * 参数:
   *    @param { Promise<String> } str_title title字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        document.getElementById(str_select_id).setAttribute("title", str_title);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置下拉列表框的默认值
   * 参数:
   *    @param { Promise<String> } str_default 默认值字串 key
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_val = function (str_default) {
        if ("[object String]" !== Object.prototype.toString.call(str_default) || 0 === str_default.length) {
            return false;
        }
        for (var idx_val = 0; idx_val < arr_select_val.length; idx_val++) {
            var str_val = arr_select_val[idx_val];
            var str_txt = str_val;

            if ("string" === typeof str_val) {
                var i_gap_pos = str_val.indexOf("=");

                if (1 <= i_gap_pos) {
                    str_val = str_val.substr(0, i_gap_pos);
                    str_txt = str_txt.substr(i_gap_pos + 1);
                }
                str_val = str_val.trim();
                str_txt = str_txt.trim();
                if (0 === str_txt.length) {
                    str_txt = str_val;
                }
                if (str_default === str_val) {
                    str_default_key = str_val;
                    str_default_val = str_txt;
                    return true;
                }
            }
        }
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置下拉列表框的默认值 操作dom
   * 参数:
   *    @param { Promise<String> } str_default 默认值字串 key
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_dom_val = function (str_default) {
        if ("[object String]" !== Object.prototype.toString.call(str_default) || 0 === str_default.length) {
            return false;
        }
        var obj_select = document.getElementById(str_select_id);
        var obj_text = obj_select.children[0].children[0];

        // key匹配value
        for (var idx_val = 0; idx_val < arr_select_val.length; idx_val++) {
            var str_val = arr_select_val[idx_val];
            var str_txt = str_val;

            if ("string" === typeof str_val) {
                var i_gap_pos = str_val.indexOf("=");

                if (1 <= i_gap_pos) {
                    str_val = str_val.substr(0, i_gap_pos);
                    str_txt = str_txt.substr(i_gap_pos + 1);
                }
                str_val = str_val.trim();
                str_txt = str_txt.trim();
                if (0 === str_txt.length) {
                    str_txt = str_val;
                }
                if (str_default === str_val) {
                    str_default_key = str_val;
                    str_default_val = str_txt;
                    break;
                }
            }
        }
        if (str_show_val) {
            obj_text.innerText = str_show_val;
        } else {
            if (b_set_lang_switch) {
                var o_lang = mc_get_lang_obj();

                obj_text.innerText = mc_transform_lang(o_lang, str_default_val);
                obj_text.setAttribute("lang_id", str_default_val);
            } else {
                obj_text.innerText = str_default_val;
            }
        }
        obj_select.setAttribute("mc_select_default", str_default_val);
        obj_select.setAttribute("mc_select_val", str_default_key);
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    是否创建分类下拉列表
   * 参数:
   *    @param { Promise<Boolean> } b_is_true 是否创建 false创建 true不创建
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数有误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.03.07
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_is_add_classify = function (b_is_true) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_is_true)) {
            return false;
        }
        b_is_classify = b_is_true;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    是否开启分类下拉列表页数切换 若开启默认每项每页最多显示八条数据
   * 参数:
   *    @param { Promise<Boolean> } b_is_true  true开启
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数有误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.9.28
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_is_switch_page = function (b_is_true) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_is_true)) {
            return false;
        }
        b_is_switch_page = b_is_true;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    输入框是否可编辑
   * 参数:
   *    @param { Promise<Boolean> } b_is_true 是否可编辑 true可编辑 false不可编辑
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数有误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.03.07
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_is_input_edit = function (b_is_true) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_is_true)) {
            return false;
        }
        b_is_edit = b_is_true;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    添加属性show_id 显示元素id --- 下拉菜单高度自适应无此属性默认 window高度为显示高度
   * 参数:
   *    @param { Promise<String> } str_id ID字串
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数有误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.6.28
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_attr_show_id = function (str_id) {
        if ("[object String]" !== Object.prototype.toString.call(str_id) || 0 === str_id.length) {
            return false;
        }
        str_show_id = str_id;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    创建下拉列表框标签
   * 参数:
   *    无
   * 返回：
   *    @return { Promise<String> }
   *     下拉列表框标签
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.02.19
   *      内容 : 所有代码
   ************************************************************************************************/
    this.get_html_txt = function () {
        str_select_id = "mc_option" + ui_select_idx + mc_get_id();
        var str_class_list = "";
        var str_style_list = "";
        var str_class_optlist_list = "";
        var str_input_lang = judge_add_lang(str_default_val, b_set_lang_switch, "select");
        var obj_lang = mc_get_lang_obj();
        var mouse_wheel_event = "";
        var str_show_attr = "";

        if (str_show_val) {
            str_show_attr = "show_val=" + str_show_val;
        }

        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            str_class_list += ary_class[idx_class] + " ";
        }
        str_class_list = str_class_list.trim();
        if (0 !== ary_style.length) {
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ":" + ary_style[idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }

        for (var idx_opt_class = 0; idx_opt_class < ary_optlist_class.length; idx_opt_class++) {
            str_class_optlist_list += " " + ary_optlist_class[idx_opt_class];
        }
        var str_txt = str_show_val || mc_transform_lang(obj_lang, str_default_val);
        // 创建输入框部分 have_classify是否存在分类下拉列表
        var str_input = "<div class='select_text' have_classify='" + b_is_classify + "' onclick='mc_select_text_click(this)'><div class='select_txt' " + str_input_lang + " contenteditable=" + b_is_edit + " tabindex='-1' is_edit=" + b_is_edit + " onkeyup='mc_select_txt_keyup(this)'>" + str_txt + "</div><div class='select_btn_box'><div class='select_btn'></div></div></div>";
        // 下拉列表部分
        var str_val_list = format_option_html_by_ary(arr_select_val);
        var str_select_list = "<ul class='select_list" + str_class_optlist_list + "'>" + str_val_list + "</ul>";
        // 分类列表部分
        var str_select_classify = "";

        if (b_is_classify) {
            var obj_select_classify_data = set_select_classify_data(arr_select_val, arr_select_classify_title);

            str_select_classify = get_str_select_classify(obj_select_classify_data);
            str_select_classify = "<div class='select_classify" + str_class_optlist_list + "' have_switch_page=" + b_is_switch_page + ">" + str_select_classify + "</div>";
        } else {
            mouse_wheel_event = "onmousewheel=mc_option_mouse_wheel(this,event);";
        }

        // 触发回调函数
        var str_val_chg_callback_attr = "";

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        ui_select_idx += 1;

        // show_id 显示元素id
        if (str_show_id) {
            return "<div id='" + str_select_id + "' class='" + str_class_list + "' show_id='" + str_show_id + "' title='" + str_select_title + "' style='" + str_style_list + "' mc_select_val='" + str_default_key + "' mc_select_default='" + str_default_val + "' " + str_val_chg_callback_attr + " " + str_show_attr + " > " + str_input + " " + str_select_list + " " + str_select_classify + "</div>";
        }
        return "<div id='" + str_select_id + "' class='" + str_class_list + "' title='" + str_select_title + "' style='" + str_style_list + "' mc_select_val='" + str_default_key + "' mc_select_default='" + str_default_val + "' " + str_val_chg_callback_attr + mouse_wheel_event + " " + str_show_attr + "> " + str_input + " " + str_select_list + " " + str_select_classify + "</div>";
    };
}

// 单选按钮组
function mc_ui_radio() {
    var str_radio_id = "";
    var str_radio_title = "";
    var arr_radio_val = [];
    // 整体样式 如宽高
    var ary_style = [];
    var ary_class = ["mc_radio_btn", "select_position", "mc_test_class", "mc_test_radio"];
    // 默认选中项val
    var str_default_val = "";
    var b_set_lang_switch = true;
    // 是否开启显示按钮个数限制 默认开启最大显示5个 否则显示左右按钮
    var b_limit_cnt = true;
    // 是否垂直放置 true垂直 默认水平
    var b_vertical = false;

    this.on_val_chg = function () { };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置单选按钮组的宽度
 * 参数:
 *    @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        ary_style.push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置单选按钮组的宽度 操作dom
 * 参数:
 *    @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        var obj_box = get_radio_box(str_radio_id);

        obj_box.style.width = str_width;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置单选按钮组的高度
 * 参数:
 *    @param { Promise<String> } str_height 高度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        ary_style.push(["height", str_height]);

        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置单选按钮组的高度 操作dom
 * 参数:
 *    @param { Promise<String> } str_height 高度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        document.getElementById(str_radio_id).parentNode.style.height = str_height;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    添加单选按钮组的calss类
 * 参数:
 *    @param { Promise<String> } str_css calss类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        ary_class.push(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    添加单选按钮组的calss类 操作dom
 * 参数:
 *    @param { Promise<String> } str_css calss类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 添加成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_add_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        var obj_box = get_radio_box(str_radio_id);

        obj_box.classList.add(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    移除单选按钮组的calss类
 * 参数:
 *    @param { Promise<String> } str_css calss类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 移除成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_del_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length || 0 === ary_class.length) {
            return false;
        }
        for (var idx_css = 4; idx_css < ary_class.length; idx_css++) {
            if (ary_class[idx_css] === str_css) {
                ary_class.splice(idx_css, 1);
                break;
            }
        }
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    移除单选按钮组的calss类 操作dom
 * 参数:
 *    @param { Promise<String> } str_css calss类名
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 移除成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_del_css = function (str_css) {
        if ("[object String]" !== Object.prototype.toString.call(str_css) || 0 === str_css.length) {
            return false;
        }
        var obj_box = get_radio_box(str_radio_id);

        obj_box.classList.remove(str_css);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    是否设置lang_id属性
 * 参数:
 *    @param { Promise<Boolean> } b_set false不设置
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.5
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_lang = function (b_set) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_set)) {
            return false;
        }
        b_set_lang_switch = b_set;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    是否开启显示按钮个数限制
   * 参数:
   *    @param { Promise<Boolean> } b_open false不开启
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.11.28
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_open_limit_cnt = function (b_open) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_open)) {
            return false;
        }
        b_limit_cnt = b_open;
        return true;
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置元素放置方向
   * 参数:
   *    @param { Promise<Boolean> } b_is_vertical 元素放置方向
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2021.04.22
   *      内容 : 所有代码
   ************************************************************************************************/
    this.set_direction = function (b_is_vertical) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_is_vertical)) {
            return false;
        }
        b_vertical = b_is_vertical;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    循环单选按钮组值创建单选按钮组字串
 * 参数:
 *    @param { Promise<Array> } ary_pairs 单选按钮组值
 * 返回：
 *    @return { Promise<String> }
 *     str_val_list 单选按钮组字串
 *     "" 参数错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    function format_radio_btn_html_by_ary(ary_pairs) {
        if ("[object Array]" !== Object.prototype.toString.call(ary_pairs)) {
            return "";
        }

        var i_radio_len = ary_pairs.length;
        var str_radio_w = "";
        var str_val_list = "";
        var str_lang = "";
        var obj_lang = mc_get_lang_obj();
        var str_direction_class = "mc_radio_level";

        if (b_vertical) {
            str_direction_class = "mc_radio_vertical";
        } else {
            // 单选按钮宽
            if (5 < i_radio_len && b_limit_cnt) {
                str_radio_w = "width:" + 20 + "%;";
            } else {
                str_radio_w = "width:" + 100 / i_radio_len + "%;";
            }
        }


        for (var idx_val = 0; idx_val < i_radio_len; idx_val++) {
            var str_val = ary_pairs[idx_val];
            var str_txt = str_val;

            if ("string" === typeof str_val) {
                var i_gap_pos = str_val.indexOf("=");

                if (1 <= i_gap_pos) {
                    str_val = str_val.substr(0, i_gap_pos);
                    str_txt = str_txt.substr(i_gap_pos + 1);
                }
                str_val = str_val.trim();
                str_txt = str_txt.trim();
                if (0 === str_txt.length) {
                    str_txt = str_val;
                }
            }
            str_lang = judge_add_lang(str_txt, b_set_lang_switch, "radio");
            str_txt = mc_transform_lang(obj_lang, str_txt);
            // str_val_list += "<div class='mc_radio_item mc_test_radio_item' style='" + str_radio_w + "'  value='" + str_val + "' radio_select='false' onmousedown='mc_radio_down(this)' onmouseover='mc_radioi_mouseover(this)' index='" + idx_val + "' " + str_lang + ">" + str_txt + "</div>";
            str_val_list += "<div class='mc_radio_item " + str_direction_class + " mc_test_radio_item' style='" + str_radio_w + "'  value='" + str_val + "' radio_select='false' onmousedown='mc_radio_down(this)' onmouseover='mc_radioi_mouseover(this)' index='" + idx_val + "' " + str_lang + ">" + str_txt + "</div>";
        }

        return str_val_list;
    }

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置单选按钮组的内容
 * 参数:
 *    @param { Promise<Array> } arr_val 内容数组
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_arr = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        arr_radio_val = arr_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置单选按钮组的内容 操作dom
     * 参数:
     *    @param { Promise<Array> } arr_val 内容数组
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.20
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_arr = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        var str_val_list = format_radio_btn_html_by_ary(arr_val);

        document.getElementById(str_radio_id).innerHTML = str_val_list;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    清空单选按钮组内容 操作dom
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.04.25
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_clear_arr = function () {
        document.getElementById(str_radio_id).innerHTML = "";
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取得单选按钮组的ID
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     单选按钮组的ID
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_radio_id.length) {
            return null;
        }
        return str_radio_id;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取得单选按钮组的ID 操作dom
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     单选按钮组的ID
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_dom_id = function () {
        return document.getElementById(str_radio_id).id;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置单选按钮组的title
 * 参数:
 *    @param { Promise<String> } str_title title值
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        str_radio_title = str_title;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置单选按钮组的title 操作dom
 * 参数:
 *    @param { Promise<String> } str_title title值
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.02
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        var obj_box = get_radio_box(str_radio_id);

        obj_box.setAttribute("title", str_title);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置单选按钮组的默认选中项
 * 参数:
 *    @param { Promise<String> } str_default 默认值选中项val
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.21
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_val = function (str_default) {
        if ("[object String]" !== Object.prototype.toString.call(str_default) || 0 === str_default.length) {
            return false;
        }
        str_default_val = str_default;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置单选按钮组的默认选中项 操作dom
 * 参数:
 *    @param { Promise<String> } str_default 默认选中项val
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.21
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_val = function (str_default) {
        if ("[object String]" !== Object.prototype.toString.call(str_default) || 0 === str_default.length) {
            return false;
        }
        document.getElementById(str_radio_id).setAttribute("mc_radio_default", str_default);
        radio_init();
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    创建单选按钮组标签
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     单选按钮组标签
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_html_txt = function () {
        str_radio_id = "mc_radios" + ui_radio_idx + mc_get_id();
        var str_class_list = "";
        var str_box_class_list = "";
        var str_style_list = "";
        var str_html = "";
        // 创建单选按钮组
        var str_val_list = format_radio_btn_html_by_ary(arr_radio_val);
        // 触发回调函数
        var str_val_chg_callback_attr = "";
        var str_direction_style = "";

        if (b_vertical) {
            str_direction_style = "flex-direction:column;height:100%;";
        }

        for (var idx_class = 0; idx_class < ary_class.length; idx_class++) {
            if (4 <= idx_class) {
                str_box_class_list += ary_class[idx_class] + " ";
            } else {
                str_class_list += ary_class[idx_class] + " ";
            }
        }
        str_box_class_list = str_box_class_list.trim();
        str_class_list = str_class_list.trim();
        if (0 !== ary_style.length) {
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ":" + ary_style[idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        ui_radio_idx += 1;
        str_html = "<div id='" + str_radio_id + "' class='" + str_class_list + " " + str_box_class_list + "'  title='" + str_radio_title + "' style='" + str_style_list + str_direction_style + "' " + str_val_chg_callback_attr + " mc_radio_default='" + str_default_val + "'>" + str_val_list + "</div>";
        if (5 < arr_radio_val.length && b_limit_cnt) {
            // 添加按钮
            str_box_class_list += " mc_radio_box";
            str_html = "<div class='" + str_box_class_list + "' title='" + str_radio_title + "' style='" + str_style_list + str_direction_style + "'><div class='mc_radio_left icon-arrow-single-left' onclick='radio_left_clk(this)'></div><div id='" + str_radio_id + "' class='" + str_class_list + "' style='" + str_direction_style + "' rl_btn='true' " + str_val_chg_callback_attr + " mc_radio_default='" + str_default_val + "'>" + str_val_list + "</div><div class='mc_radio_right icon-arrow-single-right' onclick='radio_right_clk(this)'></div></div>";
        }
        return str_html;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取radio设置样式对象盒子
 * 参数:
 *    @param { Promise<String> } str_id radio_id
 * 返回：
 *    @return { Promise<Object> }
 *      false 参数有误
 *      盒子对象
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.9.2
 *      内容 : 所有代码
 ************************************************************************************************/
    function get_radio_box(str_id) {
        if ("string" !== typeof str_id || 0 === str_id.length) {
            return false;
        }
        var obj_box = document.getElementById(str_id);

        if (-1 !== obj_box.parentNode.className.indexOf("mc_radio_box")) {
            obj_box = obj_box.parentNode;
        }
        return obj_box;
    }
}

// 表格
function mc_ui_table() {
    var str_table_id = "";
    // 表头内容数组
    var arr_table_title = [];
    // 表格内容数组
    var arr_table_val = [];
    // 是否可写数组
    var arr_editable = [];
    // 可写值类型
    var arr_val_type = [];
    // 是否为标签数组
    var arr_bhtml = [];
    var arr_style = [];
    var b_set_lang_switch = true;
    // 是否进行格子合并 此项开启 格子内容为false时不创建
    var b_concat_grid = false;
    // 合并格子高度修改
    var arr_grid_h = [];
    // 图标项
    var arr_grid_icon = [];
    // 默认格子高度
    var ui_grid_h = 38;

    this.on_val_chg = function () { };


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    是否开启格子合并
     * 参数:
     *    @param { Promise<Boolean> } b_flag
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.06.02
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_open_grid_concat = function (b_flag) {
        b_concat_grid = b_flag;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置合并项高度
     * 参数:
     *    @param { Promise<Array> } ary_grid_h
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.06.02
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_concat_grid_h = function (ary_grid_h) {
        if ("[object Array]" !== Object.prototype.toString.call(ary_grid_h)) {
            return false;
        }
        arr_grid_h = ary_grid_h;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格图标项
     * 参数:
     *    @param { Promise<Array> } ary_grid_icon
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.06.02
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_grid_cont_icon = function (ary_grid_icon) {
        if ("[object Array]" !== Object.prototype.toString.call(ary_grid_icon)) {
            return false;
        }
        arr_grid_icon = ary_grid_icon;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格高度
     * 参数:
     *    @param { Promise<String> } str_height 高度
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.26
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        arr_style.push(["height", str_height]);
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格高度 操作dom
     * 参数:
     *    @param { Promise<String> } str_height 高度
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.26
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        $("#" + str_table_id).css("height", str_height);
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    是否设置lang_id属性
     * 参数:
     *    @param { Promise<Boolean> } b_set false不设置
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2020.11.5
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_lang = function (b_set) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_set)) {
            return false;
        }
        b_set_lang_switch = b_set;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格表头内容
     * 参数:
     *    @param { Promise<Array> } arr_title_val 内容数组
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.23
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_title_val = function (arr_title_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_title_val) || 0 === arr_title_val.length) {
            return false;
        }
        arr_table_title = arr_title_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格表头内容 操作dom
     * 参数:
     *    @param { Promise<Array> } arr_title_val 内容数组
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.26
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_title_val = function (arr_title_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_title_val) || 0 === arr_title_val.length) {
            return false;
        }
        var arr_header = $("#" + str_table_id).children().eq(0);
        var arr_header_dom = arr_header.children();
        var i_dom_header_len = arr_header.children().length;
        var i_header_len = arr_title_val.length;
        var str_div_w = 100 / i_header_len + "%";
        var obj_lang = mc_get_lang_obj();

        if (i_header_len > i_dom_header_len) {
            var i_add_num = i_header_len - i_dom_header_len;
            var str_add_dom = "";

            // 添加超出格
            for (var idx_add = 0; idx_add < i_add_num; idx_add++) {
                str_add_dom += "<div></div>";
            }
            arr_header.append(str_add_dom);
            arr_header_dom = arr_header.children();

            for (var idx_dom_add = 0; idx_dom_add < arr_title_val.length; idx_dom_add++) {
                var o_title = arr_header_dom.eq(idx_dom_add);
                var str_val = arr_title_val[idx_dom_add];

                set_table_lang_id(o_title, str_val);
                str_val = mc_transform_lang(obj_lang, str_val);
                o_title.text(str_val).css("width", str_div_w);
            }
        }
        if (i_header_len < i_dom_header_len) {
            var i_del_num = i_dom_header_len - i_header_len;

            // 删除多余格
            for (var idx_del = 0; idx_del < i_del_num; idx_del++) {
                arr_header_dom.eq(i_dom_header_len - 1 - idx_del).remove();
            }
            for (var idx_dom_del = 0; idx_dom_del < arr_title_val.length; idx_dom_del++) {
                var o_header_dom = arr_header_dom.eq(idx_dom_del);
                var str_v = arr_title_val[idx_dom_del];

                set_table_lang_id(o_header_dom, str_v);
                str_v = mc_transform_lang(obj_lang, str_v);
                o_header_dom.text(str_v).css("width", str_div_w);
            }
        } else {
            for (var idx_dom = 0; idx_dom < arr_title_val.length; idx_dom++) {
                var obj_target = arr_header_dom.eq(idx_dom);
                var str_title = arr_title_val[idx_dom];

                set_table_lang_id(obj_target, str_title);
                str_title = mc_transform_lang(obj_lang, str_title);
                obj_target.text(str_title);
            }
        }
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格内容
     * 参数:
     *    @param { Promise<Array> } arr_val 内容数组 多维数组 数组中每一项数据为一行数据
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.23
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_val = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        arr_table_val = arr_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格内容 操作dom
     * 参数:
     *    @param { Promise<Array> } arr_val 内容数组
     *    @param { Promise<Array> } arr_editable_val 是否可编辑标识 可为空
     *    @param { Promise<Array> } arr_bhtml_val 内容是否为标签 可为空
     *    @param { Promise<Array> } arr_type_val 内容输入数值类型 可为空
     * 备注：
     *    若内容数组行列数量不变只做内容修改 二三参数可为空
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.26
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_val = function (arr_val, arr_editable_val, arr_bhtml_val,arr_type_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }

        // body
        var arr_body = $("#" + str_table_id).children().eq(1);
        var arr_body_row = arr_body.children();
        var i_old_val_row = arr_body_row.length;
        var i_old_val_col = arr_body_row.eq(0).children().length;
        var i_new_val_row = arr_val.length;
        var i_new_val_col = arr_val[0].length;
        var str_li_w = 100 / i_new_val_col + "%";
        var obj_lang = mc_get_lang_obj();
        var str_lang = judge_add_lang("", b_set_lang_switch, "table");

        // 确定列数
        if (i_new_val_col > i_old_val_col) {
            var i_add_col_num = i_new_val_col - i_old_val_col;
            var str_add_col_li = "";

            for (var idx_add_col = 0; idx_add_col < i_add_col_num; idx_add_col++) {
                str_add_col_li += "<li " + str_lang + " onclick='mc_table_click(this)' onblur='mc_table_blur(this)' onkeyup='mc_table_keyup(this)'></li>";
            }
            for (var idx_tr = 0; idx_tr < i_old_val_row; idx_tr++) {
                arr_body_row.eq(idx_tr).append(str_add_col_li);
            }
        }

        if (i_new_val_col < i_old_val_col) {
            var i_del_col_li = i_old_val_col - i_new_val_col;

            for (var idx_del_ul = 0; idx_del_ul < i_old_val_row; idx_del_ul++) {
                for (var idx_del_col = 0; idx_del_col < i_del_col_li; idx_del_col++) {
                    arr_body_row.eq(idx_del_ul).children().eq(i_old_val_col - 1 - idx_del_col).remove();
                }
            }
        }

        // 确定行数
        if (i_new_val_row > i_old_val_row) {
            var i_add_row_num = i_new_val_row - i_old_val_row;
            var str_add_row_li = "";
            var str_add_row = "";

            for (var idx_add_row_li = 0; idx_add_row_li < i_new_val_col; idx_add_row_li++) {
                str_add_row_li += "<li " + str_lang + " onclick='mc_table_click(this)' onblur='mc_table_blur(this)' onkeyup='mc_table_keyup(this)'></li>";
            }
            for (var idx_add_row = 0; idx_add_row < i_add_row_num; idx_add_row++) {
                str_add_row += "<ul class='table_row'>" + str_add_row_li + "</ul>";
            }
            arr_body.append(str_add_row);
        }

        if (i_new_val_row < i_old_val_row) {
            var i_del_row_num = i_old_val_row - i_new_val_row;

            for (var idx_del_row = 0; idx_del_row < i_del_row_num; idx_del_row++) {
                arr_body_row.eq(i_old_val_row - 1 - idx_del_row).remove();
            }
        }

        update_data(arr_editable_val, arr_bhtml_val,arr_type_val);
        arr_table_val = arr_val;
        // 更改数据
        i_old_val_row = arr_body.children().length;
        i_old_val_col = arr_body.children().eq(0).children().length;
        for (var idx_ul = 0; idx_ul < i_old_val_row; idx_ul++) {
            for (var idx_li = 0; idx_li < i_old_val_col; idx_li++) {
                var obj_target = arr_body.children().eq(idx_ul).children().eq(idx_li);

                update_dom_attr(obj_target, idx_ul, idx_li);
            }
        }
        return true;

        function update_dom_attr(o_target, i_ul, i_li) {
            var s_txt = arr_val[i_ul][i_li];
            var b_lang = false;

            // 添加格子内容是否为标签标识
            if (0 !== arr_bhtml.length && arr_bhtml[i_ul] && arr_bhtml[i_ul][i_li]) {
                b_lang = true;
                o_target.attr("b_html", arr_bhtml[i_ul][i_li]);
            }

            if (0 !== arr_editable.length && arr_editable[i_ul] && arr_editable[i_ul][i_li]) {
                // 添加可编辑属性
                o_target.attr("contenteditable", arr_editable[i_ul][i_li]);
            }
            if (0 !== arr_val_type.length && arr_val_type[i_ul] && arr_val_type[i_ul][i_li]) {
                // 添加可编辑属性
                o_target.attr("mc_edit_type", arr_val_type[i_ul][i_li]);
            }
            set_table_lang_id(o_target, s_txt, b_lang);
            s_txt = mc_transform_lang(obj_lang, s_txt);
            o_target.html(s_txt).css("width", str_li_w);
            return true;
        }
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格输入值类型 可写时
     * 参数:
     *    @param { Promise<Array> } arr_val 与内容相同的多维数组
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.11.26
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_editable_val_type = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        arr_val_type = arr_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格输入值类型 可写时 DOM
     * 参数:
     *    @param { Promise<Array> } arr_val 与内容相同的多维数组
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.11.26
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_editable_val_type = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        arr_val_type = arr_val;
        var arr_ul = $("#" + str_table_id).children().eq(1).children();
        var i_li_len = arr_ul.eq(0).children().length;

        for (var idx_ul = 0; idx_ul < arr_ul.length; idx_ul++) {
            for (var idx_li = 0; idx_li < i_li_len; idx_li++) {
                var obj_li = arr_ul.eq(idx_ul).children().eq(idx_li);

                if (!arr_val[idx_ul][idx_li]) {
                    obj_li.removeAttr("mc_edit_type");
                } else {
                    obj_li.attr("mc_edit_type", arr_val[idx_ul][idx_li]);
                }
            }
        }
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格内容是否可写
     * 参数:
     *    @param { Promise<Array> } arr_val 与内容相同的多维数组
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.23
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_editable = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        arr_editable = arr_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格内容是否可写 操作dom
     * 参数:
     *    @param { Promise<Array> } arr_val
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.26
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_editable = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        arr_editable = arr_val;
        var arr_ul = $("#" + str_table_id).children().eq(1).children();
        var i_li_len = arr_ul.eq(0).children().length;

        for (var idx_ul = 0; idx_ul < arr_ul.length; idx_ul++) {
            for (var idx_li = 0; idx_li < i_li_len; idx_li++) {
                var obj_li = arr_ul.eq(idx_ul).children().eq(idx_li);

                if (!arr_val[idx_ul][idx_li]) {
                    obj_li.removeAttr("contenteditable");
                } else {
                    obj_li.attr("contenteditable", arr_val[idx_ul][idx_li]);
                }
            }
        }
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格内容是否为标签
     * 参数:
     *    @param { Promise<Array> } arr_val 与内容相同的多维数组 true表示为标签
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.03.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_content_html = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        arr_bhtml = arr_val;
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置表格内容是否为标签 操作dom
     * 参数:
     *    @param { Promise<Array> } arr_val
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.03.19
     *      内容 : 所有代码
     ************************************************************************************************/
    this.set_dom_content_html = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        arr_bhtml = arr_val;
        var arr_ul = $("#" + str_table_id).children().eq(1).children();
        var i_li_len = arr_ul.eq(0).children().length;

        for (var idx_ul = 0; idx_ul < arr_ul.length; idx_ul++) {
            for (var idx_li = 0; idx_li < i_li_len; idx_li++) {
                arr_ul.eq(idx_ul).children().eq(idx_li).attr("b_html", arr_val[idx_ul][idx_li]);
            }
        }
        return true;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    取得表格的ID
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<String> }
     *     表格的ID
     *     null 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.30
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_table_id.length) {
            return null;
        }
        return str_table_id;
    };

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    取得表格的ID 操作dom
    * 参数:
    *    无
    * 返回：
    *    @return { Promise<String> }
    *     表格的ID
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 陈小荟
    *      时间 : 2019.12.30
    *      内容 : 所有代码
    ************************************************************************************************/
    this.get_dom_id = function () {
        return $("#" + str_table_id).attr("id");
    };

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    取得表格的内容 操作dom
    * 参数:
    *    无
    * 返回：
    *    @return { Promise<Array> }
    *     表格内容数组
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 陈小荟
    *      时间 : 2019.12.30
    *      内容 : 所有代码
    ************************************************************************************************/
    this.get_table_val = function () {
        var arr_ul = $("#" + str_table_id).children().eq(1).children();
        var arr_val = [];

        for (var idx_ul = 0; idx_ul < arr_ul.length; idx_ul++) {
            var o_ul = arr_ul.eq(idx_ul).children();
            var arr_table_li = [];

            for (var idx_li = 0; idx_li < o_ul.length; idx_li++) {
                var o_li = o_ul[idx_li];
                var str_lang_val = o_li.getAttribute("lang_id");
                var str_b_html = o_li.getAttribute("b_html");

                if ("true" === str_b_html) {
                    arr_table_li.push(o_li.innerHTML);
                } else {
                    if (b_set_lang_switch && str_lang_val) {
                        arr_table_li.push(o_li.getAttribute("lang_id"));
                    } else {
                        arr_table_li.push(o_li.innerText);
                    }
                }
            }
            arr_val.push(arr_table_li);
        }
        return arr_val;
    };

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    取得表格指定行内容
    * 参数:
    *    @param { Promise<Number> } ui_row_idx 指定行下标 由0开始
    * 返回：
    *    @return { Promise<Array> }
    *     [] 参数有误 无对应行
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 陈小荟
    *      时间 : 2021.08.27
    *      内容 : 所有代码
    ************************************************************************************************/
    this.get_table_row_val = function (ui_row_idx) {
        if ("[object Number]" !== Object.prototype.toString.call(ui_row_idx) || isNaN(ui_row_idx)) {
            return [];
        }
        var obj_table_body = $("#" + str_table_id).children(".mc_table_body").children();
        var ui_row_len = obj_table_body.length;

        if (0 === ui_row_len || ui_row_idx >= ui_row_len) {
            return [];
        }
        // 移除行
        var arr_row_item = obj_table_body.eq(ui_row_idx).children();
        var arr_val = [];

        for (var idx = 0; idx < arr_row_item.length; idx++) {
            arr_val.push(arr_row_item.eq(idx).text());
        }
        return arr_val;
    };

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    删除指定行 操作dom
    * 参数:
    *    @param { Promise<Number> } ui_row_idx 指定行下标 由0开始 若不存在此行不进行删除
    *    @param { Promise<Number> } ui_update_first_col 有序起始数：更新第一列显示内容 可为空（默认不更新）
    * 返回：
    *    @return { Promise<Boolean> }
    *     false 参数有误
    *     true 删除成功
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 陈小荟
    *      时间 : 2021.03.20
    *      内容 : 所有代码
    ************************************************************************************************/
    this.delete_table_row = function (ui_row_idx, ui_update_first_col) {
        if ("[object Number]" !== Object.prototype.toString.call(ui_row_idx) || isNaN(ui_row_idx)) {
            return false;
        }
        if (!document.getElementById(str_table_id)) {
            return false;
        }
        var obj_table_body = $("#" + str_table_id).children(".mc_table_body").children();
        var ui_row_len = obj_table_body.length;

        if (0 === ui_row_len || ui_row_idx >= ui_row_len) {
            return false;
        }
        // 移除行
        obj_table_body.eq(ui_row_idx).remove();
        // 更新数据
        arr_table_val.splice(ui_row_idx, 1);
        arr_editable.splice(ui_row_idx, 1);
        arr_bhtml.splice(ui_row_idx, 1);
        arr_val_type.splice(ui_row_idx,1);

        // 更新第一列显示内容
        if ("[object Number]" === Object.prototype.toString.call(ui_update_first_col) && !isNaN(ui_update_first_col)) {
            obj_table_body = $("#" + str_table_id).children(".mc_table_body").children();
            update_first_row(obj_table_body,ui_update_first_col);
        }
        return true;
    };

    /************************************************************************************************
  * 类型:
  *    函数
  * 功能:
  *    指定位置添加行 操作dom
  * 参数:
  *    @param { Promise<Number> } ui_row_idx 指定行下标 由0开始 (若指定行下标不存在默认添加末尾行，若下标小于等于0添加起始行)
  *    @param { Promise<Array> } arr_row_val 添加行内容 一维数组
  *    @param { Promise<Array> } arr_editable_val 添加行是否可编辑 一维数组 (可为空 但若之前存在相关设置不可为空)
  *    @param { Promise<Array> } arr_bhtml_val 添加行内容项是否为标签 一维数组 (可为空 但若之前存在相关设置不可为空)
  *    @param { Promise<Boolean> } b_update_first 是否按顺序更新第一列内容 可为空
  *    @param { Promise<Array> } arr_type_val 添加行输入值类型 (可为空)
  * 返回：
  *    @return { Promise<Boolean> }
  *     false 参数有误
  *     true 添加成功
  * 修改:
  *   1. 类型 : 创建
  *      作者 : 陈小荟
  *      时间 : 2021.03.20
  *      内容 : 所有代码
  ************************************************************************************************/
    this.add_table_row = function (ui_row_idx, arr_row_val, arr_editable_val, arr_bhtml_val,b_update_first,arr_type_val) {
        if (!judge_param()) {
            return false;
        }
        var obj_body_content = $("#" + str_table_id).children(".mc_table_body");
        var obj_table_body = obj_body_content.children();
        var ui_row_len = obj_table_body.length;
        var i_table_title_len = arr_row_val.length;
        var str_div_w = 100 / i_table_title_len + "%";
        var str_add_html = get_row_html();

        if (0 === ui_row_len) {
            // 直接添加
            ui_row_idx = 0;
            obj_body_content.append(str_add_html);
        } else {
            if (ui_row_idx >= ui_row_len) {
            // 末尾添加行
                ui_row_idx = ui_row_len;
            }
            ui_row_idx -= 1;
            if (0 > ui_row_idx) {
                ui_row_idx = 0;
                obj_table_body.eq(ui_row_idx).before(str_add_html);
            } else {
                obj_table_body.eq(ui_row_idx).after(str_add_html);
                ui_row_idx += 1;
            }

            // 更新第一列
            if (b_update_first) {
                obj_table_body = obj_body_content.children();
                var ui_text = Number(arr_row_val[0]) + 1;

                update_first_row(obj_table_body,ui_text,ui_row_idx + 1);
            }
        }

        arr_table_val.splice(ui_row_idx, 0, arr_row_val);
        if (arr_editable_val && 0 !== arr_editable_val.length) {
            arr_editable.splice(ui_row_idx, 0, arr_editable_val);
        }
        if (arr_bhtml_val && 0 !== arr_bhtml_val.length) {
            arr_bhtml.splice(ui_row_idx, 0, arr_bhtml_val);
        }
        if (arr_type_val && arr_type_val.length) {
            arr_val_type.splice(ui_row_idx,0,arr_type_val);
        }
        return true;

        // 获取添加行html
        function get_row_html() {
            var str_table_body_li = "";

            for (var idx = 0; idx < arr_row_val.length; idx++) {
                var str_table_txt = arr_row_val[idx];
                var obj_lang = mc_get_lang_obj();
                var str_bhtml = "";
                var b_lang_id = true;
                var str_lang = "";
                var str_contenteditable = "";
                var str_type_val = "";

                if ( arr_bhtml_val && 0 !== arr_bhtml_val.length) {
                    str_bhtml = "b_html=" + arr_bhtml_val[idx];
                    if (arr_bhtml_val[idx]) {
                        b_lang_id = false;
                    }
                }
                if (arr_editable_val && arr_editable_val[idx]) {
                    str_contenteditable = "contenteditable=" + arr_editable_val[idx];
                }
                if (arr_type_val && arr_type_val[idx]) {
                    str_type_val = " mc_edit_type=" + arr_type_val[idx];
                }
                str_table_txt = mc_transform_lang(obj_lang, str_table_txt);
                str_lang = b_lang_id ? judge_add_lang(str_table_txt, b_set_lang_switch, "table") : "";
                str_table_body_li += "<li " + str_bhtml + " style='width:" + str_div_w + "' " + str_lang + "  " + str_contenteditable + str_type_val + "  onclick='mc_table_click(this)' onblur='mc_table_blur(this)' onkeyup='mc_table_keyup(this)'>" + str_table_txt + "</li>";
            }
            return "<ul class='table_row'>" + str_table_body_li + "</ul>";
        }

        // 参数判断
        function judge_param() {
            if ("[object Number]" !== Object.prototype.toString.call(ui_row_idx) || isNaN(ui_row_idx)) {
                return false;
            }
            if ("[object Array]" !== Object.prototype.toString.call(arr_row_val) || 0 === arr_row_val.length) {
                return false;
            }
            if (0 !== arr_editable.length && ("[object Array]" !== Object.prototype.toString.call(arr_editable_val) || 0 === arr_editable_val.length)) {
                return false;
            }
            if (0 !== arr_bhtml.length && ("[object Array]" !== Object.prototype.toString.call(arr_bhtml_val) || 0 === arr_bhtml_val.length)) {
                return false;
            }
            if (!document.getElementById(str_table_id)) {
                return false;
            }
            return true;
        }
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    创建表格标签
     * 参数:
     *    无
     * 返回：
     *    @return { Promise<String> }
     *     表格标签
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2019.12.23
     *      内容 : 所有代码
     ************************************************************************************************/
    this.get_html_txt = function () {
        str_table_id = "mc_table" + mc_get_id();
        var str_table_style = "";
        var str_table_header_con = "";
        var str_table_body_con = "";
        var i_table_title_len = arr_table_title.length;

        var str_val_chg_callback_attr = "";
        var str_lang = "";
        var obj_lang = mc_get_lang_obj();
        var str_text = "";
        var str_ul_justify = "";


        if (b_concat_grid) {
            str_ul_justify = "style='justify-content:flex-end';";
        }

        if (0 !== arr_style.length) {
            for (var idx_body_style = 0; idx_body_style < arr_style.length; idx_body_style++) {
                str_table_style += arr_style[idx_body_style][0] + ":" + arr_style[idx_body_style][1] + ";";
            }
            str_table_style = str_table_style.trim();
        }
        for (var idx_th = 0; idx_th < i_table_title_len; idx_th++) {
            if (0 === arr_table_title[idx_th].length) {
                str_table_header_con += "<div style='width:" + 100 / i_table_title_len + "%;" + "'></div>";
                continue;
            }
            str_lang = judge_add_lang(arr_table_title[idx_th], b_set_lang_switch, "table");
            str_text = mc_transform_lang(obj_lang, arr_table_title[idx_th]);

            str_table_header_con += "<div style='width:" + 100 / i_table_title_len + "%;" + "' " + str_lang + ">" + str_text + "</div>";
        }
        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        if (0 === arr_table_val.length) {
            return (
                "<div id='" + str_table_id + "' class='mc_table_box' style='" + str_table_style + "' " + str_val_chg_callback_attr +
      "><div class='mc_table_header'>" + str_table_header_con +
      "</div><div class='mc_table_body'>" + str_table_body_con + "</div></div>"
            );
        }
        return create_have_table();
        function create_have_table() {
            var str_div_w = 100 / arr_table_val[0].length + "%;";

            for (var idx_ul = 0; idx_ul < arr_table_val.length; idx_ul++) {
                var str_table_body_li = "";

                for (var idx_li = 0; idx_li < arr_table_val[idx_ul].length; idx_li++) {
                    var str_table_txt = arr_table_val[idx_ul][idx_li];
                    var str_grid_height = "";

                    if (b_concat_grid) {
                        if (false === str_table_txt) {
                            continue;
                        }
                        var ui_h_cnt = arr_grid_h[idx_ul][idx_li];

                        if (ui_h_cnt) {
                            str_grid_height = "height:" + ui_grid_h * ui_h_cnt + "px;";
                        }
                    }

                    var str_bhtml = false;
                    // 输入标签时不添加lang_id及contenteditable属性
                    var b_lang_id = true;
                    var str_contenteditable = "";
                    var str_val_type = "";


                    if (0 !== arr_bhtml.length) {
                        str_bhtml = "b_html=" + arr_bhtml[idx_ul][idx_li];
                        if (arr_bhtml[idx_ul][idx_li]) {
                            b_lang_id = false;
                        }
                    }
                    str_lang = b_lang_id ? judge_add_lang(str_table_txt, b_set_lang_switch, "table") : "";
                    str_table_txt = mc_transform_lang(obj_lang, str_table_txt);
                    if (0 !== arr_editable.length && arr_editable[idx_ul][idx_li]) {
                        str_contenteditable = "contenteditable=" + arr_editable[idx_ul][idx_li];
                    }
                    if (0 !== arr_val_type.length && arr_val_type[idx_ul][idx_li]) {
                        str_val_type = " mc_edit_type=" + arr_val_type[idx_ul][idx_li];
                    }
                    if (arr_grid_icon[idx_ul] && arr_grid_icon[idx_ul][idx_li]) {
                        str_table_body_li += "<li class='" + arr_grid_icon[idx_ul][idx_li] + "' " + str_bhtml + " style='width:" + str_div_w + str_grid_height + "' " + str_lang + "  " + str_contenteditable + "  onclick='mc_table_click(this)' onblur='mc_table_blur(this)' onkeyup='mc_table_keyup(this)'></li>";
                    } else {
                        str_table_body_li += "<li " + str_bhtml + " style='width:" + str_div_w + str_grid_height + "' " + str_lang + "  " + str_contenteditable + str_val_type + "  onclick='mc_table_click(this)' onblur='mc_table_blur(this)' onkeyup='mc_table_keyup(this)'>" + str_table_txt + "</li>";
                    }
                }
                str_table_body_con += "<ul class='table_row' " + str_ul_justify + ">" + str_table_body_li + "</ul>";
            }


            return (
                "<div id='" + str_table_id + "' class='mc_table_box' style='" + str_table_style + "' " + str_val_chg_callback_attr +
      "><div class='mc_table_header'>" + str_table_header_con +
      "</div><div class='mc_table_body'>" + str_table_body_con + "</div></div>"
            );
        }
    };

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    更新表格 arr_editable、arr_bhtml、arr_val_type数据
   * 参数:
   *    @param { Promise<Array> } arr_editable_val
   *    @param { Promise<Array> } arr_bhtml_val
   *    @param { Promise<Array> } arr_type_val
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.11.5
   *      内容 : 所有代码
   ************************************************************************************************/
    function update_data(arr_editable_val, arr_bhtml_val,arr_type_val) {
        if ("[object Array]" === Object.prototype.toString.call(arr_editable_val)) {
            arr_editable = arr_editable_val;
        }
        if ("[object Array]" === Object.prototype.toString.call(arr_bhtml_val)) {
            arr_bhtml = arr_bhtml_val;
        }
        if ("[object Array]" === Object.prototype.toString.call(arr_type_val)) {
            arr_val_type = arr_bhtml_val;
        }
        return true;
    }

    /************************************************************************************************
   * 类型:
   *    函数
   * 功能:
   *    设置表格项lang_id及control_type属性
   * 参数:
   *    @param { Promise<Object> } o_dom 设置项
   *    @param { Promise<String> } str_lang lang_id
   *    @param { Promise<Boolean> } b_set_lang 是否设置lang_id 默认设置 可为空true时不设置
   * 返回：
   *    @return { Promise<Boolean> }
   *     true 设置成功
   *     false 参数类型错误
   * 修改:
   *   1. 类型 : 创建
   *      作者 : 陈小荟
   *      时间 : 2020.11.5
   *      内容 : 所有代码
   ************************************************************************************************/
    function set_table_lang_id(o_dom, str_lang, b_set_lang) {
        if ("[object Object]" !== Object.prototype.toString.call(o_dom)) {
            return false;
        }
        if (b_set_lang_switch) {
            if (!b_set_lang) {
                o_dom.attr("lang_id", str_lang);
            }
            o_dom.attr("control_type", "table");
        }
        return true;
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    更新表格第一列数据及显示
     * 参数:
     *    @param { Promise<Object> } obj_table_body 表格body jq元素
     *    @param { Promise<Number> } ui_content 格子内容
     *    @param { Promise<Number> } ui_first_col 更新起始下标 可为空 默认为0
     * 返回：
     *    @return { Promise<Boolean> }
     *     true 设置成功
     *     false 参数类型错误
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 陈小荟
     *      时间 : 2021.03.22
     *      内容 : 所有代码
     ************************************************************************************************/
    function update_first_row(obj_table_body,ui_content,ui_first_col) {
        if ("[object Object]" !== Object.prototype.toString.call(obj_table_body) ) {
            return false;
        }
        if ("[object Number]" !== Object.prototype.toString.call(ui_content) || isNaN(ui_content)) {
            return false;
        }
        ui_first_col = "[object Number]" === Object.prototype.toString.call(ui_first_col) ? ui_first_col : 0;

        for (ui_first_col; ui_first_col < obj_table_body.length; ui_first_col++) {
            var o_li = obj_table_body.eq(ui_first_col).children().eq(0);

            if (arr_table_val[ui_first_col]) {
                arr_table_val[ui_first_col][0] = ui_content;
            }

            if (b_set_lang_switch) {
                o_li.attr("lang_id",ui_content);
            }
            o_li.text(ui_content++);
        }
        return true;
    }
}


// tab选项卡
function mc_ui_tabs() {
    var str_tabs_id = "";
    var arr_tabs_val = [];
    var arr_attribute_val = [];
    // 默认选中项下标
    var i_default_idx = 0;

    this.on_val_chg = function () { };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    定义tab项 lang_id 属性值
 * 参数:
 *    @param { Promise<Array> } arr_attr_val 属性值数组
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.05.08
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_lang_attribute = function (arr_attr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_attr_val) || 0 === arr_attr_val.length) {
            return false;
        }
        arr_attribute_val = arr_attr_val;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置tab内容
 * 参数:
 *    @param { Promise<Array> } arr_val
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.01.03
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_val = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        arr_tabs_val = arr_val;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置tab默认选中项
 * 参数:
 *    @param { Promise<Number> } i_default 默认选中项下标 0起始
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.01.03
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_default = function (i_default) {
        if ("[object Number]" !== Object.prototype.toString.call(i_default) || isNaN(i_default)) {
            return false;
        }
        i_default_idx = i_default;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置tab默认选中项 操作dom
 * 参数:
 *    @param { Promise<Number> } i_default 默认选中项下标 0起始
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.01.03
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_default = function (i_default) {
        if ("[object Number]" !== Object.prototype.toString.call(i_default) || isNaN(i_default)) {
            return false;
        }
        document.getElementById(str_tabs_id).setAttribute("default_idx", i_default);
        tab_init();
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取tab选线卡的ID
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<Strign> }
 *     tab选线卡ID
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.01.03
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_tabs_id.length) {
            return null;
        }
        return str_tabs_id;
    };

    /************************************************************************************************
  * 类型:
  *    函数
  * 功能:
  *    获取tab选线卡的ID 操作dom
  * 参数:
  *    无
  * 返回：
  *    @return { Promise<Strign> }
  *     tab选线卡ID
  * 修改:
  *   1. 类型 : 创建
  *      作者 : 陈小荟
  *      时间 : 2020.01.03
  *      内容 : 所有代码
  ************************************************************************************************/
    this.get_dom_id = function () {
        return document.getElementById(str_tabs_id).getAttribute("id");
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    tab选项卡标签
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     tab选项卡标签
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.01.03
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_html_txt = function () {
        str_tabs_id = "mc_tabs" + ui_tabs_idx + mc_get_id();
        var str_tab_header = "";

        if (0 === arr_attribute_val.length && 0 !== arr_tabs_val.length) {
            for (var idx_li = 0; idx_li < arr_tabs_val.length; idx_li++) {
                str_tab_header += "<div tab_idx='" + idx_li + "'   onclick='mc_tab_click(this)'>" + arr_tabs_val[idx_li] + "</div>";
            }
        } else {
            for (var idx_attr_li = 0; idx_attr_li < arr_attribute_val.length; idx_attr_li++) {
                str_tab_header += "<div tab_idx='" + idx_attr_li + "' onclick='mc_tab_click(this)'><span lang_id='" + arr_attribute_val[idx_attr_li] + "'></span></div>";
            }
        }

        // 触发回调函数
        var str_val_chg_callback_attr = "";

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        ui_tabs_idx += 1;
        return "<div id='" + str_tabs_id + "' class='mc_tab' default_idx='" + i_default_idx + "' " + str_val_chg_callback_attr + ">" + str_tab_header + "</div>";
    };
}

// 文件选择器
function mc_ui_select_file() {
    var str_select_file_id = "";
    var str_select_file_title = "";
    var ary_style = [];
    // 单/多选文件标识 默认单选
    var b_mult = false;
    // 允许上传文件类型 默认所有
    var str_accept = ".";
    var b_readAsText = false;
    // 显示内容
    var str_show_val = "";

    this.on_val_chg = function () { };
    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置选择文件框的宽度
 * 参数:
 *    @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.6
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        ary_style.push(["width", str_width]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置选择文件框的宽度 操作dom
 * 参数:
 *    @param { Promise<String> } str_width 宽度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.6
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_width = function (str_width) {
        if ("[object String]" !== Object.prototype.toString.call(str_width) || 0 === str_width.length) {
            return false;
        }
        if (!mc_check_strend(str_width)) {
            return false;
        }
        document.getElementById(str_select_file_id).parentNode.style.width = str_width;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取得选择文件框的ID
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     选择文件框的ID
 *     null 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.6
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_id = function () {
        if (0 === str_select_file_id.length) {
            return null;
        }
        return str_select_file_id;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取得选择文件框的ID 操作dom
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     选择文件框的ID
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.6
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_dom_id = function () {
        return document.getElementById(str_select_file_id).getAttribute("id");
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置选择文件框的title
 * 参数:
 *    @param { Promise<String> } str_title title值
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.6
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        str_select_file_title = str_title;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置选择文件框的title 操作dom
 * 参数:
 *    @param { Promise<String> } str_title title值
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.6
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_title = function (str_title) {
        if ("[object String]" !== Object.prototype.toString.call(str_title) || 0 === str_title.length) {
            return false;
        }
        document.getElementById(str_select_file_id).parentNode.setAttribute("title", str_title);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    是否允许多文件选择
 * 参数:
 *    @param { Promise<Boolean> } b_true true允许多文件选择
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.6
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_mult_file = function (b_true) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_true)) {
            return false;
        }
        b_mult = b_true;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    是否允许多文件选择 操作dom
 * 参数:
 *    @param { Promise<Boolean> } b_true true允许多文件选择
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.6
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_mult_file = function (b_true) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_true)) {
            return false;
        }
        $("#" + str_select_file_id).next().attr("multiple", b_true);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置限制上传的文件类型
 * 参数:
 *    @param { Promise<String> } str_type 文件类型
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.24
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_accept = function (str_type) {
        if ("[object String]" !== Object.prototype.toString.call(str_type) || 0 === str_type.length) {
            return false;
        }
        str_type = str_type.trim();
        if ("." !== str_type[0]) {
            str_type = "." + str_type;
        }
        str_accept = str_type;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置限制上传的文件类型 操作dom
 * 参数:
 *    @param { Promise<String> } str_type 文件类型
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.24
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_accept = function (str_type) {
        if ("[object String]" !== Object.prototype.toString.call(str_type) || 0 === str_type.length) {
            return false;
        }
        str_type = str_type.trim();
        if ("." !== str_type[0]) {
            str_type = "." + str_type;
        }
        $("#" + str_select_file_id).next().attr("accept", str_type);
        str_accept = str_type;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    是否将文件解析为文本
 * 参数:
 *    @param { Promise<Boolean> } b_true true 解析为文本
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.9.15
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_readAsText = function (b_true) {
        if ("[object Boolean]" !== Object.prototype.toString.call(b_true)) {
            return false;
        }
        b_readAsText = b_true;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置文件选择器默认展示内容
 * 参数:
 *    @param { Promise<String> } str_val
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.4
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }
        str_show_val = str_val;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置文件选择器默认展示内容 操作dom
 * 参数:
 *    @param { Promise<String> } str_val
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.4
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_dom_val = function (str_val) {
        if ("[object String]" !== Object.prototype.toString.call(str_val) || 0 === str_val.length) {
            return false;
        }
        var o_mc_file_show = document.getElementById(str_select_file_id).previousSibling().children();

        o_mc_file_show[0].innerText = str_val;
        o_mc_file_show[1].innerText = "";
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    创建选择文件标签
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<String> }
 *     选择文件标签
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.6
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_html_txt = function () {
        str_select_file_id = "mc_select_file" + ui_select_file_idx + mc_get_id();
        var str_style_list = "";
        // 触发回调函数
        var str_val_chg_callback_attr = "";
        var str_inp = "";
        var str_lang_id = "";

        if (0 !== ary_style.length) {
            for (var idx_style = 0; idx_style < ary_style.length; idx_style++) {
                str_style_list += ary_style[idx_style][0] + ":" + ary_style[idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
        }

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }
        ui_select_file_idx += 1;
        if (b_mult) {
            str_inp = "<input style='display:none' type='file' multiple accept='" + str_accept + "'/>";
        } else {
            str_inp = "<input style='display:none' type='file' accept='" + str_accept + "'/>";
        }
        if (0 === str_show_val.length) {
            str_lang_id = "MC_LANG_SHOW_FILE_NAME";
        }
        return "<div class='mc_select_file' title='" + str_select_file_title + "' style='" + str_style_list + "'><div class='mc_file_show'><span lang_id='" + str_lang_id + "' class='mc_file_txt'>" + str_show_val + "</span><span></span></div><div  id='" + str_select_file_id + "' class='select_file icon-boxconfig-load' b_readAsText='" + b_readAsText + "' style='font-size: 20px;' " + str_val_chg_callback_attr + " onclick='mc_clk_select_file(this)'></div>" + str_inp + "</div>";
    };
}

// 选择语言类型开关 str_div_id 需以jq方式传入 如：".select_lan_box"
function mc_ui_lan(str_div_id) {
    $(str_div_id).css({
        display: "inline-block",
        "z-index": 999
    });

    // 语言开关样式 [[width,20px],[height,20px]...]
    var arr_lan_style = [];
    // 语言项数组
    var arr_lan_val = [];
    // 默认语言类型
    var str_lan_default = "选择语言";

    // 数值改变触发 返回当前id与当前值 接受传递函数
    this.on_val_chg = function () { };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置语言开关的样式 高
 * 参数:
 *    @param { Promise<String> } str_height 高度
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.10
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_height = function (str_height) {
        if ("[object String]" !== Object.prototype.toString.call(str_height) || 0 === str_height.length) {
            return false;
        }
        if (!mc_check_strend(str_height)) {
            return false;
        }
        arr_lan_style.push(["height", str_height]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置语言开关的样式 字体颜色
 * 参数:
 *    @param { Promise<String> } str_color 颜色
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.10
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_color = function (str_color) {
        if ("[object String]" !== Object.prototype.toString.call(str_color) || 0 === str_color.length) {
            return false;
        }
        if (!mc_inspect_color(str_color)) {
            return false;
        }
        arr_lan_style.push(["color", str_color]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置语言开关的样式 字体大小
 * 参数:
 *    @param { Promise<String> } str_size 字体大小
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.10
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_style_size = function (str_size) {
        if ("[object String]" !== Object.prototype.toString.call(str_size) || 0 === str_size.length) {
            return false;
        }
        arr_lan_style.push(["font-size", str_size]);
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置默认语言类型
 * 参数:
 *    @param { Promise<String> } str_default 默认语言类型
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.10
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_lan_default = function (str_default) {
        if ("[object String]" !== Object.prototype.toString.call(str_default) || 0 === str_default.length) {
            return false;
        }
        if ("默认" === str_default) {
            str_lan_default = arr_lan_val[0];
        } else {
            str_lan_default = str_default;
        }
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置语言开关项
 * 参数:
 *    @param { Promise<Array> } arr_val 语言项数组
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.10
 *      内容 : 所有代码
 ************************************************************************************************/
    this.set_lan_arr = function (arr_val) {
        if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
            return false;
        }
        arr_lan_val = arr_val;
        return true;
    };

    /************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    创建语言开关标签
 * 参数:
 *    无
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.10
 *      内容 : 所有代码
 ************************************************************************************************/
    this.get_lan_html = function () {
        var str_style_list = "";
        var str_html = "";

        // 创建语言选项字串
        var str_val_list = "";

        for (var idx_val = 0; idx_val < arr_lan_val.length; idx_val++) {
            str_val_list += "<li onclick='select_contentli_click(this)'>" + arr_lan_val[idx_val] + "</li>";
        }

        // 触发回调函数
        var str_val_chg_callback_attr = "";

        if ("function" === typeof this.on_val_chg) {
            str_val_chg_callback_attr = g_str_attr_lab_val_chg + "='" + mc_get_func_key(this.on_val_chg) + "'";
        }

        // 样式
        if (0 !== arr_lan_style.length) {
            for (var idx_style = 0; idx_style < arr_lan_style.length; idx_style++) {
                str_style_list += arr_lan_style[idx_style][0] + ":" + arr_lan_style[idx_style][1] + ";";
            }
            str_style_list = str_style_list.trim();
            str_html = "<div class='select_lan' tabindex=0 " + str_val_chg_callback_attr + " style='" + str_style_list + "' onclick='select_lan_click(this)' onblur='select_lan_blur(this)'><span>" + str_lan_default + "</span><i class='select_lan_edge'></i></div><ul class='select_lan_content'>" + str_val_list + "</ul>";
        } else {
            str_html = "<div class='select_lan' tabindex=0 " + str_val_chg_callback_attr + "  onclick='select_lan_click(this)' onblur='select_lan_blur(this)'><span>" + str_lan_default + "</span><i class='select_lan_edge'></i></div><ul class='select_lan_content'>" + str_val_list + "</ul>";
        }
        $(str_div_id).html(str_html);
    };
}

/**********界面缩放滑动条***********************************************************************/
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    界面缩放滑动条
 * 参数:
 *    @param { Promise<Object> } obj_params 参数对象
 * 备注：
 *     参数 obj_params = {
 *              target: 存放盒子 JS_OBJECT,
 *              ui_min: 滑动最小限制,
 *              ui_max: 滑动最大限制,
 *              ui_step: 滑动步进,
 *              ui_val: 当前缩放值,
 *              icon_btn: [缩小icon class, 放大icon class], 两侧按钮icon 若无显示最大最小值
 *              fn_zoom: 缩放触发函数 参数三：传递指定缩放倍数,
 *              ui_txt_digit: 0 显示百分比数值保留位数 默认保留0位
 *          }
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.02.25
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_ui_zoom_slider(obj_params) {
    var obj_box = obj_params.target;

    if ("[object HTMLDivElement]" !== Object.prototype.toString.call(obj_box)) {
        return false;
    }
    var arr_btn = obj_params.icon_btn;
    var b_icon = false;

    if ("[object Array]" === Object.prototype.toString.call(arr_btn) && 2 === arr_btn.length) {
        b_icon = true;
    }
    obj_box.classList.add("mc_zoom_slider");
    var obj_slider = new mc_ui_slider();
    var ui_min = obj_params.ui_min || 0;
    var ui_max = obj_params.ui_max || 100;
    var ui_step = obj_params.ui_step || 1;
    var ui_val = obj_params.ui_val || 50;
    var func_zoom = obj_params.fn_zoom;
    var ui_txt_digit = obj_params.ui_txt_digit || 0;

    // ui_step /= 10;
    obj_slider.on_val_chg = mc_zoom_slider_chg;
    obj_slider.set_add_css("mc_set_slider");
    obj_slider.set_min_val(String(ui_min));
    obj_slider.set_max_val(String(ui_max));
    obj_slider.set_val(String(ui_val));
    obj_slider.set_step_val(String(ui_step));

    obj_box.innerHTML = "<div id='mc_zoom_txt' digit_cnt = '" + ui_txt_digit + "'>" + ui_val + "%</div>" + obj_slider.get_html_txt();
    var obj_slider_box = $(".mc_set_slider");
    var obj_min_btn = obj_slider_box.children(".mc_slider_min");
    var obj_max_btn = obj_slider_box.children(".mc_slider_max");
    var str_id = obj_slider.get_id();

    // 记录滑动条控件对象 缩放触发函数
    obj_zoom_slider[str_id] = obj_slider;
    obj_zoom_slider_fn[str_id] = func_zoom;

    mc_zoom_slider_set(Number(ui_val));
    if (b_icon) {
        obj_min_btn.addClass(arr_btn[0] + " zs_icon_btn").on("click", zoom_slider_down);
        obj_max_btn.addClass(arr_btn[1] + " zs_icon_btn").on("click", zoom_slider_up);
    } else {
        obj_min_btn.addClass("zs_icon_btn").on("click", zoom_slider_down).css("font-size", "14px");
        obj_max_btn.addClass("zs_icon_btn").on("click", zoom_slider_up).css("font-size", "14px");
    }

    obj_slider_box.children(".mc_slider_thumb").attr("draw_return", true);
    slider_thumb_init();
    return true;

    // 放大缩小按钮 以十倍步进操作
    function zoom_slider_down() {
        var ui_multiple = 10;

        // 箱体连接1倍操作
        if (1 >= ui_step) {
            ui_multiple = 1;
        }
        var str_val = mc_set_zoom_slider(-Number(ui_step) * ui_multiple,true);

        // 调用页面缩放
        func_zoom(false, false, Number(str_val));
    }

    function zoom_slider_up() {
        var ui_multiple = 10;

        if (1 >= ui_step) {
            ui_multiple = 1;
        }
        var str_val = mc_set_zoom_slider(Number(ui_step) * ui_multiple,true);

        func_zoom(false, false, Number(str_val));
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    页面缩放操作/按钮操作 更新滑动条显示
 * 参数:
 *    @param { Promise<Number> } u_step 当前缩放步进 正为放大 负为缩小
 *    @param { Promise<Boolean> } b_btn 是否为按钮触发 true为按钮触发 可为空
 *    @param { Promise<String> } str_point_val 指定显示值 可为空
 * 返回：
 *    @return { Promise<String> }
 *    str_val 当前滑块位置数值
 *    "" 参数/数据有误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.02.25
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_zoom_slider(u_step,b_btn,str_point_val) {
    if ("[object Number]" !== Object.prototype.toString.call(u_step)) {
        return "";
    }
    var obj_slider = document.getElementsByClassName("mc_set_slider")[0];

    if ("[object HTMLDivElement]" !== Object.prototype.toString.call(obj_slider)) {
        return "";
    }
    // 获取缩放滑动条控件
    obj_slider = obj_zoom_slider[obj_slider.id];
    if ("[object Object]" !== Object.prototype.toString.call(obj_slider)) {
        return "";
    }
    var str_val = "";

    if ("[object String]" === Object.prototype.toString.call(str_point_val)) {
        str_val = obj_slider.set_dom_val(str_point_val);
        mc_zoom_slider_set(Number(str_val));
        return str_val;
    }
    str_val = document.getElementById("mc_zoom_txt").innerText;
    var ui_before_val = Number(str_val.substr(0, str_val.length - 1));
    var int_step = Math.abs(u_step);
    var ui_temp = 0;

    if (0 > u_step && 0 !== ui_before_val % int_step) {
        if (judge_float(u_step)) {
            ui_temp = 0.1;
        } else {
            ui_temp = 1;
        }
    }

    if (!b_btn) {
        ui_before_val = (parseFloat(ui_before_val / int_step) + ui_temp) * int_step;
    }

    str_val = String(ui_before_val + u_step);
    // 更新滑块
    str_val = obj_slider.set_dom_val(str_val);
    mc_zoom_slider_set(Number(str_val));
    return str_val;

    // 判断是否为浮点型值 true是
    function judge_float(ui_num) {
        if (parseFloat(ui_num) === parseInt(ui_num,10)) {
            return false;
        }
        return true;
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    更新轨道填充色、当前缩放百分比
 * 参数:
 *    @param { Promise<Number> } ui_zoom 当前缩放数值
 * 返回：
 *    @return { Promise<Object> }
 *    false 参数有误
 *    true 更新成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.02.25
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_zoom_slider_set(ui_zoom) {
    if ("[object Number]" !== Object.prototype.toString.call(ui_zoom)) {
        return false;
    }
    var obj_txt = document.getElementById("mc_zoom_txt");

    if (!obj_txt) {
        return false;
    }
    var ui_digit_cnt = Number(obj_txt.getAttribute("digit_cnt"));

    obj_txt.innerText = ui_zoom.toFixed(ui_digit_cnt) + "%";
    var element = document.getElementsByClassName("mc_set_slider")[0];
    var ui_min = Number(element.childNodes[0].innerText);
    var ui_max = Number(element.childNodes[1].innerText);

    if (ui_min === ui_zoom) {
        ui_zoom -= 10;
    }
    if (ui_max === ui_zoom) {
        ui_zoom += 10;
    }
    ui_zoom = (ui_zoom - ui_min) / (ui_max - ui_min) * 100 + "%";
    var arr_priex = ["-o-", "-ms-", "-moz-", "-webkit-"];

    for (var i = 0; i < arr_priex.length; i += 1) {
        element.style.borderImage = arr_priex[i] + "linear-gradient(0deg, gray " + ui_zoom + ", rgb(220, 220, 220) 20%) 2";
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    缩放滑动条触发响应函数：更新缩放百分比显示、轨道填充、操作界面缩放
 * 参数:
 *    @param { Promise<String> } id 滑动条id
 *    @param { Promise<String> } val 滑块位置值
 * 返回：
 *    @return { Promise<Object> }
 *    false 数据有误
 *    true 操作成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.02.25
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_zoom_slider_chg(id, val) {
    var fn_zoom = obj_zoom_slider_fn[id];

    if ("[object Function]" !== Object.prototype.toString.call(fn_zoom)) {
        return false;
    }
    val = Number(val);
    mc_zoom_slider_set(val);
    fn_zoom(false, false, val);
    return true;
}

/**********控件初始化操作函数***********************************************************************/
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    控件初始化操作
 * 参数:
 *    无
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.03.21
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_item_js_fun() {
    // 复选框默认选中状态设置
    checkbox_init();
    // 初始化滑动条滑块位置
    slider_thumb_init();
    // 初始化下拉框滚动条 分类列表内容显示第一个
    option_init();
    // 单选按钮默认选中设置
    radio_init();
    // 初始化表格父级设置高以显示滚动条
    table_init();
    // tab选项卡默认选中项设置
    tab_init();
    // 语言开关 点击开关外部收起
    select_lan_init();
}

/**********编辑框设定***********************************************************************/
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    编辑框事件 数值改变校验值-回车触发失去焦点事件-失去焦点最终校验值
 * 参数:
 *    @param {Object} event 事件对象
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.5
 *      内容 : 所有代码
************************************************************************************************/
function mc_editeven(event) {
    var eve = event || window.event;
    var o_this = eve.target;

    switch (eve.type) {
    case "input":
        var value = o_this.value;
        // 数值类型效验
        var check_value = mc_edit_checkval(value, o_this.getAttribute("mc_edit_type"));
        // 输入后光标位置
        var selection_start = o_this.selectionStart;

        if (value !== check_value) {
            o_this.value = check_value;
            selection_start -= (value.length - check_value.length + 1);
            var cursorIndex = getCursorIndex(check_value, selection_start);

            // 格式化后控制光标位置
            o_this.setSelectionRange(cursorIndex, cursorIndex);
        }
        if (o_this.getAttribute("input_update")) {
            mc_set_show_val_tool(o_this,o_this,true);
            return_new_value(o_this, o_this.id, o_this.value);
        }
        break;
    case "keydown":
        // 229 中文输入法
        if (13 === eve.keyCode) {
            o_this.blur();
        }
        break;
    case "blur":
        var str_val = o_this.value;
        var str_before_val = o_this.getAttribute("default_val");

        if (!str_val || "" === str_val) {
            o_this.value = str_before_val;
        } else if (str_before_val !== str_val) {
            // 最终效验及范围判断
            str_val = mc_edit_valcheck(o_this, str_val);
            o_this.setAttribute("default_val", str_val);
            o_this.value = str_val;
            mc_set_show_val_tool(o_this,o_this,true);
            return_new_value(o_this, o_this.id, str_val);
        }

        break;
    default:
        break;
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    根据格式化之后的值和期望光标位置的前一个字符下标，计算出光标的位置
 * 参数:
 *    @param {string} value 格式化之后的值
 *    @param {number} charIndex 光标前一个字符的下标
 * 返回：
 *    @return {number}
 *      光标的位置
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.12.7
 *      内容 : 所有代码
************************************************************************************************/
function getCursorIndex(value, charIndex) {
    if (0 > charIndex) {
    // 如果期望光标前面没有字符，则光标位置为 0
        return 0;
    }
    // 计算格式化之后，字符所在的位置
    var curCharIndex;
    var count = -1;

    for (var i = 0; i < value.length; i++) {
        if (" " !== value.charAt(i)) {
            count += 1;
        }
        if (count === charIndex) {
            curCharIndex = i;
            break;
        }
    }
    return curCharIndex + 1;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    编辑框数值校验
 * 参数:
 *    @param {Object} obj_input 当前对象
 *    @param {String} str_val 待校验值
 * 返回：
 *    @return { Promise<String> }
 *     校验后字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.5
 *      内容 : 所有代码
************************************************************************************************/
function mc_edit_valcheck(obj_input, str_val) {
    if ("[object HTMLInputElement]" !== Object.prototype.toString.call(obj_input)) {
        return "";
    }
    var str_val_type = obj_input.getAttribute("mc_edit_type");

    if (str_val_type) {
        str_val_type = str_val_type.toUpperCase();
    }
    // 无效验类型
    if ("INT" !== str_val_type && "UINT" !== str_val_type && "HEX" !== str_val_type && "FLOAT" !== str_val_type) {
        return str_val;
    }
    str_val = str_val || obj_input.value;
    var str_default_digit = obj_input.getAttribute("default_digit");
    var transform_type = "parseInt";
    var transform_idx = 10;
    // 十六进制判断补零
    var b_zero_fill = false;

    if (str_val_type && 0 !== str_val_type.length) {
        str_val_type = str_val_type.toUpperCase();
        if ("HEX" === str_val_type) {
            transform_idx = 16;
            b_zero_fill = true;
        } else if ("FLOAT" === str_val_type) {
            transform_type = "parseFloat";
        }
    }

    str_val = mc_edit_checkval(str_val, str_val_type);
    var ui_val = mc_control_transform_val(transform_type, transform_idx, str_val);
    var ui_min_val = mc_control_transform_val(transform_type, transform_idx, obj_input.getAttribute("cui_min_val"));
    var ui_max_val = mc_control_transform_val(transform_type, transform_idx, obj_input.getAttribute("cui_max_val"));

    str_val = mc_inpval_limit(ui_val, ui_min_val, ui_max_val);

    if ("" === str_val) {
        return str_val;
    }

    // 十六进制 不足位数补零
    if (b_zero_fill) {
        str_val = Number(str_val).toString(16).toUpperCase();
        str_default_digit = parseInt(str_default_digit, 10);
        if (str_val.length < str_default_digit) {
            return (Array(str_default_digit).join(0) + str_val).slice(-str_default_digit);
        }
    }
    return str_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *     进制转换 转换类型-进制-转换数值
 * 参数:
 *    @param {String} str_type 转换类型 parseInt/parseFloat
 *    @param {Number} idx_num 进制 10/16
 *    @param {String} str_value 转换数值
 * 返回：
 *    @return { Promise<Number> }
 *     转换后值
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.01.12
 *      内容 : 所有代码
************************************************************************************************/
function mc_control_transform_val(str_type, idx_num, str_value) {
    return window[str_type](str_value, idx_num);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *     数值范围比较
 * 参数:
 *    @param {Number} ui_value 待比较值
 *    @param {Number} ui_min_value 最小值
 *    @param {Number} ui_max_value 最大值
 * 返回：
 *    @return { Promise<String> }
 *     校验后值字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.30
 *      内容 : 所有代码
************************************************************************************************/
function mc_inpval_limit(ui_value, ui_min_value, ui_max_value) {
    if (isNaN(ui_value) || "[object Number]" !== Object.prototype.toString.call(ui_value)) {
        return "";
    }
    if (isNaN(ui_min_value) || isNaN(ui_max_value) || "[object Number]" !== Object.prototype.toString.call(ui_min_value) || "[object Number]" !== Object.prototype.toString.call(ui_min_value)) {
        return ui_value.toString();
    }
    if (ui_value < ui_min_value) {
        ui_value = ui_min_value;
    }
    if (ui_value > ui_max_value) {
        ui_value = ui_max_value;
    }
    return ui_value.toString();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    编辑框数值类型效验
 * 参数:
 *    @param {String} str_val 待校验值
 *    @param {String} str_val_type 数值类型
 * 返回：
 *    @return { Promise<String> }
 *     校验后字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.5
 *      内容 : 所有代码
************************************************************************************************/
function mc_edit_checkval(str_val, str_val_type) {
    if (str_val_type) {
        str_val_type = str_val_type.toUpperCase();
    }

    // 无效验类型
    if ("INT" !== str_val_type && "UINT" !== str_val_type && "HEX" !== str_val_type && "FLOAT" !== str_val_type) {
        return str_val;
    }
    // 空值
    if ("" === str_val || "[object String]" !== Object.prototype.toString.call(str_val)) {
        return "";
    }
    str_val = str_val.toUpperCase();
    switch (str_val_type) {
    case "INT":
        if ("0" !== str_val) {
        // 去掉非数字 除了数字和-
            str_val = str_val.replace(/[^\d-]/g, "");
            // 0 不开头
            str_val = str_val.replace(/^0/, "");
        }
        return str_val;

    case "UINT":
        if ("0" !== str_val && "0" < str_val) {
        // 去掉非数字
            str_val = str_val.replace(/[^\d]/g, "");
            // 0 不开头
            str_val = str_val.replace(/^0/, "");
        } else {
            str_val = "0";
        }
        return str_val;

    case "HEX":
        // 负数置0
        if ("-" === str_val[0]) {
            str_val = "0";
        }
        str_val = str_val.replace(/[^\dA-F]/g, "");
        return str_val;
    case "FLOAT":
        // 保证第一个为数字而不是.
        str_val = str_val.replace(/^\./g, "");
        //先把非数字的都替换掉,处理数字和.
        str_val = str_val.replace(/[^\d.-]/g, "");
        //保证只有出现一个.而没有多个.
        str_val = str_val.replace(/\.{2,}/g, ".");
        // 保留两位小数
        str_val = str_val.replace(/^(-)*(\d+)\.(\d\d).*$/, "$1$2.$3");
        return str_val;
    default:
        break;
    }
    return str_val;
}


/********步进编辑框设定***********************************************************************/
// step_add点击
function mc_step_add_click(obj) {
    get_step_data(obj, "+");
}

function mc_step_sub_click(obj) {
    get_step_data(obj, "-");
}

// 点击加减操作 参数：当前对象 add/sub
function get_step_data(obj, str_symbol) {
    var o_step_inp = obj.parentNode.children[1].children[0];
    var str_step_val = o_step_inp.getAttribute("default_val");
    // 数据类型
    var str_val_type = o_step_inp.getAttribute("mc_edit_type");
    // 步进值
    var cui_step = o_step_inp.getAttribute("cui_step");

    if ("+" === str_symbol) {
        if ("float" === str_val_type) {
            str_step_val = mc_compute_add(str_step_val, cui_step);
        } else {
            str_step_val = parseFloat(str_step_val) + parseFloat(cui_step);
        }
    }
    if ("-" === str_symbol) {
        if ("float" === str_val_type) {
            str_step_val = mc_compute_sub(str_step_val, cui_step);
        } else {
            str_step_val = parseFloat(str_step_val) - parseFloat(cui_step);
        }
    }
    o_step_inp.value = str_step_val;
    str_step_val = String(str_step_val);


    // 效验返值
    if (!str_step_val || "" === str_step_val) {
        str_step_val = o_step_inp.getAttribute("default_val");
    } else {
    // 最终效验及范围判断
        str_step_val = mc_edit_valcheck(o_step_inp, str_step_val);
        o_step_inp.setAttribute("default_val", str_step_val);
    }
    o_step_inp.value = str_step_val;
    mc_set_show_val_tool(o_step_inp,o_step_inp,true);
    // 返回新值
    return_new_value(o_step_inp, o_step_inp.id, str_step_val);

    // 标识编辑状态
    // b_edit_step_select = true;
}


/********复选框设定***********************************************************************/
// 点击添加选中class类
function mc_checkbox_click(obj) {
    var o_on = obj.children[0];
    var o_off = obj.children[1];
    var str_select_status = obj.getAttribute("checkbox_select");
    // 判断是否选中 ture false
    var str_val = false;

    o_on.classList.remove("mc_checkbox_select_btn", "checkbox_flex_box_auto_size");
    o_off.classList.remove("mc_checkbox_select_btn", "checkbox_flex_box_auto_size");

    if ("true" === str_select_status) {
        o_on.classList.add("checkbox_flex_box_auto_size");
        o_off.classList.add("mc_checkbox_select_btn");
        obj.setAttribute("checkbox_select", "false");
    } else {
        o_on.classList.add("mc_checkbox_select_btn");
        o_off.classList.add("checkbox_flex_box_auto_size");
        obj.setAttribute("checkbox_select", "true");
        str_val = true;
    }

    // 将当前id与新的值返回
    var str_id = obj.getAttribute("id");

    return_new_value(obj, str_id, str_val);
}

// 复选框默认选中状态设置
function checkbox_init() {
    var mc_checkbox_list = document.getElementsByClassName("mc_checkbox_box");

    if (0 !== mc_checkbox_list.length) {
        for (var idx = 0; idx < mc_checkbox_list.length; idx++) {
            var mc_checkbox = mc_checkbox_list[idx];
            var o_checkbox_on = mc_checkbox.children[0];
            var o_checkbox_off = mc_checkbox.children[1];

            o_checkbox_on.classList.remove("mc_checkbox_select_btn", "checkbox_flex_box_auto_size");
            o_checkbox_off.classList.remove("mc_checkbox_select_btn", "checkbox_flex_box_auto_size");
            if ("true" === mc_checkbox.getAttribute("checkbox_select")) {
                o_checkbox_on.classList.add("mc_checkbox_select_btn");
                o_checkbox_off.classList.add("checkbox_flex_box_auto_size");
            }
            if ("false" === mc_checkbox.getAttribute("checkbox_select")) {
                o_checkbox_on.classList.add("checkbox_flex_box_auto_size");
                o_checkbox_off.classList.add("mc_checkbox_select_btn");
            }
        }
    }
}


/********滑动条设定***********************************************************************/
// 滑块鼠标按下事件
function mc_slider_mousedown(obj) {
    var e = window.event;

    slider_handerin(obj);
    // 鼠标偏移
    var i_start_left = e.clientX;
    var i_start_top = e.clientY;

    var i_offset_top = mc_get_offset(obj).top;
    var i_this_height = obj.offsetHeight + 2;

    // 点击时距离元素顶部及底部距离
    var i_dowm_top = i_start_top - i_offset_top;
    var i_dowm_bottom = i_offset_top + i_this_height - i_start_top;

    // 当前位置
    var i_base_left = parseFloat(obj.getAttribute("now_left"));

    var ui_min_value = parseFloat(obj.previousSibling.previousSibling.innerText);
    var ui_max_value = parseFloat(obj.previousSibling.innerText);
    var ui_step_value = parseFloat(obj.getAttribute("cui_step"));

    // 滑动范围
    var ui_max_range = obj.parentNode.offsetWidth - obj.offsetWidth + 2;
    var ui_grid_cnt = Math.round((ui_max_value - ui_min_value) / ui_step_value);
    var ui_grid_pix = ui_max_range / ui_grid_cnt;

    obj.classList.remove("mc_step_focus");
    mc_set_contenteditable(obj, true);

    document.onmousemove = function (event_move) {
        var e_move = event_move || window.event;

        ui_step_value = parseFloat(obj.getAttribute("cui_step"));
        // 鼠标偏移
        var df_ms_left = e_move.clientX - i_start_left;
        var df_ms_top = e_move.clientY - i_start_top;

        slider_handermove(obj, df_ms_left, ui_grid_pix, df_ms_top, i_dowm_top, i_dowm_bottom, i_base_left, ui_max_range, ui_grid_cnt, ui_step_value, ui_min_value, ui_max_value);
    };

    document.onmouseup = function (event_up) {
        document.onmouseup = null;
        document.onmousemove = null;
        var e_up = event_up || window.event;
        var i_offset = e_up.clientX - i_start_left;

        slider_handerout(obj, i_offset);
        obj.setAttribute("outevent", false);
    };
}

// 移动端滑块鼠标按下事件
function mc_slider_touchstart(obj) {
    var e = window.event;
    var $this = obj;

    slider_handerin($this);

    // 鼠标偏移
    var i_start_left = e.targetTouches[0].pageX;
    var i_start_top = e.targetTouches[0].pageY;

    var i_offset_top = mc_get_offset($this).top;
    var i_this_height = $this.offsetHeight + 2;

    // 点击时距离元素顶部及底部距离
    var i_dowm_top = i_start_top - i_offset_top;
    var i_dowm_bottom = i_offset_top + i_this_height - i_start_top;

    // 当前位置
    var i_base_left = parseFloat($this.getAttribute("now_left"));

    var ui_min_value = parseFloat(obj.previousSibling.previousSibling.innerText);
    var ui_max_value = parseFloat(obj.previousSibling.innerText);
    var ui_step_value = parseFloat(obj.getAttribute("cui_step"));

    // 滑动范围
    var ui_max_range = obj.parentNode.offsetWidth - obj.offsetWidth + 2;
    var ui_grid_cnt = Math.round((ui_max_value - ui_min_value) / ui_step_value);
    var ui_grid_pix = ui_max_range / ui_grid_cnt;

    var i_move_pagex = 0;

    obj.classList.remove("mc_step_focus");
    mc_set_contenteditable(obj, true);

    document.ontouchmove = function (event_move) {
        var e_move = event_move || window.event_move;

        ui_step_value = parseFloat($this.getAttribute("cui_step"));
        // 鼠标偏移
        var df_ms_left = e_move.targetTouches[0].pageX - i_start_left;
        var df_ms_top = e_move.targetTouches[0].pageY - i_start_top;

        slider_handermove($this, df_ms_left, ui_grid_pix, df_ms_top, i_dowm_top, i_dowm_bottom, i_base_left, ui_max_range, ui_grid_cnt, ui_step_value, ui_min_value, ui_max_value);
        i_move_pagex = e_move.targetTouches[0].pageX;
    };

    document.ontouchend = function () {
        document.ontouchend = null;
        document.ontouchmove = null;
        var i_offset = i_move_pagex - i_start_left;

        slider_handerout($this, i_offset);
        $this.setAttribute("outevent", false);
    };
}

// 滑块失去焦点
function mc_slider_blur(obj) {
    if ("true" === obj.getAttribute("is_blur")) {
        return false;
    }
    obj.classList.add("mc_step_focus");
    obj.classList.remove("mc_slider_thumb_keycode");
    var str_color = obj.style.color;

    if ("" === str_color) {
        str_color = "black";
    }
    obj.style.textShadow = "0 0 0 " + str_color;

    var arr_val_dot = obj.parentNode.getAttribute("slider_val");
    var arr_key_dot = obj.parentNode.getAttribute("slider_key").split(",");
    var inp_val = parseFloat(obj.innerText);

    var ui_min_value = parseFloat(obj.previousSibling.previousSibling.innerText);
    var ui_max_value = parseFloat(obj.previousSibling.innerText);
    var ui_step_value = parseFloat(obj.getAttribute("cui_step"));
    var ui_decimal_digit = parseInt(obj.getAttribute("decimal_digit"),10);

    // 滑动范围
    var ui_max_range = obj.parentNode.offsetWidth - obj.offsetWidth + 2;
    var ui_grid_cnt = Math.round((ui_max_value - ui_min_value) / ui_step_value);
    var ui_grid_pix = ui_max_range / ui_grid_cnt;

    arr_val_dot = mc_slider_transform_arr_val(arr_val_dot);

    // 输入非数字时
    if (isNaN(inp_val)) {
        var i_nochg_text = (parseFloat(obj.getAttribute("now_left")) / ui_grid_pix) * ui_step_value + ui_min_value;

        obj.innerText = i_nochg_text;
        return false;
    }

    var ui_key = inp_val;
    var ui_val = inp_val;
    var str_val = "";

    // 需要卡点
    if ("" !== arr_val_dot && "" !== arr_val_dot[0]) {
    // 获取效验后的val及对应key
        var arr_data = mc_slider_get_correspond_key(arr_key_dot, arr_val_dot, inp_val, ui_min_value, ui_max_value, ui_step_value);

        ui_key = arr_data[0];
        ui_val = arr_data[1];
        str_val = String(ui_val);
    } else {
        str_val = String(ui_val);
        ui_val = Math.round(ui_val / ui_step_value) * ui_step_value;
        ui_val = Number(String(ui_val).substring(0, str_val.length));
        if (ui_max_value < ui_val) {
            ui_val = ui_max_value;
        }
        if (ui_min_value > ui_val) {
            ui_val = ui_min_value;
        }
        ui_key = ui_val;
    }

    var str_id = $(obj).parent().attr("id");

    var ui_grid_i = Math.round((ui_val - ui_min_value) / ui_step_value);
    var ui_curr_l = ui_grid_i * ui_grid_pix;
    var $this = obj;

    // 保存当前inp位置
    obj.setAttribute("now_left", ui_curr_l);

    $(obj).animate({ left: ui_curr_l + obj.offsetWidth / 2 - 2 + "px" }, 500, function () {
    // 返回新值
        return_new_value($this, str_id, ui_key + "");
        var ui_text = parseFloat(ui_grid_i * ui_step_value + ui_min_value);

        // 多位小数时 保留输入位数
        // if (-1 !== String(ui_text).indexOf(".") && 2 < String(ui_text).split(".")[1].length) {
        //     var str_cnt = String(str_val).split(".")[1];

        //     ui_text = ui_text.toFixed(str_cnt ? str_cnt : 0);
        // }
        if (!isNaN(ui_decimal_digit)) {
            ui_text = ui_text.toFixed(ui_decimal_digit);
        }
        ui_text = (ui_text + "").replace(/<br>/g, "");
        $this.innerText = ui_text;
        // 修改默认位置
        $this.setAttribute("default_val", ui_text);
    });
    obj.setAttribute("thumb_move", false);
    obj.setAttribute("outevent", false);
    mc_set_contenteditable(obj, false);

    // 修改当前焦点位置
    return true;
}

// 滑块键盘操作
function mc_slider_keydown(obj) {
    var e = window.event;

    // 是否失去焦点 true失去
    if ("true" === obj.getAttribute("is_blur")) {
        return false;
    }

    // 获取光标
    obj.classList.remove("mc_slider_thumb_keycode");
    mc_set_focus(obj);

    var inp_val = parseFloat(obj.getAttribute("default_val"));
    var i_base_left = parseFloat(obj.getAttribute("now_left"));
    // var ui_decimal_digit = parseInt("decimal_digit",10);

    // if (!isNaN(ui_decimal_digit)) {
    //     ui_text = ui_text.toFixed(ui_decimal_digit);
    // }

    var ui_min_value = parseFloat(obj.previousSibling.previousSibling.innerText);
    var ui_max_value = parseFloat(obj.previousSibling.innerText);
    var ui_step_value = parseFloat(obj.getAttribute("cui_step"));

    // 滑动范围
    var ui_max_range = obj.parentNode.offsetWidth - obj.offsetWidth + 2;
    var ui_grid_cnt = Math.round((ui_max_value - ui_min_value) / ui_step_value);
    var ui_grid_pix = ui_max_range / ui_grid_cnt;

    // 移动范围
    var i_left_val = 0;
    // 显示数值
    var i_text = -1;
    // 是否返回值
    var str_darw_return = obj.getAttribute("draw_return");
    // 偏移
    var ui_thumb_skew = obj.offsetWidth / 2 - 2;

    if (inp_val > ui_max_value) {
        inp_val = ui_max_value;
    }
    if (inp_val < ui_min_value) {
        inp_val = ui_min_value;
    }
    if (13 === e.keyCode) {
        preventDefault(e);
        mc_slider_blur(obj);
        mc_set_contenteditable(obj, false);
    }
    // 上右
    if (38 === e.keyCode || 39 === e.keyCode) {
    // 去除光标 添加键盘移动样式
        obj.classList.add("mc_slider_thumb_keycode");
        i_left_val = i_base_left + ui_grid_pix * ui_step_value;
        if (ui_max_range < i_left_val) {
            i_left_val = ui_max_range;
        }
        i_text = inp_val + ui_step_value;
        if (i_text > ui_max_value) {
            i_text = ui_max_value;
        }
        obj.style.left = i_left_val + ui_thumb_skew + "px";
        obj.innerText = i_text;
        obj.setAttribute("now_left", i_left_val);
        obj.setAttribute("default_val", i_text);
    }
    // 下左
    if (37 === e.keyCode || 40 === e.keyCode) {
        obj.classList.add("mc_slider_thumb_keycode");
        i_left_val = i_base_left - ui_grid_pix * ui_step_value;
        if (0 > i_left_val) {
            i_left_val = 0;
        }
        i_text = inp_val - ui_step_value;
        if (i_text < ui_min_value) {
            i_text = ui_min_value;
        }
        obj.style.left = i_left_val + ui_thumb_skew + "px";
        obj.innerText = i_text;
        obj.setAttribute("now_left", i_left_val);
        obj.setAttribute("default_val", i_text);
    }
    if ("true" === str_darw_return && -1 !== i_text) {
        var str_id = obj.parentNode.getAttribute("id");

        return_new_value(obj, str_id, i_text + "");
    }
    return true;
}

// 初始化滑块位置
function slider_thumb_init() {
    var mc_slider_list = document.getElementsByClassName("mc_slider_thumb");

    if (0 !== mc_slider_list.length) {
        for (var idx_thumb = 0; idx_thumb < mc_slider_list.length; idx_thumb++) {
            var o_thumb_item = mc_slider_list[idx_thumb];

            var ui_min_value = parseFloat(o_thumb_item.previousSibling.previousSibling.innerText);
            var ui_max_value = parseFloat(o_thumb_item.previousSibling.innerText);
            var ui_step_value = parseFloat(o_thumb_item.getAttribute("cui_step"));

            var ui_max_range = o_thumb_item.parentNode.offsetWidth - o_thumb_item.offsetWidth + 2;
            var ui_grid_cnt = Math.round((ui_max_value - ui_min_value) / ui_step_value);
            var ui_grid_pix = ui_max_range / ui_grid_cnt;

            // 滑块默认位置
            var ui_thumb_default_text = parseFloat(o_thumb_item.getAttribute("default_val"));

            if (ui_thumb_default_text > ui_max_value) {
                ui_thumb_default_text = ui_max_value;
            }
            if (ui_thumb_default_text < ui_min_value) {
                ui_thumb_default_text = ui_min_value;
            }
            var ui_grid_idx = Math.round((ui_thumb_default_text - ui_min_value) / ui_step_value);
            var ui_curr_left = ui_grid_idx * ui_grid_pix;

            o_thumb_item.setAttribute("now_left", ui_curr_left);
            o_thumb_item.style.left = ui_curr_left + o_thumb_item.offsetWidth / 2 - 2 + "px";
            o_thumb_item.innerText = ui_thumb_default_text;
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    输入框是否可输入设置 b_true
 * 参数:
 *    @param {Object} obj_inp 当前对象
 *    @param {Boolean} b_true 是否可输入
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 设置成功
 *     false 参数类型错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.4
 *      内容 : 所有代码
************************************************************************************************/
function mc_set_contenteditable(obj_inp, b_true) {
    if ("[object Object]" !== Object.prototype.toString.call(obj_inp) || "[object Boolean]" !== Object.prototype.toString.call(b_true)) {
        return false;
    }
    if (-1 === obj_inp.className.indexOf("mc_edit")) {
        return false;
    }
    if (b_true) {
        obj_inp.setAttribute("contenteditable", true);
        obj_inp.setAttribute("is_blur", false);
    } else {
        obj_inp.setAttribute("contenteditable", false);
        obj_inp.setAttribute("is_blur", true);
    }
    return true;
}

// 窗口大小改变重新初始化滑动条滑块位置/下拉框下拉菜单高度
window.onresize = function () {
    slider_thumb_init();
    var mc_opt_select = document.getElementsByClassName("mc_opt_select");

    if (0 !== mc_opt_select.length) {
        init_select_list_h(mc_opt_select);
    }

    // 侧边栏按钮显示隐藏
    var side_btn_head = $("#mc_side_head_btn");
    var sied_btn_bto = $("#mc_side_bto_btn");
    var mc_side_right_box = $("#mc_side_right_box");

    if (0 !== side_btn_head.length && 0 !== sied_btn_bto.length && 0 !== mc_side_right_box.length) {
        var ui_box_h = mc_side_right_box.height();
        var ui_bto_btn_h = sied_btn_bto.height();
        var ui_head_top = side_btn_head.offset().top + side_btn_head.height();

        if (ui_box_h <= ui_bto_btn_h + ui_head_top) {
            // sied_btn_bto.css("display", "none");
        } else {
            // sied_btn_bto.css("display", "block");
        }
    }
};

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    滑块事件操作 按下
 * 参数:
 *    @param {Object} obj_this 当前对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.19
 *      内容 : 所有代码
 ************************************************************************************************/
function slider_handerin(obj_this) {
    obj_this.setAttribute("outevent", true);
    obj_this.setAttribute("thumb_move", true);
    // 禁止编辑模式及选中
    obj_this.setAttribute("contenteditable", "false");
    obj_this.classList.remove("mc_slider_thumb_uselect");
    obj_this.classList.add("mc_slider_thumb_nuselect");
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    滑块事件操作 移动
* 参数:
*    @param {Object} obj_this 当前对象
*    @param {Number} i_ms_left  鼠标左偏移量
*    @param {Number} i_grid_pix 滑动条每格像素
*    @param {Number} i_ms_top  鼠标上偏移量
*    @param {Number} i_dowm_top  按下时距离元素顶部距离
*    @param {Number} i_dowm_bottom  按下时距离元素底部距离
*    @param {Number} i_base_left  按下时滑块位置
*    @param {Number} i_max_left  滑动最大距离
*    @param {Number} i_grid_cnt  格子数
*    @param {Number} i_step_value  步进值
*    @param {Number} i_min_value  滑动条最小值
     @param {Number} ui_max_value  滑动条最大值
* 返回：i
*    无
* 修改:
*   1. 类型 : 创建
*      作者 : 陈小荟
*      时间 : 2019.12.19
*      内容 : 所有代码
************************************************************************************************/
function slider_handermove(obj_this, i_ms_left, i_grid_pix, i_ms_top, i_dowm_top, i_dowm_bottom, i_base_left, i_max_left, i_grid_cnt, i_step_value, i_min_value, ui_max_value) {
    if (!obj_this.getAttribute("thumb_move")) {
        return;
    }
    if (Math.abs(i_ms_left) < i_grid_pix) {
        return;
    }

    if (Math.abs(i_ms_top) > i_dowm_top || Math.abs(i_ms_top) > i_dowm_bottom) {
        $(document).off("mousemove");
        $(document).off("touchmove");
    }
    // 移动量
    var ui_curr_l = i_base_left + i_ms_left;
    var val = 0;
    // 移动网格数
    var ui_grid_i = mc_move_grid_idx(ui_curr_l, i_max_left, i_grid_pix);
    // 是否返回值
    var str_darw_return = obj_this.getAttribute("draw_return");

    if (i_grid_cnt <= ui_grid_i + 1) {
        ui_curr_l = i_max_left;
        val = ui_max_value;
    } else {
        ui_curr_l = ui_grid_i * i_grid_pix;
        val = ui_grid_i * i_step_value + i_min_value;
    }
    var ui_text = parseFloat(val.toFixed(5));

    obj_this.setAttribute("now_left", ui_curr_l);
    obj_this.style.left = ui_curr_l + obj_this.offsetWidth / 2 - 2 + "px";
    obj_this.innerText = ui_text;

    // 修改默认位置
    obj_this.setAttribute("default_val", ui_text);

    if ("true" === str_darw_return) {
        var str_id = obj_this.parentNode.getAttribute("id");

        return_new_value(obj_this, str_id, ui_text + "");
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    滑块事件操作 抬起
* 参数:
*    @param { Promise<Object> } obj_this 当前对象
*    @param { Promise<Number> } i_offset 偏移量
* 返回：
*    无
* 修改:
*   1. 类型 : 创建
*      作者 : 陈小荟
*      时间 : 2019.12.19
*      内容 : 所有代码
************************************************************************************************/
function slider_handerout(obj_this, i_offset) {
    if ("false" === obj_this.getAttribute("outevent")) {
        return;
    }
    if (0 < Math.abs(i_offset)) {
        mc_slider_blur(obj_this);
    } else {
    // 开启编辑模式及选中
        obj_this.setAttribute("contenteditable", "true");
        obj_this.classList.add("mc_slider_thumb_uselect");
        obj_this.classList.remove("mc_slider_thumb_nuselect");

        // 光标移到最后
        mc_set_focus(obj_this);
    }

    // 禁用移动
    obj_this.setAttribute("thumb_move", false);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    计算移动网格数
 * 参数:
 *    @param {Number} ui_curr_left 移动量
 *    @param {Number} ui_max_left 移动范围
 *    @param {Number} ui_grid_pix 每格像素
 * 返回：
 *    @return { Promise<String> }
 *     函数名称
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.11
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_move_grid_idx(ui_curr_left, ui_max_left, ui_grid_pix) {
    if ("[object Number]" !== Object.prototype.toString.call(ui_curr_left) || isNaN(ui_curr_left)) {
        return null;
    }
    if ("[object Number]" !== Object.prototype.toString.call(ui_max_left) || isNaN(ui_max_left)) {
        return null;
    }
    if ("[object Number]" !== Object.prototype.toString.call(ui_grid_pix) || isNaN(ui_grid_pix)) {
        return null;
    }
    if (0 > ui_curr_left) {
        ui_curr_left = 0;
    }
    if (ui_max_left < ui_curr_left) {
        ui_curr_left = ui_max_left;
    }
    var ui_grid_idx = Math.floor(ui_curr_left / ui_grid_pix);

    return ui_grid_idx;
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    获取当前元素相对于文档的偏移量
* 参数:
*    @param { Promise<Object> } Node 当前元素
*    @param { Promise<Number> } offset 偏移方向 letf top
* 返回：
*    @return { Promise<Number> } 相应偏移量
* 举例：var box = document.getElementsByClassName("box")[0];
*      mc_get_offset(box) -> return <Object> {top:number ,left:number}
*      mc_get_offset(box).top
*      mc_get_offset(box).left
* 修改:
*   1. 类型 : 创建
*      作者 : 陈小荟
*      时间 : 2020.03.19
*      内容 : 所有代码
************************************************************************************************/
function mc_get_offset(Node, offset) {
    if (!offset) {
        offset = {};
        offset.top = 0;
        offset.left = 0;
    }
    if (Node === document.body) {
    //当该节点为body节点时，结束递归
        return offset;
    }
    offset.top += Node.offsetTop; offset.left += Node.offsetLeft;
    //向上累加offset里的值
    return mc_get_offset(Node.offsetParent, offset);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取滑动条对应的key及val数组
 * 参数:
 *     @param { Promise<Array> } arr_val set_arr数据数组
 * 返回：
 *     @return { Promise<Array> }
 *      [] 参数有误
 *      [key数组,val数组]
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.04.28
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_slider_set_arr(arr_val) {
    if ("[object Array]" !== Object.prototype.toString.call(arr_val) || 0 === arr_val.length) {
        return [];
    }
    var arr_val_dot = [];
    var arr_key_dot = [];
    var ui_after_val = 0;
    var b_order_after = true;

    for (var idx_dot = 0; idx_dot < arr_val.length; idx_dot++) {
        var str_dot = arr_val[idx_dot];
        var i_gap_pos = str_dot.indexOf("=");

        // 传入数据为[key1=val=,key2=val2]
        if (1 <= i_gap_pos) {
            var str_before_dot = str_dot;

            if (0 === idx_dot) {
                ui_after_val = parseFloat(str_dot.substr(i_gap_pos + 1)) - 1;
            }
            ui_after_val += 1;
            str_before_dot = str_dot.substr(0, i_gap_pos);
            str_dot = str_dot.substr(i_gap_pos + 1);
            if (ui_after_val !== parseFloat(str_dot)) {
                b_order_after = false;
            }
            arr_key_dot.push(str_before_dot);
            arr_val_dot.push(str_dot);
        } else {
            // 传入数据为[val1,val2]
            b_order_after = false;
            arr_key_dot.push(str_dot);
        }
    }
    // 若等号后面数据按顺序排列（步进为1），记录标识
    if (b_order_after) {
        arr_val_dot = ["true"];
    }
    if (0 === arr_val_dot.length) {
        arr_val_dot = ["alike"];
    }
    return [arr_key_dot, arr_val_dot];
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取滑动条对应的value值 (已知key获取对应val)
 * 参数:
 *     @param { Promise<Array> } arr_slider_key 数据key数组
 *     @param { Promise<Array> } arr_slider_val 数据val数组
 *     @param { Promise<Number> } i_key key 数据（等号前面）
 *     @param { Promise<Number> } i_min 滑动条最小值
 *     @param { Promise<Number> } i_max 滑动条最大值
 *      @param { Promise<Number> } i_step 滑动条步进值
 * 返回：
 *     @return { Promise<Number> }
 *      -1 参数有误
 *      i_val 对应key的value字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.04.27
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_slider_get_correspond_val(arr_slider_key, arr_slider_val, i_key, i_min, i_max, i_step) {
    if ("[object Array]" !== Object.prototype.toString.call(arr_slider_key) || "[object Array]" !== Object.prototype.toString.call(arr_slider_val)) {
        return -1;
    }
    if ("[object Number]" !== Object.prototype.toString.call(i_key) || "[object Number]" !== Object.prototype.toString.call(i_step)) {
        return -1;
    }
    if ("[object Number]" !== Object.prototype.toString.call(i_min) || "[object Number]" !== Object.prototype.toString.call(i_max)) {
        return -1;
    }
    var i_val = i_key;

    // 若需要卡点
    if (0 !== arr_slider_key.length) {
    // 保存最接近的值
        var ui_nearest_txt = Math.pow(2, 32) - 1;
        var b_val_repeat = true;
        var ui_val_idx = 0;

        for (var idx_key = 0; idx_key < arr_slider_key.length; idx_key++) {
            var ui_key_item = parseFloat(arr_slider_key[idx_key]);

            if (ui_key_item < ui_nearest_txt) {
                ui_nearest_txt = ui_key_item;
                ui_val_idx = idx_key;
            }

            if (ui_key_item === i_key) {
                // 若val数据按顺序排列
                if ("true" === arr_slider_val[0]) {
                    i_val = idx_key + i_min;
                } else {
                    i_val = arr_slider_val[idx_key];
                }
                b_val_repeat = false;
                break;
            }
        }
        // key无匹配值
        if (b_val_repeat) {
            if ("alike" === arr_slider_val[0]) {
                i_val = arr_slider_key[ui_val_idx];
            } else {
                i_val = arr_slider_val[ui_val_idx];
            }
        }
    } else {
        i_val = Math.round(i_val / i_step) * i_step;
        if (i_max < i_val) {
            i_val = i_max;
        }
        if (i_min > i_val) {
            i_val = i_min;
        }
    }

    return parseFloat(i_val);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取滑动条对应的key值 (已知val获取对应key)
 * 参数:
 *     @param { Promise<Array> } arr_slider_key 数据key数组
 *     @param { Promise<Array> } arr_slider_val 数据val数组
 *     @param { Promise<Number> } i_val val 数据（等号后面）
 *     @param { Promise<Number> } i_min 滑动条最小值
 *     @param { Promise<Number> } i_max 滑动条最大值
 *      @param { Promise<Number> } i_step 滑动条步进值
 * 返回：
 *     @return { Promise<Array> }
 *      -1 参数有误
 *      [ui_new_key,ui_new_val]
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.04.27
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_slider_get_correspond_key(arr_slider_key, arr_slider_val, i_val, i_min, i_max, i_step) {
    if ("[object Array]" !== Object.prototype.toString.call(arr_slider_key) || "[object Array]" !== Object.prototype.toString.call(arr_slider_val)) {
        return -1;
    }
    if ("[object Number]" !== Object.prototype.toString.call(i_val) || "[object Number]" !== Object.prototype.toString.call(i_step)) {
        return -1;
    }
    if ("[object Number]" !== Object.prototype.toString.call(i_min) || "[object Number]" !== Object.prototype.toString.call(i_max)) {
        return -1;
    }

    // 范围限制
    i_val = Math.round(i_val / i_step) * i_step;
    if (i_max < i_val) {
        i_val = i_max;
    }
    if (i_min > i_val) {
        i_val = i_min;
    }

    var i_result_key = i_val;
    var i_result_val = i_val;

    // 若需要卡点
    if (0 !== arr_slider_key.length) {
    // 保存最接近的值
        var ui_nearest_txt = Math.pow(2, 32) - 1;
        var b_repeat = true;
        var b_val_repeat = true;
        var ui_key_idx = 0;

        // 若val数组与key数组相同
        if ("alike" === arr_slider_val[0]) {
            arr_slider_val = arr_slider_key;
        }

        // 获取key数据
        if ("true" === arr_slider_val[0]) {
            ui_key_idx = i_val - i_min;
            i_result_key = arr_slider_key[ui_key_idx];
            b_val_repeat = false;
        } else {
            for (var idx_val = 0; idx_val < arr_slider_val.length; idx_val++) {
                var ui_val_item = parseFloat(arr_slider_val[idx_val]);
                var ui_nearest = Math.abs(i_val - ui_val_item);

                if (ui_nearest < ui_nearest_txt) {
                    ui_nearest_txt = ui_nearest;
                    ui_key_idx = idx_val;
                }

                if (ui_val_item === i_val) {
                    i_result_key = arr_slider_key[idx_val];
                    b_repeat = false;
                    break;
                }
            }

            // 无匹配项选择最近位置
            if (b_repeat) {
                i_result_key = arr_slider_key[ui_key_idx];
                if (b_val_repeat) {
                    i_result_val = arr_slider_val[ui_key_idx];
                }
            }
        }
    }
    return [i_result_key, i_result_val];
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    转换滑动条记录的val数据为数组
 * 参数:
 *     @param { Promise<Array> } str_val_dot 数据key数组
 * 返回：
 *     @return { Promise<Array> }
 *      null 参数有误
 *      arr_val_dot val数据数组
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.04.28
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_slider_transform_arr_val(str_val_dot) {
    if ("string" !== typeof str_val_dot) {
        return null;
    }

    var arr_val_dot = str_val_dot;

    if ("true" === arr_val_dot) {
        arr_val_dot = ["true"];
        return arr_val_dot;
    }
    if ("alike" === arr_val_dot) {
        arr_val_dot = ["alike"];
        return arr_val_dot;
    }
    //  "" -> [""]
    arr_val_dot = arr_val_dot.split(",");
    return arr_val_dot;
}


/********下拉框设定***********************************************************************/
// 列表value
var arr_option_key = [];
// 列表内容
var arr_option_val = [];
// 列表标签
var str_option_list = "";
// 起始位置下标
var i_start = -1;
// 记录页数
var i_page = 0;
// 数据总页数
var i_all_page = 1;
// 键盘上下移动时 保存当前选中项key
// eslint-disable-next-line no-unused-vars
var str_now_select = "";
// 记录上一个操作对象
var obj_before_operate = "";
// 记录鼠标移动选中的元素下标
var ui_move_index = -1;
// 上一次构建下拉字串时的语言类型
var str_lang_type = "";

function mc_option_mouse_wheel(obj,ev) {
    if (!obj) {
        return;
    }
    var event = ev || window.event;

    if (!event) {
        return;
    }
    var elem_list_box = obj.getElementsByClassName("select_list")[0];


    if (!elem_list_box) {
        return;
    }
    var elem_item_list = elem_list_box.children;
    var ui_cur_idx = elem_list_box.getAttribute("m_index");

    if (!elem_item_list.length) {
        return;
    }
    if (!ui_cur_idx) {
        ui_cur_idx = 0;
    }
    if (0 < event.wheelDelta || event.delta) {
        ui_cur_idx--;
    } else {
        ui_cur_idx++;
    }
    if (0 > ui_cur_idx) {
        ui_cur_idx = 0;
    }
    if (ui_cur_idx >= elem_item_list.length) {
        ui_cur_idx = elem_item_list.length - 1;
    }
    var elem_select_item = elem_item_list[ui_cur_idx];

    if (!elem_select_item || "MC_LANG_NO_MATCH" === elem_item_list[0].getAttribute("lang_id")) {
        return;
    }
    mc_select_listli_click(elem_select_item,true);
    return;
}

// 搜索框点击动作
function mc_select_text_click(obj) {
    var o_select_ul = $(obj).next();
    var o_select_classify = o_select_ul.next();
    var o_select_txt = $(obj).children().eq(0);
    var o_btn_box = $(obj).children().eq(1);
    var obj_lang = mc_get_lang_obj();
    var str_select_default_val = mc_transform_lang(obj_lang, $(obj).parent().attr("mc_select_default"));
    var s_lang_type = obj_lang.get_lang_id();

    // 关闭上次操作的下拉框
    if ("" !== obj_before_operate && obj_before_operate !== obj) {
        $(obj_before_operate).children(".select_btn_box").removeClass("select_btn_rotate");
        $(obj_before_operate).next().css("display", "none").html("").append(str_option_list);
        if ("" === $(obj_before_operate).children(".select_txt").text()) {
            $(obj_before_operate).children(".select_txt").text(mc_transform_lang(obj_lang, $(obj_before_operate).parent().attr("mc_select_default")));
        }
        if ("true" === $(obj_before_operate).attr("have_classify")) {
            $(obj_before_operate).next().next().css("display", "none");
        }
        obj_before_operate = "";
    }

    // 保存当前值
    if ("" === obj_before_operate || str_lang_type !== s_lang_type) {
        var arr_select_list_c = o_select_ul.children();

        str_lang_type = s_lang_type;
        arr_option_key = [];
        arr_option_val = [];
        str_option_list = "";
        for (var idx_li = 0; idx_li < arr_select_list_c.length; idx_li++) {
            var o_li = arr_select_list_c.eq(idx_li);
            var str_item_text = o_li.text();
            var str_item_key = o_li.attr("value");
            var str_lang_id = o_li.attr("lang_id");
            var str_input_lang = "";

            if (str_lang_id) {
                str_input_lang = judge_add_lang(str_lang_id, true, "select");
            }

            arr_option_key.push(str_item_key);
            arr_option_val.push(str_item_text);
            str_option_list += "<li " + str_input_lang + " index='" + idx_li + "' value='" + str_item_key + "' onclick='mc_select_listli_click(this)' onmousemove='mc_select_listli_mousemove(this)'>" + str_item_text + "</li>";
        }
    }

    obj_before_operate = obj;
    // 将当前输入框清空
    o_select_txt.text("");
    ui_move_index = -1;
    // 下拉列表显示隐藏
    if (0 !== o_select_classify.length) {
        var arr_search_title = o_select_classify.children().eq(1).children();

        // 初始化显示数据
        i_page = 0;
        mc_limit_data(o_select_classify.children(".sc_search_cont0").children(".sc_cont_right"), i_page);
        // 第一页时处理分页按钮
        if ("true" === o_select_classify.children().eq(2).attr("block_sc_flip")) {
            $(".sc_flip").css("display", "block");
        } else {
            $(".sc_flip").css("display", "none");
        }

        // 默认分类列表选中第一个
        o_select_classify.children().eq(1).children().eq(0).addClass("sc_title_active").siblings().removeClass("sc_title_active");
        for (var idx_sc_title = 0; idx_sc_title < arr_search_title.length; idx_sc_title++) {
            if (0 === idx_sc_title) {
                // control_flip 分页显示标识
                $(".sc_search_cont" + idx_sc_title).css("display", "flex").addClass("control_flip");
            } else {
                $(".sc_search_cont" + idx_sc_title).css("display", "none").removeClass("control_flip");
            }
        }
        // 分类搜索框显示隐藏
        o_select_classify.toggle();
        o_select_ul.css("display", "none");
    } else {
    // 滚动条置顶
        o_select_ul.toggle().scrollTop(0).children().removeClass("select_focus");
        add_select_tip(o_select_ul);
    }

    // 控制开关
    if (o_btn_box.hasClass("select_btn_rotate")) {
        o_btn_box.removeClass("select_btn_rotate");
        if ("" === o_select_txt.text()) {
            o_select_txt.text(str_select_default_val).attr("contenteditable", "false");
        }
    } else {
    // 判断是否禁止输入
        if ("true" === $(obj).children(".select_txt").attr("is_edit")) {
            o_select_txt.attr("contenteditable", "true");
        }

        o_btn_box.addClass("select_btn_rotate");
        // 选中起始重置
        i_start = -1;
    }

    o_select_txt.focus();
    mc_set_focus(o_select_txt[0]);
    // 操作下拉列表标识
    b_edit_step_select = true;
}

// 搜索框键盘动作 -> 模糊搜索 键盘上下键移动列表选中项
function mc_select_txt_keyup(obj) {
    if (!b_edit_step_select) {
        return;
    }

    var e = event || window.event;
    var o_select_text = $(obj).parent();
    // 匹配值
    var str_val = $(obj).text().toUpperCase();
    var o_select_ul = o_select_text.next();

    if ("true" === $(obj).attr("is_edit")) {
        $(obj).attr("contenteditable", "true");
    }

    if (13 !== e.keyCode) {
        if ((1 === o_select_ul.children().length && "MC_LANG_NO_MATCH" === o_select_ul.children().eq(0).attr("lang_id")) || (38 !== e.keyCode && 40 !== e.keyCode)) {
            o_select_ul.html("").append(str_option_list);
            o_select_ul = o_select_text.next();
        }
    }

    // 将分类搜索框收起
    if ("true" === o_select_text.attr("have_classify")) {
        o_select_text.next().next().css("display", "none");
        o_select_ul.scrollTop(0).children().removeClass("select_focus");
        add_select_tip(o_select_ul);
    }

    if ("none" === o_select_ul.css("display")) {
        o_select_ul.css("display", "block");
    }


    // 模糊搜索
    if (38 !== e.keyCode && 40 !== e.keyCode && 13 !== e.keyCode && "" !== str_val) {
    // 是否显示无匹配项 默认显示
        var b_match = true;
        var i_idx = 0;

        // 重新确定起始位置
        i_start = -1;
        $(obj).next().addClass("select_btn_rotate");
        for (var idx_arr_option = 0; idx_arr_option < o_select_ul.children().length; idx_arr_option++) {
            // 已翻译
            var str_option_val = arr_option_val[i_idx];

            // 不匹配项移除
            if (-1 === str_option_val.toUpperCase().indexOf(str_val)) {
                o_select_ul.children().eq(idx_arr_option).remove();
                idx_arr_option--;
            } else {
                b_match = false;
            }
            i_idx++;
        }
        if (b_match) {
            var obj_lang = mc_get_lang_obj();

            o_select_ul.html("").append("<li lang_id='MC_LANG_NO_MATCH'>" + mc_transform_lang(obj_lang, "MC_LANG_NO_MATCH") + "</li>");
            // 记录无匹配状态 关闭时将显示默认值
            $(obj).attr("b_show_default", true);
        }
    }

    if (-1 !== ui_move_index) {
        o_select_ul.attr("m_index", ui_move_index);
    }
    // 键盘操作
    mc_select_keyboard_control(o_select_ul, e.keyCode, $(obj));

    // 控制光标位置在最后
    mc_set_focus(obj);
}

// 列表项点击动作 -> 列表选中
function mc_select_listli_click(obj,b_un_toggle) {
    var o_select_ul = $(obj).parent();
    var o_txt = o_select_ul.prev().children().eq(0);
    var str_text = $(obj).text();
    var str_default_lang_id = $(obj).attr("lang_id");
    var o_select = o_select_ul.parent();
    var str_id = o_select.attr("id");
    var str_val = $(obj).attr("value");
    var obj_box = obj.parentNode.parentNode;

    mc_update_control_lang_id(str_default_lang_id, o_txt);
    o_txt.text(str_text).attr("contenteditable", false).next().removeClass("select_btn_rotate");
    if (!b_un_toggle) {
        o_select_ul.toggle();
    }
    // 记录选中项标识
    o_select_ul.attr("m_index", $(obj).attr("index"));
    o_select.attr({ "mc_select_default": str_default_lang_id, "mc_select_val": str_val });
    o_txt.attr("b_show_default", false);
    b_edit_step_select = false;

    mc_set_show_val_tool(obj_box,o_txt[0]);
    return_new_value(obj_box, str_id, str_val);
}

// 列表项鼠标移动动作 -> 选中样式唯一
function mc_select_listli_mousemove(obj) {
    $(obj).addClass("select_focus").siblings().removeClass("select_focus");
    ui_move_index = parseInt($(obj).attr("index"), 10);
}

/***************分类列表***************/
// 分类头部点击动作 -> 底部样式、内容切换
function mc_search_titleli_click(obj) {
    var arr_search_title = $(obj).parent().children();
    var str_cont_idx = $(obj).attr("sc_index");
    var o_search_cont = $(obj).parent().nextAll().eq(str_cont_idx);

    // 重置翻页数据为第一页
    i_page = 0;
    mc_limit_data(o_search_cont.children(".sc_cont_right"), i_page);

    for (var idx_sc_title = 0; idx_sc_title < arr_search_title.length; idx_sc_title++) {
        arr_search_title.eq(idx_sc_title).removeClass("sc_title_active");
        $(obj).parent().nextAll().eq(idx_sc_title).css("display", "none").removeClass("control_flip");
    }
    $(obj).addClass("sc_title_active");
    o_search_cont.css("display", "flex").addClass("control_flip");
    if ("true" === o_search_cont.attr("block_sc_flip")) {
        $(".sc_flip").css("display", "block");
    } else {
        $(".sc_flip").css("display", "none");
    }
    clearBubble();
}

// 点击 X 按钮关闭分类列表
function mc_heard_click(obj) {
    $(obj).parent().parent().css("display", "none");
    $(".select_btn_box").removeClass("select_btn_rotate");
    b_edit_step_select = false;
    $(obj).parent().parent().parent().children().eq(0).children().eq(0).attr("contenteditable", false);
}

// 内容项点击 -> 选中内容
function mc_contli_click(obj) {
    var str_list_val = $(obj).text();
    var o_select_classify = $(obj).parent().parent().parent().parent();
    var o_input = o_select_classify.prev().prev().children().eq(0);
    var str_default_lang_id = $(obj).attr("lang_id");
    var o_select = o_select_classify.parent();
    var str_id = o_select.attr("id");
    var str_val = $(obj).attr("value");

    mc_update_control_lang_id(str_default_lang_id, o_input);
    o_input.text(str_list_val).attr("contenteditable", false);
    $(".select_classify").css("display", "none");
    $(".select_btn_box").removeClass("select_btn_rotate");

    // 修改默认值
    if ("" !== str_list_val) {
        o_select.attr({ "mc_select_default": str_default_lang_id, "mc_select_val": str_val });
    }

    b_edit_step_select = false;
    mc_set_show_val_tool(o_select[0],o_input[0]);
    return_new_value(o_select[0], str_id, str_val);
    clearBubble();
}

// 点击上下页切换数据
function mc_fprev_click(obj) {
    if (0 < i_page) {
        i_page -= 1;
    }
    var o_cont_right = $(obj).parent().parent().children(".control_flip").children(".sc_cont_right");

    mc_limit_data(o_cont_right, i_page);
}

function mc_fnext_click(obj) {
    if (i_all_page - 1 > i_page) {
        i_page += 1;
    }
    var o_cont_right = $(obj).parent().parent().children(".control_flip").children(".sc_cont_right");

    mc_limit_data(o_cont_right, i_page);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    分类列表数据切换处理 每页每种8个
 * 参数:
 *    @param { Promise<Object> } o_obj 事件对象名
 *    @param { Promise<String> } ui_page 数据页数
 * 返回：
 *    @return { Promise<Boolean> }
 *     true 切换成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.03.04
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_limit_data(o_obj, ui_page) {
    if ("false" === o_obj.eq(0).parent().parent().attr("have_switch_page")) {
        return false;
    }
    var arr_list_data = $(o_obj).children();

    if (0 === arr_list_data.length) {
        return true;
    }
    // 第0页时记录最大数据数
    var i_max_data_len = 0;
    // 每页数量
    var i_page_num = 9;
    var b_is_set = true;

    for (var idx_ul = 0; idx_ul < arr_list_data.length; idx_ul++) {
        var arr_data_li = arr_list_data.eq(idx_ul).children();

        if (i_page_num < arr_data_li.length) {
            arr_data_li.css("display", "none");
            b_is_set = true;

            var str_title = arr_data_li.eq(0);

            for (var idx_li = i_page_num * ui_page; idx_li < i_page_num * ui_page + i_page_num; idx_li++) {
                arr_data_li.eq(idx_li).css("display", "block");
                if (0 === ui_page && i_max_data_len < arr_data_li.length) {
                    i_max_data_len = arr_data_li.length;
                    // 超过数据标识 做显示翻页按钮处理
                    arr_data_li.parent().parent().parent().attr("block_sc_flip", "true");
                }
                if (0 !== ui_page && b_is_set) {
                    str_title.css("display", "block");
                    b_is_set = false;
                    idx_li++;
                }
            }
            // 若子元素都隐藏则 隐藏侧头
            if (str_title.parent().children().length < i_page_num * ui_page) {
                str_title.css("display", "none");
            }
        }
    }
    if (0 === ui_page) {
        i_all_page = Math.ceil(i_max_data_len / i_page_num);
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    键盘动作函数封装 键盘上下键控制列表选中项
 * 参数:
 *    @param { Promise<Object> } o_select_list 下拉列表对象
 *    @param { Promise<Number> } ui_keycode 键盘键码值
 *    @param { Promise<Object> } o_select_txt 当前文本框对象
 * 返回：
 *    @return { Promise<Boolean> }
 *     false 禁止操作项
 *     true 操作成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.03.04
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_select_keyboard_control(o_select_list, ui_keycode, o_select_txt) {
    // 确定起始位置
    var ui_select_index = o_select_list.attr("m_index");
    var arr_select_list = o_select_list.children();
    var i_select_len = arr_select_list.length;
    var b_update = true;
    // 选中项
    var obj_select = arr_select_list.eq(i_start);

    // 禁止选中无匹配项
    if (1 === arr_select_list.length && "MC_LANG_NO_MATCH" === arr_select_list.eq(0).attr("lang_id")) {
        b_update = false;
    }

    if (b_update) {
    // 修改起始位置为上一次选中元素位置
        if (ui_select_index && -1 === i_start) {
            i_start = parseInt(ui_select_index, 10);
            if (i_start === arr_select_list.length - 1) {
                i_start = -1;
            }
        }

        var i_select_list_heigth = o_select_list.height();
        var i_select_height = arr_select_list.innerHeight();

        // 列表显示项个数;
        var i_option_num = parseInt(i_select_list_heigth / i_select_height, 10);
        var i_option_t = 0;

        // TOP 38
        if (38 === ui_keycode) {
            o_select_txt.attr("contenteditable", "false");
            i_start -= 1;
            if (0 > i_start) {
                i_start = i_select_len - 1;
            }
            arr_select_list.removeClass("select_focus").eq(i_start).addClass("select_focus");
            obj_select = arr_select_list.eq(i_start);
            o_select_txt.text(obj_select.text());
            str_now_select = obj_select.attr("value");

            // 滚动条动作
            i_option_t = mc_get_ele_top(obj_select);
            // obj_select.position().top;

            if (i_select_list_heigth < (i_start + 1) * i_select_height) {
                o_select_list.scrollTop(i_select_height * i_start);
            }
            if (i_select_list_heigth > (i_start + 1) * i_select_height) {
                o_select_list.scrollTop(0);
            }
        }

        // BOTTOM 40
        if (40 === ui_keycode) {
            o_select_txt.attr("contenteditable", "false");
            i_start += 1;
            arr_select_list.removeClass("select_focus").eq(i_start).addClass("select_focus");
            obj_select = arr_select_list.eq(i_start);
            o_select_txt.text(obj_select.text());
            str_now_select = obj_select.attr("value");

            // 滚动条动作
            if (i_select_len > i_start) {
                i_option_t = arr_select_list.eq(obj_select);
                // obj_select.position().top;
            }
            if (i_select_list_heigth < (i_start + 1) * i_select_height) {
                var i_offset_top = i_select_height * (i_start - i_option_num + 1);

                o_select_list.scrollTop(i_offset_top);
            }
            if (0 > i_option_t || i_select_len === i_start) {
                o_select_list.scrollTop(0);
            }

            if (i_select_len - 1 <= i_start) {
                i_start = -1;
            }
        }
    }

    // 回车 -> 更新值
    if (13 === ui_keycode) {
        var str_now_val = o_select_txt.text();
        var str_val = obj_select.attr("value");
        var o_select = o_select_txt.parent().parent();
        // 修改默认值
        var str_return_val = "";
        var obj_lang = mc_get_lang_obj();

        // 检验当前值是否为匹配值
        str_now_val = mc_select_enter_val(str_now_val);
        b_edit_step_select = false;
        o_select_list.html("").append(str_option_list);
        o_select_list.css("display", "none");
        o_select_txt.blur().next().removeClass("select_btn_rotate");

        if ("" !== str_now_val && b_update) {
            var i_index = parseInt(obj_select.attr("index"), 10);
            var str_default_lang_id = obj_select.attr("lang_id");

            // 记录选中元素位置
            o_select_list.attr("m_index", i_index);
            o_select.attr({ "mc_select_default": str_default_lang_id, "mc_select_val": obj_select.attr("value") });
            str_return_val = str_val;
            str_now_val = mc_transform_lang(obj_lang, str_now_val);
            o_select_txt.text(str_now_val);
            mc_update_control_lang_id(str_default_lang_id, o_select_txt);
        } else {
            str_return_val = o_select.attr("mc_select_val");
            str_now_val = mc_transform_lang(obj_lang, o_select.attr("mc_select_default"));
            o_select_txt.text(str_now_val);
        }

        o_select_txt.attr("b_show_default", false);
        o_select_txt.attr("contenteditable", false);

        mc_set_show_val_tool(o_select_txt[0].parentNode.parentNode,o_select_txt[0]);
        // 返回新值
        return_new_value(o_select_txt[0].parentNode.parentNode, o_select.attr("id"), str_return_val);
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下拉菜单回车操作检验值是否有匹配项
 * 参数:
 *    @param { Promise<String> } str_val 当前输入值
 * 返回：
 *    @return { Promise<Boolean> }
 *     false 参数类型有误
 *     str_v 匹配值
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.9.7
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_select_enter_val(str_val) {
    if ("string" !== typeof str_val || 0 === str_val.length) {
        return false;
    }
    // 检测当前值是否匹配
    for (var idx = 0; idx < arr_option_val.length; idx++) {
        var str_v = arr_option_val[idx].toUpperCase();

        if (str_val.toUpperCase() === str_v) {
            return str_v;
        }
    }
    return "";
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取元素top值
 * 参数:
 *    @param { Promise<Object> } obj
 * 返回：
 *    @return { Promise<Boolean> }
 *     0
 *     ui_top top值
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.9.7
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_ele_top(obj) {
    var ui_top = 0;

    if (0 !== obj.length && "[object HTMLDivElement]" === Object.prototype.toString.call(obj)) {
        ui_top = obj.position().top;
    }
    return ui_top;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下拉菜单添加唯一选中标识
 * 参数:
 *    @param { Promise<Object> } obj_ul 下拉列表对象
 * 返回：
 *    @return { Promise<Boolean> }
 *     false 参数类型有误
 *     true 操作成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.6.02
 *      内容 : 所有代码
 ************************************************************************************************/
function add_select_tip(obj_ul) {
    if ("object" !== typeof obj_ul) {
        return false;
    }
    var ui_index = obj_ul.attr("m_index");

    if (ui_index) {
        obj_ul.children().eq(parseInt(ui_index, 10)).attr("before_select", true).siblings().attr("before_select", false);
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    初始化下拉框下拉菜单高度
 * 参数:
 *    @param { Promise<Object> } arr_opt_select 下拉框对象数组
 * 返回：
 *    @return { Promise<Boolean> }
 *     false 参数类型有误
 *     true 操作成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.6.08
 *      内容 : 所有代码
 ************************************************************************************************/
function init_select_list_h(arr_opt_select) {
    if ("object" !== typeof arr_opt_select) {
        return false;
    }
    var ui_window_h = $(window).height() - 2;
    // 获取显示元素id 无则显示高度为window高度
    var str_show_id = arr_opt_select[0].getAttribute("show_id");

    if (str_show_id) {
        ui_window_h = document.getElementById(str_show_id).offsetHeight - 2;
    }
    var b_box_page_menu = false;

    // 箱体页面菜单打开
    if (parent.B_BOX_PAGE && 0 !== $(".mc_btn_pop_menu_box").length) {
        $(".mc_btn_pop_menu_box").css("display", "block");
        b_box_page_menu = true;
    }

    // 将下拉框朝上的元素回正
    if (0 !== $(".update_select_list_h").length) {
    // $(".update_select_list_h").removeClass("update_select_list_h").css({ "top": "28px", "min-height": "153px", "max-height": "none" });
        $(".update_select_list_h").removeClass("update_select_list_h").css({ "top": "28px", "max-height": "none" });
    }

    for (var idx = 0; idx < arr_opt_select.length; idx++) {
        var o_select = arr_opt_select[idx];
        var obj_inp = $(o_select.children[1]);
        var ui_select_h = ui_window_h - o_select.getBoundingClientRect().top - o_select.offsetHeight;
        var ui_h = obj_inp.height();

        // 更改最小高度或者下拉方向
        if (ui_select_h < ui_h && 0 !== ui_select_h) {
            if (77 <= ui_select_h) {
                obj_inp.css({ "max-height": ui_select_h, "min-height": "none" });
            } else {
                var ui_inp_box_h = o_select.offsetTop;

                // 无多余空间 下拉框朝上
                if (ui_h > ui_inp_box_h) {
                    // 高度超过窗口
                    obj_inp.css({"top": -ui_inp_box_h - 1 + "px","height": ui_inp_box_h}).addClass("update_select_list_h");
                } else {
                    obj_inp.css("top", -ui_h - 1 + "px").addClass("update_select_list_h");
                }
            }
        }
    }

    // 箱体页面菜单关闭
    if (b_box_page_menu) {
        $(".mc_btn_pop_menu_box").css("display", "none");
    }
    return true;
}

// 页面调用
function option_init() {
    var mc_opt_select = document.getElementsByClassName("mc_opt_select");
    var mc_select_text_dom = document.getElementsByClassName("select_list");

    if (
        0 !== mc_opt_select.length ||
    0 !== mc_select_text_dom.length
    ) {
        if (0 !== mc_opt_select.length) {
            // 初始化下拉菜单高度
            init_select_list_h(mc_opt_select);
        }

        // 分类列表内容显示第一个
        $(".sc_search_cont0").css("display", "flex");

        // 点击其余位置关闭下拉菜单
        $(document).off("click");
        $(document).on("click", function (event) {
            var o_select_text = $(".select_text");
            var o_select_txt = $(".select_txt");
            var o_sc_title_active = $(".sc_title_active");
            var o_select_btn_box = $(".select_btn_box");
            var o_select_btn = $(".select_btn");
            var o_sc_cont_list = $(".sc_cont_list");
            var o_sc_flip_prev = $(".sc_flip_prev");
            var o_sc_flip_next = $(".sc_flip_next");

            if (!o_select_text.is(event.target) && !o_select_txt.is(event.target) && !o_sc_title_active.is(event.target) && !o_select_btn_box.is(event.target) && !o_select_btn.is(event.target) && !o_sc_cont_list.is(event.target) && !o_sc_flip_prev.is(event.target) && !o_sc_flip_next.is(event.target)) {
                $(".select_classify").css("display", "none");
                $(".select_list").css("display", "none");
                $(".select_btn_box").removeClass("select_btn_rotate");

                b_edit_step_select = false;
                // 若下拉菜单为空或者输入无匹配项则赋默认值
                for (var idx_item = 0; idx_item < o_select_txt.length; idx_item++) {
                    var o_item = o_select_txt.eq(idx_item);
                    var str_txt = o_item.text();
                    var b_show_default = o_item.attr("b_show_default");

                    if ("" === str_txt || "true" === b_show_default) {
                        var o_select_list = o_item.parent().next();
                        var str_default_val = o_item.parent().parent().attr("mc_select_default");
                        var o_lang = mc_get_lang_obj();

                        o_item.text(mc_transform_lang(o_lang, str_default_val));
                        o_item.attr("contenteditable", false);
                        if ("MC_LANG_NO_MATCH" === o_select_list.children().eq(0).attr("lang_id")) {
                            o_select_list.html("").append(str_option_list);
                        }
                    }
                }

                // 下拉列表嵌套在表格时判断 在HUB编辑页面判断
                if (!$(".select_list").parent().prev().is(event.target) && 0 !== $("#box_edit_container").length) {
                    $(".select_list").parent().css("display", "none").prev().css("display", "block");
                }
            }
            // 收起右侧栏
            var obj_side = mc_get_top_object("mc_wrap_div_side_cont");
            var arr_open_side_item = mc_get_top_data("arr_open_side_item");
            var obj_fix = mc_get_top_object("mc_side_fix");

            if (obj_side) {
                if (!$(obj_fix).hasClass("select_side_item")) {
                    obj_side.classList.remove("set_pushpin");

                    obj_side.classList.remove("add_side_width");
                    window.parent.str_prev_side_name = "";

                    if (0 !== arr_open_side_item.length) {
                        arr_open_side_item[0].classList.remove("wrap_side_select_btn");
                        window.parent.arr_open_side_item = [];
                    }
                }
            }

            // 开启箱体页面滚动条滚动
            if (b_remove_unscroll) {
                // eslint-disable-next-line no-undef
                mc_box_remove_unscroll("#mc_hlever_layout_canvas");
            }
        });
    }
}


/********单选按钮设定***********************************************************************/
// 单选按钮项鼠标按下
function mc_radio_down(obj) {
    var $this = $(obj);
    var o_box = $this.parent();
    var str_judge = o_box.attr("rl_btn");

    if ("true" === str_judge) {
    /// 判断是按下还是拖动
        var is_clk = true;
        var ui_clientx = window.event.clientX;
        var ui_scroll_l = o_box.scrollLeft();

        o_box.css("cursor", "move");
        document.onmousemove = function (event_move) {
            event_move = event_move || window.event;
            var ui_move_cx = event_move.clientX;

            preventDefault(event_move);
            if (ui_clientx !== ui_move_cx) {
                o_box.scrollLeft(ui_scroll_l + (ui_clientx - ui_move_cx));
                is_clk = false;
            }
        };

        document.onmouseup = function (event_up) {
            event_up = event_up || window.event;
            preventDefault(event_up);
            if (is_clk) {
                radio_clk($this, o_box);
            }
            o_box.css("cursor", "");
            document.onmousemove = null;
            document.onmouseup = null;
        };
    } else {
        radio_clk($this, o_box);
    }

    function radio_clk(target, o_parent) {
        var o_select = o_parent.children(".mc_radio_select");

        if (0 !== o_select.length) {
            o_select.removeClass("mc_radio_select").attr("radio_select", false);
        }
        update_radio_select(target);
    }
}

// 单选按钮项鼠标移入控制样式
function mc_radioi_mouseover(obj) {
    var o_radio_box = obj.parentNode;
    var arr_radio_item = o_radio_box.children;

    radio_set_class(arr_radio_item);
    obj.classList.add("mc_radio_select");
    obj.onmouseleave = null;
    obj.onmouseleave = function () {
        radio_set_class(arr_radio_item);
    };
}

// 页面调用 默认选中操作
function radio_init() {
    var mc_radio_list = document.getElementsByClassName("mc_radio_btn");

    if (0 !== mc_radio_list.length) {
        for (var idx = 0; idx < mc_radio_list.length; idx++) {
            // 每个单选按钮组
            var mc_radio = mc_radio_list[idx];
            // 每个单选项
            var arr_radio_child = mc_radio.children;

            // 默认选中操作
            if ("" !== mc_radio.getAttribute("mc_radio_default")) {
                var str_default_val = mc_radio.getAttribute("mc_radio_default");

                for (var idx_item = 0; idx_item < arr_radio_child.length; idx_item++) {
                    arr_radio_child[idx_item].classList.remove("mc_radio_select");
                    var str_radio_val = arr_radio_child[idx_item].getAttribute("value");
                    var str_radio_text = arr_radio_child[idx_item].innerHTML;

                    arr_radio_child[idx_item].setAttribute("radio_select", "false");

                    if (str_radio_val === str_default_val || str_radio_text === str_default_val) {
                        var obj_parent = arr_radio_child[idx_item].parentNode;
                        var ui_index = Number(arr_radio_child[idx_item].getAttribute("index"));

                        arr_radio_child[idx_item].classList.add("mc_radio_select");
                        arr_radio_child[idx_item].setAttribute("radio_select", "true");

                        // 是否需要滚动
                        if (4 < ui_index) {
                            var ui_scroll_len = arr_radio_child[idx_item].offsetWidth;
                            var ui_cnt = ui_index - 4;

                            obj_parent.scrollLeft(ui_cnt * ui_scroll_len);
                            obj_parent.setAttribute("select_index", 5);
                        } else {
                            obj_parent.setAttribute("select_index", ui_index + 1);
                        }
                    }
                }
            }
        }
    }
}

// 左选按钮
function radio_left_clk(obj) {
    var obj_radio_box = $(obj).next();
    var obj_item = obj_radio_box.children();
    var ui_item_len = obj_item.width() + 1;
    var obj_select = obj_radio_box.children(".mc_radio_select");

    if (0 !== obj_radio_box.children(".mc_radio_select").length) {
        var ui_select_index = Number(obj_radio_box.attr("select_index"));
        var ui_scroll_len = obj_radio_box.scrollLeft();

        obj_select.removeClass("mc_radio_select").attr("radio_select", "false");
        if (1 === ui_select_index) {
            if (0 < ui_scroll_len) {
                obj_radio_box.scrollLeft(ui_scroll_len - ui_item_len);
                update_radio_select(obj_select.prev());
                return true;
            }
            update_radio_select(obj_select);
        } else {
            if (0 !== obj_select.prev().length) {
                update_radio_select(obj_select.prev());
            } else {
                update_radio_select(obj_select);
            }
        }
    } else {
        update_radio_select(obj_item.eq(0));
    }
    return true;
}

function radio_right_clk(obj) {
    var obj_radio_box = $(obj).prev();
    var obj_item = obj_radio_box.children();
    var ui_item_len = obj_item.width() + 1;
    var obj_select = obj_radio_box.children(".mc_radio_select");

    if (0 !== obj_radio_box.children(".mc_radio_select").length) {
        var ui_select_index = Number(obj_radio_box.attr("select_index"));

        obj_select.removeClass("mc_radio_select").attr("radio_select", "false");
        if (5 === ui_select_index && 0 !== obj_select.next().length) {
            obj_radio_box.scrollLeft(obj_radio_box.scrollLeft() + ui_item_len);
            update_radio_select(obj_select.next());
            return true;
        }
        if (0 !== obj_select.next().length) {
            update_radio_select(obj_select.next());
        } else {
            update_radio_select(obj_select);
        }
    } else {
        update_radio_select(obj_item.eq(0));
    }
    return true;
}

// 修改选中项 是否记录当前选中格子在五格中的位置：可为空
function update_radio_select(obj_jq) {
    var obj_parent = obj_jq.parent();

    obj_jq.addClass("mc_radio_select");
    obj_jq.attr("radio_select", "true");

    obj_parent.attr("mc_radio_default", obj_jq.attr("value"));

    // 将选中项值返回
    var str_id = obj_parent.attr("id");
    var str_val = obj_jq.attr("value");
    var ui_cnt = Math.ceil(obj_parent.scrollLeft() / (obj_jq.width() + 1));

    obj_parent.attr("select_index", Number(obj_jq.attr("index")) - ui_cnt + 1);
    return_new_value(obj_parent[0], str_id, str_val);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    鼠标移入移出设置相关类
 * 参数:
 *    @param {Array} arr_radio_item 当前单选数组
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.20
 *      内容 : 所有代码
 ************************************************************************************************/
function radio_set_class(arr_radio_item) {
    for (var idx_radio = 0; idx_radio < arr_radio_item.length; idx_radio++) {
        var str_select_radio = arr_radio_item[idx_radio];

        // 排除选中项
        if ("true" !== str_select_radio.getAttribute("radio_select")) {
            str_select_radio.classList.remove("mc_radio_select");
        }
    }
}


/********表格设定***********************************************************************/
var b_table_blur = false;

// 格子点击添加选中样式
function mc_table_click(obj) {
    // 标签隐藏不执行
    if ("none" !== obj.style.display && "true" === obj.getAttribute("contenteditable")) {
        obj.classList.add("mc_table_select_li");
        b_table_blur = false;
    }
}

// 格子失去焦点
function mc_table_blur(obj) {
    if (b_table_blur) {
        return;
    }
    if ("none" !== obj.style.display && "true" === obj.getAttribute("contenteditable")) {
        obj.classList.remove("mc_table_select_li");
        var str_val_type = obj.getAttribute("mc_edit_type");

        // 将回车多余标签删除
        if (1 <= $(obj).children().length && "true" !== obj.getAttribute("b_html")) {
            obj.innerHTML = mc_edit_checkval($(obj).text(), str_val_type);
        } else if (str_val_type) {
            obj.innerText = mc_edit_checkval(obj.innerText, str_val_type);
        }
    }
    b_table_blur = true;
    get_grid_pot($(obj));
    // obj.focus = null;
    return;
}

// 表格键盘抬起 若回车触发失去焦点
function mc_table_keyup(obj) {
    var e = window.event;

    b_table_blur = false;
    if ("none" !== obj.style.display && 13 === e.keyCode) {
        mc_table_blur(obj);
    }
}

// 页面调用 表格父级设置高显示滚动条
function table_init() {
    var table_box = document.getElementsByClassName("mc_table_box");

    if (0 !== table_box.length) {
        for (var idx = 0; idx < table_box.length; idx++) {
            var table_item = table_box[idx];

            if (0 !== table_item.parentNode.length) {
                table_item.parentNode.classList.add("table_flex_box_auto_size");
            }
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将当前格子坐标及值返回
 * 参数:
 *    @param { Promise<Object> } o_now_grid 当前格子
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.26
 *      内容 : 所有代码
 ************************************************************************************************/
function get_grid_pot(o_now_grid) {
    var arr_grid_pot = [];
    var o_ul_li = o_now_grid.parent().children();
    var o_ul = o_now_grid.parent().parent().children();

    for (var idx_li = 0; idx_li < o_ul_li.length; idx_li++) {
        if (o_ul_li.eq(idx_li)[0] === o_now_grid[0]) {
            arr_grid_pot.push(idx_li);
        }
    }
    for (var idx_ul = 0; idx_ul < o_ul.length; idx_ul++) {
        if (o_ul.eq(idx_ul)[0] === o_now_grid.parent()[0]) {
            arr_grid_pot.push(idx_ul);
        }
    }
    // return arr_grid_pot;
    // 格子坐标
    var i_pot_x = arr_grid_pot[0];
    var i_pot_y = arr_grid_pot[1];
    var str_grid_chg_val = o_now_grid.text();
    var str_fun_name = o_now_grid.parent().parent().parent().attr(g_str_attr_lab_val_chg);
    var str_control_type = o_now_grid.attr("control_type");

    if (str_control_type) {
        o_now_grid.attr("lang_id", str_grid_chg_val);
    }

    if ("string" === typeof str_fun_name && 0 < str_fun_name.length) {
        var str_id = o_now_grid.parent().parent().parent().attr("id");
        var fun_callback = g_obj_func_name_map[str_fun_name];

        if ("function" === typeof fun_callback) {
            fun_callback(str_id, str_grid_chg_val, i_pot_x, i_pot_y);
        }
    }
    o_now_grid.blur();
    return;
}

/********tab选项卡设定***********************************************************************/
// tab项点击添加选中样式 返回当前选中
function mc_tab_click(obj) {
    var o_parent = obj.parentNode;
    var arr_div_list = o_parent.children;
    var str_now_con = obj.getAttribute("tab_idx");

    for (var idx_li = 0; idx_li < arr_div_list.length; idx_li++) {
        var o_tab_item = arr_div_list[idx_li];

        o_tab_item.classList.remove("select_tab");
    }
    obj.classList.add("select_tab");
    o_parent.setAttribute("default_idx", str_now_con);

    // 将当前id与新的值返回
    var str_id = o_parent.getAttribute("id");
    var str_val = obj.innerText;

    return_new_value(o_parent, str_id, str_val);
}

// 页面调用 默认选中设置
function tab_init() {
    var tab_list = document.getElementsByClassName("mc_tab");

    if (0 !== tab_list.length) {
        for (var idx_tabs = 0; idx_tabs < tab_list.length; idx_tabs++) {
            var o_tab_box = tab_list[idx_tabs];
            var i_default_idx = parseInt(o_tab_box.getAttribute("default_idx"), 10);

            var arr_header = o_tab_box.children;

            for (var idx_item = 0; idx_item < arr_header.length; idx_item++) {
                arr_header[idx_item].classList.remove("select_tab");

                if (idx_item === i_default_idx) {
                    arr_header[idx_item].classList.add("select_tab");
                }
            }
        }
    }
}

/********文件选择器设定***********************************************************************/
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    文件选择器按钮点击事件
 * 参数:
 *    @param { Promise<Object> } obj 点击对象
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.6
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_clk_select_file(obj) {
    var str_readAsText = obj.getAttribute("b_readAsText");
    var obj_file = $(obj).next();
    var obj_num = $(obj).prev().children().eq(1);
    var obj_txt = obj_num.prev();

    obj_num.html("");
    // 启动文件选择
    obj_file.click();

    // 获取选择的内容
    // obj_file.change(function () {
    obj_file.off("change");
    obj_file.on("change", function () {
        var obj_target_inp = obj_file[0];
        var filelist = obj_target_inp.files;
        var obj_lang_map = mc_get_lang_obj();

        // if ( "function" === typeof mc_get_lang ) {
        //     obj_lang_map = mc_get_lang();
        // }


        if (!filelist) {
            return;
        }
        var ary_file_data = [];
        var str_txt = "";

        mc_save_file(0, filelist.length);
        str_txt = str_txt.substr(0, str_txt.length - 1);
        if (0 !== str_txt.length) {
            obj_txt.html(str_txt);
            if (0 !== obj_num.html().length) {
                obj_txt.attr("lang_id", "MC_LANG_SELECT_NUMBER_FILE");
            } else {
                obj_txt.attr("lang_id", str_txt);
                obj_num.html("");
            }
        } else {
            var str_text = "显示文件名称/选择文件个数";

            if (obj_lang_map) {
                str_text = obj_lang_map.get_item_val("MC_LANG_SHOW_FILE_NAME");
            }
            obj_txt.html(str_text);
            obj_num.html("");
            obj_txt.attr("lang_id", "MC_LANG_SHOW_FILE_NAME");
        }

        // 存储文件数据
        function mc_save_file(ui_idx, ui_total) {
            if ("number" !== typeof ui_idx || "number" !== typeof ui_total) {
                return false;
            }
            // 取消选择文件
            if (0 === ui_idx && 0 === ui_total) {
                return_new_value(obj, obj.getAttribute("id"), ary_file_data);
                return true;
            }
            if (ui_idx < ui_total) {
                var file_item = filelist[ui_idx];
                var str_file_name = file_item.name;
                var file_reader = new FileReader();

                file_reader.onloadend = function () {
                    var arr_uint8 = new Uint8Array(file_reader.result);

                    var obj_file_data = {
                        "file_name": str_file_name,
                        "file_extension": str_file_name.split(".").pop(),
                        "hexdata": mc_uint8tohex(arr_uint8),
                        "textdata": file_reader.result
                    };

                    ary_file_data.push(obj_file_data);
                    if (ui_idx === ui_total) {
                        // 返回文件数据
                        return_new_value(obj, obj.getAttribute("id"), ary_file_data);
                    }
                };
                str_txt += str_file_name + " ,";
                if ("true" === str_readAsText) {
                    file_reader.readAsText(file_item);
                } else {
                    file_reader.readAsArrayBuffer(file_item);
                }
                ui_idx++;
                mc_save_file(ui_idx, ui_total);
            } else {
                if (4 <= ui_idx) {
                    str_txt = "选择文件数量";
                    if (obj_lang_map) {
                        str_txt = obj_lang_map.get_item_val("MC_LANG_SELECT_NUMBER_FILE");
                    }
                    obj_num.html(" " + ui_idx);
                }
            }
            return true;
        }
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    二进制数组转16进制字符串
 * 参数:
 *    @param { Promise<String> } arr_data
 * 返回：
 *    @return { Promise<String> }
 *     str_hex 16进制数据字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.6
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_uint8tohex(arr_data) {
    var str_hex = "";

    for (var idx = 0; idx < arr_data.length; idx++) {
        var str_item = arr_data[idx].toString(16);

        if (2 > str_item.length) {
            str_item = "0" + str_item;
        }
        str_hex += str_item;
    }
    return str_hex;
}


/********选择语言开关设定***********************************************************************/
// 语言开关点击 target下拉选择
function select_lan_click(obj) {
    var select_ul = $(obj).next();
    var select_item = select_ul.children();
    var select_default = $(obj).find("span").text();

    if ("none" === select_ul.css("display")) {
        $(obj).find("i").addClass("edge_rotate");
        // 修改选中样式
        for (var idx_lan = 0; idx_lan < select_item.length; idx_lan++) {
            if (select_item.eq(idx_lan).text().substr(0, 3) === select_default) {
                select_item.eq(idx_lan).addClass("select_now_item").siblings().removeClass("select_now_item");
            }
        }
        select_ul.slideDown();
    } else {
        select_ul.slideUp();
        $(obj).find("i").removeClass("edge_rotate");
    }
}

// 语言开关失去焦点收起
function select_lan_blur(obj) {
    var select_ul = $(obj).next();

    if ("block" === select_ul.css("display")) {
        $(obj).find("i").removeClass("edge_rotate");
        select_ul.slideUp();
    }
}

// 下拉项点击
function select_contentli_click(obj) {
    var select_lan = $(obj).parent().prev();
    var select_ul = $(obj).parent();

    select_lan.find("span").text($(obj).html());

    if ("none" === select_ul.css("display")) {
        select_lan.find("i").addClass("edge_rotate");
        select_ul.slideDown();
    } else {
        select_ul.slideUp();
        select_lan.find("i").removeClass("edge_rotate");
    }

    // 返回选中的语言类型
    var str_val = $(obj).html();

    return_new_value(select_lan[0], "", str_val);
}

// 页面调用 点击开关外部收起
function select_lan_init() {
    var select_lan_list = document.getElementsByClassName("select_lan");

    if (0 !== select_lan_list.length) {
        for (var idx = 0; idx < select_lan_list.length; idx++) {
            var lan_ppatent = select_lan_list[idx].parentNode.parentNode;

            $(lan_ppatent).off("click");
            // eslint-disable-next-line no-loop-func
            $(lan_ppatent).on("click", function (e) {
                var lan_patent = $(select_lan_list[idx].parentNode);
                var select_ul = lan_patent.find("ul");
                var str_nodename = e.target.nodeName.toUpperCase();

                if ("SPAN" !== str_nodename && "I" !== str_nodename) {
                    lan_patent.find("div").find("i").removeClass("edge_rotate");
                    select_ul.slideUp();
                }
            });
        }
    }
}


/*******************控件转换语言相关***************************************************************/
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    创建lang_id及control_type 属性字串
 * 参数:
 *    @param { Promise<String> } str_content lang_id
 *    @param { Promise<Boolean> } b_set_lang_switch 是否添加land_id
 *    @param { Promise<String> } str_control_type 控件类型
 * 返回：
 *    @return { Promise<String> }
 *     "" 参数错误/当前不设置lang_id属性
 *     对应属性字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.5
 *      内容 : 所有代码
 ************************************************************************************************/
function judge_add_lang(str_content, b_set_lang_switch, str_control_type) {
    if ("boolean" !== typeof b_set_lang_switch || "string" !== typeof str_control_type || 0 === str_control_type.length) {
        return "";
    }
    if (b_set_lang_switch) {
        return "lang_id='" + str_content + "' control_type=" + str_control_type;
    }
    return "";
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取语言列表对象
 * 参数:
 *    NA
 * 返回：
 *    @return { Promise<Object> }
 *     null 获取失败
 *     obj_lang_map 语言列表对象
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.5
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_lang_obj() {
    var obj_lang_map = null;

    if ("function" === typeof mc_get_lang) {
        obj_lang_map = mc_get_lang();
    }
    if (obj_lang_map) {
        obj_lang_map = obj_lang_map.g_obj_lang;
    }
    return obj_lang_map;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    匹配语言列表获取当前字串翻译
 * 参数:
 *    @param { Promise<Object> } o_lang_map 语言对象
 *    @param { Promise<String> } str_lang lang_id
 * 返回：
 *    @return { Promise<String> }
 *     翻译字串
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.5
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_transform_lang(o_lang_map, str_lang) {
    if ("object" !== typeof o_lang_map || !o_lang_map || "string" !== typeof str_lang) {
        return str_lang;
    }
    return o_lang_map.get_item_val(str_lang);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    更新控件lang_id
 * 参数:
 *    @param { Promise<String> } str_lang lang_id
 *    @param { Promise<Object> } obj_control 控件对象jq
 * 返回：
 *    @return { Promise<Boolean> }
 *     false 参数有误
 *     true 更新成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.11.5
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_update_control_lang_id(str_lang, obj_control) {
    if (!str_lang || "string" !== typeof str_lang || 0 === str_lang.length || "object" !== typeof obj_control) {
        return false;
    }
    obj_control.attr("lang_id", str_lang);
    return true;
}

// **************************************** TOOL ************************************************ //
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置控件强制显示值
 * 参数:
 *    @param { Promise<Object> } obj
 *    @param { Promise<Object> } obj_txt
 *    @param { Promise<Boolean> } b_input
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.12.11
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_show_val_tool(obj,obj_txt,b_input) {
    if (!obj || !obj_txt) {
        return;
    }
    var str_val = obj.getAttribute("show_val");

    if (str_val && str_val.length) {
        if (b_input) {
            obj_txt.value = str_val;
        } else {
            obj_txt.innerText = str_val;
        }
    }
    return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    数组 filter 方法，兼容IE
 * 参数:
 *    @param { Promise<Function> } fun 过滤条件函数
 *    @param { Promise<Array> } arr_data 需过滤数组
 * 使用方式：
 *    mc_filter_tool(
 *       function testa(item, inde, array) {
 *           console.log(item, inde, array);
 *           return 5 == item; //过滤条件，根据自己需求修改
 *       },
 *       arr_data
 *   )
 * 返回：
 *    @return { Promise<Array> }
 *     [] 参数有误
 *     arr_res 过滤数组
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.04.21
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_filter_tool(fun, arr_data) {
    if ("[object Function]" !== Object.prototype.toString.call(fun) || "[object Array]" !== Object.prototype.toString.call(arr_data)) {
        return [];
    }
    var arr_res = [];
    var thisp = arguments[2];

    for (var idx = 0; idx < arr_data.length; idx++) {
        if (idx in arr_data) {
            var val = arr_data[idx];

            if (fun.call(thisp, val, idx, arr_data)) {
                arr_res.push(val);
            }
        }
    }
    return arr_res;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断是否存在touch事件
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<Boolean> }
 *    true PC端
 *    false 移动端
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.5.27
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_istouch() {
    var flag = true;

    if ("ontouchstart" in window) {
        flag = false;
    }
    return flag;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断是否在PC端
 * 参数:
 *    无
 * 返回：
 *    @return { Promise<Boolean> }
 *    true PC端
 *    false 移动端
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_ispc() {
    var flag = true;

    if ((/phone|pad|pod|iPhone|iPod|ios|iPad|Android|Mobile|BlackBerry|IEMobile|MQQBrowser|JUC|Fennec|wOSBrowser|BrowserNG|WebOS|Symbian|Windows Phone/i).test(navigator.userAgent)) {
        flag = false;
    }
    return flag;
}

/*******************other***********************************************************************/
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    div contenteditable=true 控制光标位置在最后
 * 参数:
 *    @param {Object} el 当前对象
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_focus(el) {
    el.focus();
    var range = document.createRange();

    range.selectNodeContents(el);
    range.collapse(false);
    var sel = window.getSelection();

    //判断光标位置，如不需要可删除
    if (0 !== sel.anchorOffset) {
        return;
    }
    sel.removeAllRanges();
    sel.addRange(range);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    取出函数名
 * 参数:
 *    @param {Function} func 函数
 * 返回：
 *    @return { Promise<String> }
 *     函数名称
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.11.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_func_key(func) {
    if ("function" !== typeof func) {
        return "";
    }

    /* 如果有必要，考虑使用 MDK 算func的哈希作为key */
    var func_name = func.toString().split("(")[0].split(" ")[1];

    func_name = func_name.trim();
    func_name = func_name.toLowerCase();

    if ("string" === typeof func_name && 0 < func_name.length && "function" !== typeof g_obj_func_name_map[func_name]) {
        g_obj_func_name_map[func_name] = func;
    }

    return func_name;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    过渡动画结束后 重置滚动条
 * 参数:
 *    @param { Promise<String> } str_jq_select 过渡动画所在对象名
 *    @param { Promise<String> } str_jq_select_scroll 滚动条所在对象名
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.10
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_updata_scroll_bar_after_trans(str_jq_select, str_jq_select_scroll) {
    if ("string" !== typeof str_jq_select || 0 === str_jq_select.length || "string" !== typeof str_jq_select_scroll || 0 === str_jq_select_scroll.length) {
        return;
    }
    // PC端生效
    var b_istouch = mc_ispc();

    if (b_istouch) {
        $(str_jq_select).off("transitionend webkitTransitionEnd");
        $(str_jq_select).on("transitionend webkitTransitionEnd", function () {
            $(str_jq_select_scroll).getNiceScroll().resize();
        });
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    加载添加loading
 * 参数:
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2019.12.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_loading_wait() {
    parent.mc_loading_wait();
}

// 加载完成去除loading
function mc_loading_wait_remove() {
    parent.mc_loading_wait_remove();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    数值改变返回新数值/元素id及新值
 * 参数:
 *    @param { Promise<Object> } o_obj 触发函数的对象
 *    @param { Promise<String> } str_id 被操作元素的id值
 *    @param { Promise<String> } str_new_value 所要返回的新值
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.03.04
 *      内容 : 所有代码
 ************************************************************************************************/
function return_new_value(o_obj, str_id, str_new_value) {
    var str_fun_name = o_obj.getAttribute(g_str_attr_lab_val_chg);

    if ("string" === typeof str_fun_name && 0 < str_fun_name.length) {
        var fun_callback = g_obj_func_name_map[str_fun_name];

        if ("function" === typeof fun_callback) {
            if ("" === str_id) {
                fun_callback(str_new_value);
            } else {
                fun_callback(str_id, str_new_value);
            }
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将右栏收起
 * 参数:
 *    @param { Promise<Object> } target 侧栏所在父级 可为空
 * 返回：
 *    无
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.04.11
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_packup_side(target) {
    $(document).off("click");
    $(document).on("click", function () {
        var mc_opt_select = document.getElementsByClassName("mc_opt_select");
        var parent = window.parent;

        if (target) {
            parent = target;
        }
        var obj_side = parent.document.getElementsByClassName("mc_wrap_div_side_cont")[0];
        var arr_open_side_item = parent.arr_open_side_item;

        if (0 === mc_opt_select.length && obj_side) {
            obj_side.classList.remove("set_pushpin");
            obj_side.classList.remove("add_side_width");
            parent.str_prev_side_name = "";

            if (0 !== arr_open_side_item.length) {
                arr_open_side_item[0].classList.remove("wrap_side_select_btn");
                parent.arr_open_side_item = [];
            }
        }
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    停止事件冒泡行为 阻止默认行为
 * 参数:
 *    @param {Promise<Object>} e 事件对象
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.9
 *      内容 : 所有代码
 ************************************************************************************************/
function clearBubble(e) {
    if (!e) {
        e = window.event;
    }
    if (!e) {
        return;
    }
    if (e.stopPropagation) {
        e.stopPropagation();
    } else {
        e.cancelBubble = true;
    }

    if (e.preventDefault) {
        e.preventDefault();
    } else {
        e.returnValue = false;
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    阻止浏览器默认动作 兼容IE
 * 参数:
 *    @param {Promise<Object>} event 事件对象
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.17
 *      内容 : 所有代码
 ************************************************************************************************/
function preventDefault(event) {
    if (document.all) {
        window.event.returnValue = false;
    } else {
        event.preventDefault();
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    字符串检验
 *      --- 结尾为"%"/"px"
 *      --- 前部分可转换为数字
 *      --- 若开头为calc 直接返回true
 * 参数:
 *     @param { Promise<String> } str_check 检验字串
 * 返回：
 *     @return { Promise<Boolean> }
 *      false 参数有误/不符合要求
 *      true 成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.03.09
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_check_strend(str_check) {
    if ("[object String]" !== Object.prototype.toString.call(str_check) || 0 === str_check.length) {
        return false;
    }
    if ("calc" === str_check.trim().substr(0, 4).toLowerCase()) {
        return true;
    }
    var str = "px";
    var num = Number(str_check.substr(0, str.length - 1));

    if (str === str_check.substr(-str.length) && "[object Number]" === Object.prototype.toString.call(num) && !isNaN(num)) {
        return true;
    }
    str = "%";
    if (str === str_check.substr(-str.length) && "[object Number]" === Object.prototype.toString.call(num) && !isNaN(num)) {
        return true;
    }

    return false;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断输入字串是否为颜色类型
 * 参数:
 *     @param { Promise<String> } strcolor 颜色字串
 * 返回：
 *     @return { Promise<Boolean> }
 *      false 参数有误/不符合要求
 *      true 成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.03.09
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_inspect_color(strcolor) {
    if ("[object String]" !== Object.prototype.toString.call(strcolor)) {
        return false;
    }
    var oSpan = document.createElement("span");

    oSpan.style.color = strcolor;
    if ("" !== oSpan.style.color) {
        return true;
    }

    oSpan = null;
    return false;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取当前鼠标位置
 * 参数:
 *    @param { Promise<Window> } obj_window
 *    @param { Promise<Object> } eve
 * 返回：
 *    @return { Promise<Object> }
 *      { X: aui_base_pnt_x, Y: aui_base_pnt_y }
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.02.19
 *      内容 : 所有代码
 ************************************************************************************************/
function get_cur_pos(obj_window,eve) {
    var aui_base_pnt_x = 0;
    var aui_base_pnt_y = 0;
    var event = null;

    if (obj_window) {
        event = obj_window.event;
    } else {
        event = window.event;
    }
    if (eve) {
        event = eve;
    }
    if (event.pageX || event.pageY) {
        aui_base_pnt_x = event.pageX;
        aui_base_pnt_y = event.pageY;
    } else if (event.clientX || event.clientY) {
        aui_base_pnt_x = event.clientX + document.documentElement.scrollLeft + document.body.scrollLeft;
        aui_base_pnt_y = event.clientY + document.documentElement.scrollTop + document.body.scrollTop;
    }

    return { X: aui_base_pnt_x, Y: aui_base_pnt_y };
}

/*******************获取/设置-顶层数据***************************************************************/
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置页面小标题内容 (翻译)
 * 参数:
 *     @param { Promise<Object> } obj_lang_map 语言列表对象
 *     @param { Promise<String> } str_icon icon图标字串
 *     @param { Promise<String> } str_title_key 自定义lang_id 多页面使用同个html
 * 返回：
 *     @return { Promise<Boolean> }
 *      false 参数有误
 *      true 设置成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.05.05
 *      内容 : 所有代码
 ************************************************************************************************/
function set_page_title(obj_lang_map, str_icon, str_title_key) {
    if ("object" !== typeof obj_lang_map || "string" !== typeof str_icon || 0 === str_icon.length) {
        return false;
    }

    var obj_page_title = parent.document.getElementById("page_title");
    var obj_page_title_icon = parent.document.getElementById("page_title_icon");


    if (obj_page_title) {
        obj_page_title.style.display = "flex";
    }

    if (obj_page_title_icon) {
        obj_page_title_icon.className = "";
        obj_page_title_icon.classList.add(str_icon);
    }


    if (!str_title_key) {
        str_title_key = document.getElementsByTagName("title")[0].getAttribute("lang_id");
    }

    if ("string" === typeof str_title_key && 0 < str_title_key.length) {
        var str_val = obj_lang_map[str_title_key.toUpperCase()];

        if ("string" === typeof str_val && 0 < str_val.length) {
            if (parent.document.getElementById("page_title_lang")) {
                parent.document.getElementById("page_title_lang").innerHTML = str_val;
            }
        }
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    调用main页面提示框 - 适用于mian子页面调用
 * 参数:
 *    @param {Promise<String>} str_msg 提示信息字串 语言ID
 *    @param {Promise<String>} str_alert_close_callback 弹框关闭回调 可为空
 *    @param {Promise<Boolean>} b_close_iframe 不允许关闭iframe弹层页面 ture不关闭 可为空
 *    @param {Promise<Object>} obj_target main极页面对象
 * 返回：
 *    @returns {Promise<Boolean>}
 *     true 调用成功
 *     false 参数有误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.6.18
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_alert_popout(str_msg, str_alert_close_callback, b_close_iframe, obj_target) {
    if ("string" !== typeof str_msg || 0 === str_msg.length) {
        return false;
    }
    if (obj_target) {
        obj_target.mc_alert_popout(str_msg, str_alert_close_callback, b_close_iframe);
    } else {
        parent.mc_alert_popout(str_msg, str_alert_close_callback, b_close_iframe);
    }
    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取最顶层数据
 * 参数:
 *    @param {Promise<String>} str_data_name 数据名称
 * 返回：
 *    @returns {Promise<Object>}
 *     data
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.7.15
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_top_data(str_data_name) {
    if ("string" !== typeof str_data_name || 0 === str_data_name.length) {
        return false;
    }
    var parent_page = parent;
    var data = null;

    while (parent_page) {
        if ("undefined" !== typeof (parent_page[str_data_name])) {
            data = parent_page[str_data_name];
            break;
        } else if (parent_page !== parent_page.parent) {
            parent_page = parent_page.parent;
        } else {
            break;
        }
    }
    return data;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置最顶层数据
 * 参数:
 *    @param {Promise<String>} str_data_name 数据名称
 *    @param {Promise<Any>} str_data_val 数据值
 * 返回：
 *    @returns {Promise<Boolean>}
 *     false 参数错误或顶层无此数据声明
 *     true 设置成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_top_data(str_data_name, str_data_val) {
    if ("string" !== typeof str_data_name || 0 === str_data_name.length) {
        return false;
    }
    var parent_page = parent;
    var b_set = false;

    while (parent_page) {
        if ("undefined" !== typeof (parent_page[str_data_name])) {
            parent_page[str_data_name] = str_data_val;
            b_set = true;
            break;
        } else if (parent_page !== parent_page.parent) {
            parent_page = parent_page.parent;
        } else {
            break;
        }
    }
    return b_set;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    调用最顶层函数 - 最多可支持传递三个参数
 * 参数:
 *    @param {Promise<String>} str_fun_name 函数名称
 *    @param {Promise<Any>} param 参数 可为空
 *    @param {Promise<Any>} params 参数2 可为空
 *    @param {Promise<Any>} paramss 参数3 可为空
 *    @param {Promise<Boolean>} b_return_result 是否返回调用函数结果 可为空
 * 返回：
 *    @returns {Promise<Boolean>}
 *     false 参数错误或顶层无此数据声明
 *     true 设置成功
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_top_fun(str_fun_name, param, params, paramss,b_return_result) {
    if ("string" !== typeof str_fun_name || 0 === str_fun_name.length) {
        return false;
    }
    var parent_page = parent;
    var b_get = false;
    var result = null;

    while (parent_page) {
        if ("undefined" !== typeof (parent_page[str_fun_name])) {
            result = parent_page[str_fun_name](param, params, paramss);
            b_get = true;
            break;
        } else if (parent_page !== parent_page.parent) {
            parent_page = parent_page.parent;
        } else {
            break;
        }
    }
    if (b_return_result && result) {
        return result;
    }
    return b_get;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取最顶层对象
 * 参数:
 *    @param {Promise<String>} str_id 目标对象id
 * 返回：
 *    @returns {Promise<Object>}
 *     object
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.8.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_top_object(str_id) {
    if ("string" !== typeof str_id || 0 === str_id.length) {
        return false;
    }
    var parent_page = parent;
    var object = null;

    while (parent_page) {
        var obj_target = parent_page.document.getElementById(str_id);

        if (obj_target) {
            object = obj_target;
            break;
        } else if (parent_page !== parent_page.parent) {
            parent_page = parent_page.parent;
        } else {
            break;
        }
    }
    return object;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置iframe高度适应内容
 * 参数:
 *    @param {Promise<Object>} o_document iframe所在document对象
 *    @param {Promise<Object>} ui_height 当前高度 可为空
 * 返回：
 *    NA
 *     object
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.26
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_iframe_autoheight(o_document, ui_height) {
    var ifm = o_document.getElementsByTagName("iframe")[0];
    var subWeb = o_document.frames ? o_document.frames.iframeId.o_document : ifm.contentDocument;

    if (null !== ifm && null !== subWeb) {
        ifm.style.height = "auto";
        if (ui_height) {
            ifm.style.height = ui_height + "px";
        } else {
            ifm.style.height = subWeb.body.scrollHeight + "px";
        }
    }
}


/*******************解决浮点类型数据计算精度问题***************************************************/
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    加
 * 参数:
 *    @param {Promise<String/Numbel>} num1
 *    @param {Promise<String/Numbel>} num2
 * 返回：
 *    @returns {Promise<Number>}
 *     相加结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_compute_add(num1, num2) {
    num1 = Number(num1);
    num2 = Number(num2);
    var dec1, dec2, times;

    try {
        dec1 = mc_count_decimals(num1) + 1;
    } catch (e) {
        dec1 = 0;
    }
    try {
        dec2 = mc_count_decimals(num2) + 1;
    } catch (e) {
        dec2 = 0;
    }
    times = Math.pow(10, Math.max(dec1, dec2));
    var result = (mc_compute_mul(num1, times) + mc_compute_mul(num2, times)) / times;

    return mc_get_correct_result("add", num1, num2, result);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    减
 * 参数:
 *    @param {Promise<String/Numbel>} num1
 *    @param {Promise<String/Numbel>} num2
 * 返回：
 *    @returns {Promise<Number>}
 *     相减结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_compute_sub(num1, num2) {
    num1 = Number(num1);
    num2 = Number(num2);
    var dec1, dec2, times;

    try {
        dec1 = mc_count_decimals(num1) + 1;
    } catch (e) {
        dec1 = 0;
    }
    try {
        dec2 = mc_count_decimals(num2) + 1;
    } catch (e) {
        dec2 = 0;
    }
    times = Math.pow(10, Math.max(dec1, dec2));
    var result = Number((mc_compute_mul(num1, times) - mc_compute_mul(num2, times)) / times);

    return mc_get_correct_result("sub", num1, num2, result);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    除
 * 参数:
 *    @param {Promise<String/Numbel>} num1
 *    @param {Promise<String/Numbel>} num2
 * 返回：
 *    @returns {Promise<Number>}
 *     相除结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_compute_div(num1, num2) {
    num1 = Number(num1);
    num2 = Number(num2);
    var dec1, dec2, t1 = 0, t2 = 0;

    t1 = mc_count_decimals(num1);
    t2 = mc_count_decimals(num2);
    dec1 = mc_convert_toint(num1);
    dec2 = mc_convert_toint(num2);
    var result = mc_compute_mul((dec1 / dec2), Math.pow(10, t2 - t1));

    return mc_get_correct_result("div", num1, num2, result);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    乘
 * 参数:
 *    @param {Promise<String/Numbel>} num1
 *    @param {Promise<String/Numbel>} num2
 * 返回：
 *    @returns {Promise<Number>}
 *     相乘结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_compute_mul(num1, num2) {
    num1 = Number(num1);
    num2 = Number(num2);
    var times = 0;
    var s1 = num1.toString(), s2 = num2.toString();

    times += mc_count_decimals(s1);
    times += mc_count_decimals(s2);
    var result = mc_convert_toint(s1) * mc_convert_toint(s2) / Math.pow(10, times);

    return mc_get_correct_result("mul", num1, num2, result);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    计算小数位长度
 * 参数:
 *    @param {Promise<String/Numbel>} num
 * 返回：
 *    @returns {Promise<Number>}
 *     相加结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_count_decimals(num) {
    var len = 0;

    num = Number(num);
    var str = num.toString().toUpperCase();

    if (2 === str.split("E").length) {
        var isDecimal = false;

        if (2 === str.split(".").length) {
            str = str.split(".")[1];
            if (0 !== parseInt(str.split("E")[0], 10)) {
                isDecimal = true;
            }
        }
        var x = str.split("E");

        if (isDecimal) {
            len = x[0].length;
        }
        len -= parseInt(x[1], 10);
    // 十进制
    } else if (2 === str.split(".").length) {
        if (0 !== parseInt(str.split(".")[1], 10)) {
            len = str.split(".")[1].length;
        }
    }
    if (isNaN(len) || 0 > len) {
        len = 0;
    }
    return len;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将小数转换成整数
 * 参数:
 *    @param {Promise<String/Numbel>} num
 * 返回：
 *    @returns {Promise<Number>}
 *     相加结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_convert_toint(num) {
    num = Number(num);
    var newNum = num;
    var times = mc_count_decimals(num);
    var temp_num = num.toString().toUpperCase();

    if (2 === temp_num.split("E").length) {
        newNum = Math.round(num * Math.pow(10, times));
    } else {
        newNum = Number(temp_num.replace(".", ""));
    }
    return newNum;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    检验计算结果
 * 参数:
 *    @param {Promise<Numbel>} type 运算类型
 *    @param {Promise<Numbel>} num1
 *    @param {Promise<Numbel>} num2
 *    @param {Promise<Numbel>} result 计算结果
 * 返回：
 *    @returns {Promise<Number>}
 *     最终结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.14
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_correct_result(type, num1, num2, result) {
    var temp_result = 0;

    switch (type) {
    case "add":
        temp_result = num1 + num2;
        break;
    case "sub":
        temp_result = num1 - num2;
        break;
    case "div":
        temp_result = num1 / num2;
        break;
    case "mul":
        temp_result = num1 * num2;
        break;
    default:
        break;
    }

    if (1 < Math.abs(result - temp_result)) {
        return temp_result;
    }
    return result;
}

/************************计算变换后模组信息相关***************************************************/
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    计算未变换矩形四点坐标
 * 参数:
 *     @param {Promise<Number>} ui_x x偏移
 *     @param {Promise<Number>} ui_y y偏移
 *     @param {Promise<Number>} ui_w width
 *     @param {Promise<Number>} ui_h height
 * 返回：
 *     @returns {Promise<Array>}
 *      arr_coordinate 对应四点坐标
 *      false 参数有误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.27
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_calculating_coordinates(ui_x, ui_y, ui_w, ui_h) {
    var arr_coordinate = [];

    arr_coordinate[0] = [ui_x, ui_y];
    arr_coordinate[1] = [ui_x + ui_w, ui_y];
    arr_coordinate[2] = [ui_x, ui_y + ui_h];
    arr_coordinate[3] = [ui_x + ui_w, ui_y + ui_h];
    return arr_coordinate;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    计算变换后坐标临界值
 * 参数:
 *     @param {Promise<Array>} arr_coordinate 变换前元素临点坐标
 *     @param {Promise<Number>} ui_rotate_angle 旋转角度值
 * 返回：
 *     @returns {Promise<Boolean>}
 *      坐标临界值[minX,minY,maxX,maxY]
 *      false 参数有误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.10.27
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_calculating_critical_coordinates(arr_coordinate, ui_rotate_angle) {
    if ("[object Array]" !== Object.prototype.toString.call(arr_coordinate) || "[object Number]" !== Object.prototype.toString.call(ui_rotate_angle) || isNaN(ui_rotate_angle)) {
        return false;
    }
    var arr_origin = arr_coordinate[0];
    // 最小left/top为旋转后位置
    var ui_min_x = arr_origin[0];
    var ui_min_y = arr_origin[1];
    var ui_max_x = arr_origin[0];
    var ui_max_y = arr_origin[1];

    // 计算旋转后临点坐标
    for (var idx = 1; idx < arr_coordinate.length; idx++) {
        var arr_dot = arr_coordinate[idx];

        arr_dot = mc_rotate_coordinate(arr_origin, arr_dot, ui_rotate_angle);
        var ui_rotate_x = arr_dot[0];
        var ui_rotate_y = arr_dot[1];

        if (ui_min_x > ui_rotate_x) {
            ui_min_x = ui_rotate_x;
        }
        if (ui_min_y > ui_rotate_y) {
            ui_min_y = ui_rotate_y;
        }
        if (ui_max_x < ui_rotate_x) {
            ui_max_x = ui_rotate_x;
        }
        if (ui_max_y < ui_rotate_y) {
            ui_max_y = ui_rotate_y;
        }
    }
    return [ui_min_x, ui_min_y, ui_max_x, ui_max_y];

    // 旋转基点坐标 计算点坐标 旋转角度
    function mc_rotate_coordinate(ary_origin, ary_coordinate, u_rotate_angle) {
        if ("[object Array]" !== Object.prototype.toString.call(ary_origin) || "[object Array]" !== Object.prototype.toString.call(ary_coordinate) || "[object Number]" !== Object.prototype.toString.call(u_rotate_angle)) {
            return false;
        }
        var arr_result = [];
        var ui_xo = Number(ary_origin[0]);
        var ui_yo = Number(ary_origin[1]);
        var ui_x = Number(ary_coordinate[0]);
        var ui_y = Number(ary_coordinate[1]);
        var cosVal = Math.cos(u_rotate_angle * Math.PI / 180), sinVal = Math.sin(u_rotate_angle * Math.PI / 180);

        arr_result[0] = (ui_x - ui_xo) * cosVal - (ui_y - ui_yo) * sinVal + ui_xo;
        arr_result[1] = (ui_x - ui_xo) * sinVal + (ui_y - ui_yo) * cosVal + ui_yo;
        return arr_result;
    }
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    根据模组信息 获取模块偏移大小信息对象
* 参数:
*    @param { Promise<Object> } obj_params
* 备注:
*   obj_params = {
*       rotation: "0,0,0",
*       scale: "0,0,1,1",
*       offset_x: 0,
*       offset_y: 0,
*       width: 0, 模组宽
*       height: 0 模组高
*   }
* 返回：
*    @return { Promise<Object> }
*     偏移大小信息对象
* 修改:
*   1. 类型 : 创建
*      作者 : 陈小荟
*      时间 : 2020.10.27
*      内容 : 所有代码
************************************************************************************************/
function mc_get_module_msg(obj_params) {
    if ("[object Object]" !== Object.prototype.toString.call(obj_params)) {
        return false;
    }
    // 效验参数----------
    // 旋转
    var str_rotate = obj_params.rotation;

    if (str_rotate && "string" === typeof str_rotate) {
        var arr_rotate = str_rotate.split(",");

        // 只有旋转角度情况
        if (1 === arr_rotate.length) {
            str_rotate = "0,0," + str_rotate;
        }

        if (3 !== str_rotate.split(",").length) {
            return obj_params;
        }
    } else {
    // 不存在情况
        str_rotate = "0,0,0";
    }

    // 缩放
    var str_scale = obj_params.scale;

    if (str_scale && "string" === typeof str_scale) {
        var arr_scale = str_scale.split(",");

        // 无缩放基准点情况
        if (2 === arr_scale.length) {
            str_scale = "0,0," + arr_scale[0] + "," + arr_scale[1];
        }

        if (4 !== str_scale.split(",").length) {
            return obj_params;
        }
    } else {
    // 不存在情况
        str_scale = "0,0,1,1";
    }

    // 计算大小----------
    var ui_rotate_angle = Number(str_rotate.split(",")[2]);
    var ary_scale = str_scale.split(",");
    var ui_scale_x = Number(ary_scale[2]);
    var ui_scale_y = Number(ary_scale[3]);
    var ui_offset_x = Number(obj_params.offset_x);
    var ui_offset_y = Number(obj_params.offset_y);
    var ui_width = Number(obj_params.width);
    var ui_height = Number(obj_params.height);
    var arr_coordinate = [];

    // 未变换前元素四点坐标
    arr_coordinate = mc_calculating_coordinates(ui_offset_x, ui_offset_y, ui_width * ui_scale_x, ui_height * ui_scale_y);
    // 变换后元素临界坐标值
    var arr_critical_val = mc_calculating_critical_coordinates(arr_coordinate, ui_rotate_angle);

    // 获取外接矩形大小
    ui_width = Math.round(arr_critical_val[2] - arr_critical_val[0]);
    ui_height = Math.round(arr_critical_val[3] - arr_critical_val[1]);
    var obj_msg = {
        offset_x: ui_offset_x,
        offset_y: ui_offset_y,
        width: ui_width,
        height: ui_height
    };

    return obj_msg;
}
